/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.TransformNodesCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;

public class RotateCommand
extends TransformNodesCommand {
    private final EastNorth pivot = this.getNodesCenter();
    private final double startAngle;
    private double rotationAngle;

    public RotateCommand(Collection<OsmPrimitive> collection, EastNorth eastNorth) {
        super(collection);
        this.startAngle = this.getAngle(eastNorth);
        this.rotationAngle = 0.0;
        this.handleEvent(eastNorth);
    }

    protected final double getAngle(EastNorth eastNorth) {
        if (this.pivot == null) {
            return 0.0;
        }
        return Math.atan2(eastNorth.east() - this.pivot.east(), eastNorth.north() - this.pivot.north());
    }

    @Override
    public final void handleEvent(EastNorth eastNorth) {
        double d = this.getAngle(eastNorth);
        this.rotationAngle = d - this.startAngle;
        this.transformNodes();
    }

    @Override
    protected void transformNodes() {
        for (Node node : this.nodes) {
            double d = Math.cos(this.rotationAngle);
            double d2 = Math.sin(this.rotationAngle);
            EastNorth eastNorth = ((Command.OldNodeState)this.oldStates.get(node)).getEastNorth();
            double d3 = eastNorth.east() - this.pivot.east();
            double d4 = eastNorth.north() - this.pivot.north();
            double d5 = d * d3 + d2 * d4 + this.pivot.east();
            double d6 = -d2 * d3 + d * d4 + this.pivot.north();
            node.setEastNorth(new EastNorth(d5, d6));
        }
    }

    @Override
    public String getDescriptionText() {
        return I18n.trn("Rotate {0} node", "Rotate {0} nodes", this.nodes.size(), this.nodes.size());
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.pivot == null ? 0 : this.pivot.hashCode());
        long l = Double.doubleToLongBits(this.rotationAngle);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.startAngle);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RotateCommand rotateCommand = (RotateCommand)object;
        if (this.pivot == null ? rotateCommand.pivot != null : !this.pivot.equals(rotateCommand.pivot)) {
            return false;
        }
        if (Double.doubleToLongBits(this.rotationAngle) != Double.doubleToLongBits(rotateCommand.rotationAngle)) {
            return false;
        }
        return Double.doubleToLongBits(this.startAngle) == Double.doubleToLongBits(rotateCommand.startAngle);
    }
}

