/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileJob;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;

public class OsmTileLoader
implements TileLoader {
    private static final Executor jobDispatcher = Executors.newSingleThreadExecutor();
    public Map<String, String> headers = new HashMap<String, String>();
    public int timeoutConnect;
    public int timeoutRead;
    protected TileLoaderListener listener;

    public OsmTileLoader(TileLoaderListener tileLoaderListener) {
        this(tileLoaderListener, null);
    }

    public OsmTileLoader(TileLoaderListener tileLoaderListener, Map<String, String> map) {
        this.headers.put("Accept", "text/html, image/png, image/jpeg, image/gif, */*");
        if (map != null) {
            this.headers.putAll(map);
        }
        this.listener = tileLoaderListener;
    }

    @Override
    public TileJob createTileLoaderJob(Tile tile) {
        return new OsmTileJob(tile);
    }

    protected URLConnection loadTileFromOsm(Tile tile) throws IOException {
        URL uRL = new URL(tile.getUrl());
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof HttpURLConnection) {
            this.prepareHttpUrlConnection((HttpURLConnection)uRLConnection);
        }
        return uRLConnection;
    }

    protected void loadTileMetadata(Tile tile, URLConnection uRLConnection) {
        Long l;
        block8: {
            String string = uRLConnection.getHeaderField("X-VE-TILEMETA-CaptureDatesRange");
            if (string != null) {
                tile.putValue("capture-date", string);
            }
            if ((string = uRLConnection.getHeaderField("X-VE-Tile-Info")) != null) {
                tile.putValue("tile-info", string);
            }
            if ((l = Long.valueOf(uRLConnection.getExpiration())).equals(0L)) {
                try {
                    string = uRLConnection.getHeaderField("Cache-Control");
                    if (string != null) {
                        for (String string2 : string.split(",")) {
                            if (!string2.startsWith("max-age=")) continue;
                            l = Long.parseLong(string2.substring(8)) * 1000L + System.currentTimeMillis();
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (!JMapViewer.debug) break block8;
                    System.err.println(numberFormatException.getMessage());
                }
            }
        }
        if (!l.equals(0L)) {
            tile.putValue("expires", l.toString());
        }
    }

    protected void prepareHttpUrlConnection(HttpURLConnection httpURLConnection) {
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        if (this.timeoutConnect != 0) {
            httpURLConnection.setConnectTimeout(this.timeoutConnect);
        }
        if (this.timeoutRead != 0) {
            httpURLConnection.setReadTimeout(this.timeoutRead);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void cancelOutstandingTasks() {
    }

    private final class OsmTileJob
    implements TileJob {
        private final Tile tile;
        private InputStream input;
        private boolean force;

        private OsmTileJob(Tile tile) {
            this.tile = tile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.tile;
            synchronized (object) {
                if (this.tile.isLoaded() && !this.tile.hasError() || this.tile.isLoading()) {
                    return;
                }
                this.tile.loaded = false;
                this.tile.error = false;
                this.tile.loading = true;
            }
            try {
                object = OsmTileLoader.this.loadTileFromOsm(this.tile);
                if (this.force) {
                    ((URLConnection)object).setUseCaches(false);
                }
                OsmTileLoader.this.loadTileMetadata(this.tile, (URLConnection)object);
                if ("no-tile".equals(this.tile.getValue("tile-info"))) {
                    this.tile.setError("No tile at this zoom level");
                } else {
                    this.input = ((URLConnection)object).getInputStream();
                    try {
                        this.tile.loadImage(this.input);
                    }
                    finally {
                        this.input.close();
                        this.input = null;
                    }
                }
                this.tile.setLoaded(true);
                OsmTileLoader.this.listener.tileLoadingFinished(this.tile, true);
            }
            catch (Exception exception) {
                this.tile.setError(exception.getMessage());
                OsmTileLoader.this.listener.tileLoadingFinished(this.tile, false);
                if (this.input == null) {
                    try {
                        System.err.println("Failed loading " + this.tile.getUrl() + ": " + exception.getClass() + ": " + exception.getMessage());
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            finally {
                this.tile.loading = false;
                this.tile.setLoaded(true);
            }
        }

        @Override
        public Tile getTile() {
            return this.tile;
        }

        @Override
        public void submit() {
            this.submit(false);
        }

        @Override
        public void submit(boolean bl) {
            this.force = bl;
            jobDispatcher.execute(this);
        }
    }
}

