/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.livejvm;

import java.io.UnsupportedEncodingException;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerException;

class CStringAccessor {
    private Address addr;
    private int bufLen;

    CStringAccessor(Address addr, int bufLen) {
        this.addr = addr;
        this.bufLen = bufLen;
    }

    String getValue() throws DebuggerException {
        int len;
        for (len = 0; this.addr.getCIntegerAt(len, 1L, true) != 0L && len < this.bufLen; ++len) {
        }
        byte[] res = new byte[len];
        for (int i = 0; i < len; ++i) {
            res[i] = (byte)this.addr.getCIntegerAt(i, 1L, true);
        }
        try {
            return new String(res, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new DebuggerException("Unable to use US-ASCII encoding");
        }
    }

    void setValue(String value) throws DebuggerException {
        try {
            byte[] data = value.getBytes("US-ASCII");
            if (data.length >= this.bufLen) {
                throw new DebuggerException("String too long");
            }
            for (int i = 0; i < data.length; ++i) {
                this.addr.setCIntegerAt(i, 1L, data[i]);
            }
            this.addr.setCIntegerAt(data.length, 1L, 0L);
        }
        catch (UnsupportedEncodingException e) {
            throw new DebuggerException("Unable to use US-ASCII encoding");
        }
    }
}

