/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ci;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.ci.ciObject;
import sun.jvm.hotspot.ci.ciReceiverTypeData;
import sun.jvm.hotspot.ci.ciVirtualCallData;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.BitData;
import sun.jvm.hotspot.oops.BranchData;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.oops.CounterData;
import sun.jvm.hotspot.oops.DataLayout;
import sun.jvm.hotspot.oops.JumpData;
import sun.jvm.hotspot.oops.MethodData;
import sun.jvm.hotspot.oops.MultiBranchData;
import sun.jvm.hotspot.oops.ProfileData;
import sun.jvm.hotspot.oops.RetData;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class ciMethodData
extends ciObject {
    private static AddressField origField;
    private static CIntField currentMileageField;
    private static CIntField argReturnedField;
    private static CIntField argStackField;
    private static CIntField argLocalField;
    private static CIntField eflagsField;
    private static CIntField hintDiField;
    private static AddressField dataField;
    private static CIntField extraDataSizeField;
    private static CIntField dataSizeField;
    private static CIntField stateField;
    private static int sizeofMethodDataOopDesc;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("ciMethodData");
        origField = type.getAddressField("_orig");
        currentMileageField = new CIntField(type.getCIntegerField("_current_mileage"), 0L);
        argReturnedField = new CIntField(type.getCIntegerField("_arg_returned"), 0L);
        argStackField = new CIntField(type.getCIntegerField("_arg_stack"), 0L);
        argLocalField = new CIntField(type.getCIntegerField("_arg_local"), 0L);
        eflagsField = new CIntField(type.getCIntegerField("_eflags"), 0L);
        hintDiField = new CIntField(type.getCIntegerField("_hint_di"), 0L);
        currentMileageField = new CIntField(type.getCIntegerField("_current_mileage"), 0L);
        dataField = type.getAddressField("_data");
        extraDataSizeField = new CIntField(type.getCIntegerField("_extra_data_size"), 0L);
        dataSizeField = new CIntField(type.getCIntegerField("_data_size"), 0L);
        stateField = new CIntField(type.getCIntegerField("_state"), 0L);
        sizeofMethodDataOopDesc = (int)db.lookupType("methodDataOopDesc").getSize();
    }

    public ciMethodData(Address addr) {
        super(addr);
    }

    private byte[] fetchDataAt(Address base, long size) {
        byte[] result = new byte[(int)size];
        int i = 0;
        while ((long)i < size) {
            result[i] = base.getJByteAt(i);
            ++i;
        }
        return result;
    }

    public byte[] orig() {
        Address base = this.getAddress().addOffsetTo(origField.getOffset());
        byte[] result = new byte[MethodData.sizeofMethodDataOopDesc];
        for (int i = 0; i < MethodData.sizeofMethodDataOopDesc; ++i) {
            result[i] = base.getJByteAt(i);
        }
        return result;
    }

    public long[] data() {
        Address base = dataField.getValue(this.getAddress());
        int elements = this.dataSize() / MethodData.cellSize;
        long[] result = new long[elements];
        for (int i = 0; i < elements; ++i) {
            Address value = base.getAddressAt(i * MethodData.cellSize);
            if (value == null) continue;
            result[i] = value.minus(null);
        }
        return result;
    }

    int dataSize() {
        return (int)dataSizeField.getValue(this.getAddress());
    }

    int state() {
        return (int)stateField.getValue(this.getAddress());
    }

    int currentMileage() {
        return (int)currentMileageField.getValue(this.getAddress());
    }

    boolean outOfBounds(int dataIndex) {
        return dataIndex >= this.dataSize();
    }

    ProfileData dataAt(int dataIndex) {
        if (this.outOfBounds(dataIndex)) {
            return null;
        }
        DataLayout dataLayout = new DataLayout(dataField.getValue(this.getAddress()), dataIndex);
        switch (dataLayout.tag()) {
            default: {
                throw new InternalError();
            }
            case 1: {
                return new BitData(dataLayout);
            }
            case 2: {
                return new CounterData(dataLayout);
            }
            case 3: {
                return new JumpData(dataLayout);
            }
            case 4: {
                return new ciReceiverTypeData(dataLayout);
            }
            case 5: {
                return new ciVirtualCallData(dataLayout);
            }
            case 6: {
                return new RetData(dataLayout);
            }
            case 7: {
                return new BranchData(dataLayout);
            }
            case 8: 
        }
        return new MultiBranchData(dataLayout);
    }

    int dpToDi(int dp) {
        return dp;
    }

    int firstDi() {
        return 0;
    }

    ProfileData firstData() {
        return this.dataAt(this.firstDi());
    }

    ProfileData nextData(ProfileData current) {
        int currentIndex = this.dpToDi(current.dp());
        int nextIndex = currentIndex + current.sizeInBytes();
        return this.dataAt(nextIndex);
    }

    boolean isValid(ProfileData current) {
        return current != null;
    }

    public void printDataOn(PrintStream st) {
        ProfileData data = this.firstData();
        while (this.isValid(data)) {
            st.print(this.dpToDi(data.dp()));
            st.print(" ");
            data.printDataOn(st);
            data = this.nextData(data);
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                ciMethodData.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

