/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.bugspot.tree;

import sun.jvm.hotspot.bugspot.tree.AddressTreeNodeAdapter;
import sun.jvm.hotspot.bugspot.tree.DoubleTreeNodeAdapter;
import sun.jvm.hotspot.bugspot.tree.EnumTreeNodeAdapter;
import sun.jvm.hotspot.bugspot.tree.FieldTreeNodeAdapter;
import sun.jvm.hotspot.bugspot.tree.FloatTreeNodeAdapter;
import sun.jvm.hotspot.bugspot.tree.LongTreeNodeAdapter;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.cdbg.DefaultObjectVisitor;
import sun.jvm.hotspot.debugger.cdbg.FieldIdentifier;
import sun.jvm.hotspot.ui.tree.SimpleTreeNode;

public class ObjectTreeNodeAdapter
extends FieldTreeNodeAdapter {
    private Address addr;

    public ObjectTreeNodeAdapter(Address addr, FieldIdentifier id) {
        this(addr, id, false);
    }

    public ObjectTreeNodeAdapter(Address addr, FieldIdentifier id, boolean treeTableMode) {
        super(id, treeTableMode);
        this.addr = addr;
    }

    @Override
    public int getChildCount() {
        if (this.addr == null) {
            return 0;
        }
        Counter c = new Counter();
        this.getType().iterateObject(this.addr, c);
        return c.getNumFields();
    }

    @Override
    public SimpleTreeNode getChild(int index) {
        if (this.addr == null) {
            return null;
        }
        Fetcher f = new Fetcher(index);
        this.getType().iterateObject(this.addr, f);
        return f.getChild();
    }

    @Override
    public boolean isLeaf() {
        return this.addr == null;
    }

    @Override
    public int getIndexOfChild(SimpleTreeNode child) {
        FieldIdentifier id = ((FieldTreeNodeAdapter)child).getID();
        Finder f = new Finder(id);
        this.getType().iterateObject(this.addr, f);
        return f.getIndex();
    }

    @Override
    public String getValue() {
        if (this.addr != null) {
            return this.addr.toString();
        }
        return "NULL";
    }

    static class Finder
    extends DefaultObjectVisitor {
        private FieldIdentifier id;
        private int curField;
        private int index = -1;

        public Finder(FieldIdentifier id) {
            this.id = id;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public void doBit(FieldIdentifier f, long val) {
            if (f.equals(this.id)) {
                this.index = this.curField;
            }
            ++this.curField;
        }

        @Override
        public void doInt(FieldIdentifier f, long val) {
            if (f.equals(this.id)) {
                this.index = this.curField;
            }
            ++this.curField;
        }

        @Override
        public void doEnum(FieldIdentifier f, long val, String enumName) {
            if (f.equals(this.id)) {
                this.index = this.curField;
            }
            ++this.curField;
        }

        @Override
        public void doFloat(FieldIdentifier f, float val) {
            if (f.equals(this.id)) {
                this.index = this.curField;
            }
            ++this.curField;
        }

        @Override
        public void doDouble(FieldIdentifier f, double val) {
            if (f.equals(this.id)) {
                this.index = this.curField;
            }
            ++this.curField;
        }

        @Override
        public void doPointer(FieldIdentifier f, Address val) {
            if (f.equals(this.id)) {
                this.index = this.curField;
            }
            ++this.curField;
        }

        @Override
        public void doArray(FieldIdentifier f, Address val) {
            if (f.equals(this.id)) {
                this.index = this.curField;
            }
            ++this.curField;
        }

        @Override
        public void doRef(FieldIdentifier f, Address val) {
            if (f.equals(this.id)) {
                this.index = this.curField;
            }
            ++this.curField;
        }

        @Override
        public void doCompound(FieldIdentifier f, Address val) {
            if (f.equals(this.id)) {
                this.index = this.curField;
            }
            ++this.curField;
        }
    }

    class Fetcher
    extends DefaultObjectVisitor {
        private int index;
        private int curField;
        private SimpleTreeNode child;

        public Fetcher(int index) {
            this.index = index;
        }

        public SimpleTreeNode getChild() {
            return this.child;
        }

        @Override
        public void doBit(FieldIdentifier f, long val) {
            if (this.curField == this.index) {
                this.child = new LongTreeNodeAdapter(val, f, ObjectTreeNodeAdapter.this.getTreeTableMode());
            }
            ++this.curField;
        }

        @Override
        public void doInt(FieldIdentifier f, long val) {
            if (this.curField == this.index) {
                this.child = new LongTreeNodeAdapter(val, f, ObjectTreeNodeAdapter.this.getTreeTableMode());
            }
            ++this.curField;
        }

        @Override
        public void doEnum(FieldIdentifier f, long val, String enumName) {
            if (this.curField == this.index) {
                this.child = new EnumTreeNodeAdapter(enumName, val, f, ObjectTreeNodeAdapter.this.getTreeTableMode());
            }
            ++this.curField;
        }

        @Override
        public void doFloat(FieldIdentifier f, float val) {
            if (this.curField == this.index) {
                this.child = new FloatTreeNodeAdapter(val, f, ObjectTreeNodeAdapter.this.getTreeTableMode());
            }
            ++this.curField;
        }

        @Override
        public void doDouble(FieldIdentifier f, double val) {
            if (this.curField == this.index) {
                this.child = new DoubleTreeNodeAdapter(val, f, ObjectTreeNodeAdapter.this.getTreeTableMode());
            }
            ++this.curField;
        }

        @Override
        public void doPointer(FieldIdentifier f, Address val) {
            if (this.curField == this.index) {
                this.child = new AddressTreeNodeAdapter(val, f, ObjectTreeNodeAdapter.this.getTreeTableMode());
            }
            ++this.curField;
        }

        @Override
        public void doArray(FieldIdentifier f, Address val) {
            if (this.curField == this.index) {
                this.child = new AddressTreeNodeAdapter(val, f, ObjectTreeNodeAdapter.this.getTreeTableMode());
            }
            ++this.curField;
        }

        @Override
        public void doRef(FieldIdentifier f, Address val) {
            if (this.curField == this.index) {
                this.child = new AddressTreeNodeAdapter(val, f, ObjectTreeNodeAdapter.this.getTreeTableMode());
            }
            ++this.curField;
        }

        @Override
        public void doCompound(FieldIdentifier f, Address val) {
            if (this.curField == this.index) {
                this.child = new ObjectTreeNodeAdapter(val, f, ObjectTreeNodeAdapter.this.getTreeTableMode());
            }
            ++this.curField;
        }
    }

    static class Counter
    extends DefaultObjectVisitor {
        private int numFields;

        Counter() {
        }

        public int getNumFields() {
            return this.numFields;
        }

        @Override
        public void doBit(FieldIdentifier f, long val) {
            ++this.numFields;
        }

        @Override
        public void doInt(FieldIdentifier f, long val) {
            ++this.numFields;
        }

        @Override
        public void doEnum(FieldIdentifier f, long val, String enumName) {
            ++this.numFields;
        }

        @Override
        public void doFloat(FieldIdentifier f, float val) {
            ++this.numFields;
        }

        @Override
        public void doDouble(FieldIdentifier f, double val) {
            ++this.numFields;
        }

        @Override
        public void doPointer(FieldIdentifier f, Address val) {
            ++this.numFields;
        }

        @Override
        public void doArray(FieldIdentifier f, Address val) {
            ++this.numFields;
        }

        @Override
        public void doRef(FieldIdentifier f, Address val) {
            ++this.numFields;
        }

        @Override
        public void doCompound(FieldIdentifier f, Address addr) {
            ++this.numFields;
        }
    }
}

