/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11KeyFactory;
import sun.security.pkcs11.P11Util;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11DHKeyFactory
extends P11KeyFactory {
    P11DHKeyFactory(Token token, String string) {
        super(token, string);
    }

    @Override
    PublicKey implTranslatePublicKey(PublicKey publicKey) throws InvalidKeyException {
        try {
            if (publicKey instanceof DHPublicKey) {
                DHPublicKey dHPublicKey = (DHPublicKey)publicKey;
                DHParameterSpec dHParameterSpec = dHPublicKey.getParams();
                return this.generatePublic(dHPublicKey.getY(), dHParameterSpec.getP(), dHParameterSpec.getG());
            }
            if ("X.509".equals(publicKey.getFormat())) {
                try {
                    KeyFactory keyFactory = this.implGetSoftwareFactory();
                    publicKey = (PublicKey)keyFactory.translateKey(publicKey);
                    return this.implTranslatePublicKey(publicKey);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new InvalidKeyException("Could not translate key", generalSecurityException);
                }
            }
            throw new InvalidKeyException("PublicKey must be instance of DHPublicKey or have X.509 encoding");
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new InvalidKeyException("Could not create DH public key", pKCS11Exception);
        }
    }

    @Override
    PrivateKey implTranslatePrivateKey(PrivateKey privateKey) throws InvalidKeyException {
        try {
            if (privateKey instanceof DHPrivateKey) {
                DHPrivateKey dHPrivateKey = (DHPrivateKey)privateKey;
                DHParameterSpec dHParameterSpec = dHPrivateKey.getParams();
                return this.generatePrivate(dHPrivateKey.getX(), dHParameterSpec.getP(), dHParameterSpec.getG());
            }
            if ("PKCS#8".equals(privateKey.getFormat())) {
                try {
                    KeyFactory keyFactory = this.implGetSoftwareFactory();
                    privateKey = (PrivateKey)keyFactory.translateKey(privateKey);
                    return this.implTranslatePrivateKey(privateKey);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new InvalidKeyException("Could not translate key", generalSecurityException);
                }
            }
            throw new InvalidKeyException("PrivateKey must be instance of DHPrivateKey or have PKCS#8 encoding");
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new InvalidKeyException("Could not create DH private key", pKCS11Exception);
        }
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        this.token.ensureValid();
        if (keySpec instanceof X509EncodedKeySpec) {
            try {
                KeyFactory keyFactory = this.implGetSoftwareFactory();
                PublicKey publicKey = keyFactory.generatePublic(keySpec);
                return this.implTranslatePublicKey(publicKey);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new InvalidKeySpecException("Could not create DH public key", generalSecurityException);
            }
        }
        if (!(keySpec instanceof DHPublicKeySpec)) {
            throw new InvalidKeySpecException("Only DHPublicKeySpec and X509EncodedKeySpec supported for DH public keys");
        }
        try {
            DHPublicKeySpec dHPublicKeySpec = (DHPublicKeySpec)keySpec;
            return this.generatePublic(dHPublicKeySpec.getY(), dHPublicKeySpec.getP(), dHPublicKeySpec.getG());
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new InvalidKeySpecException("Could not create DH public key", pKCS11Exception);
        }
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        this.token.ensureValid();
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                KeyFactory keyFactory = this.implGetSoftwareFactory();
                PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
                return this.implTranslatePrivateKey(privateKey);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new InvalidKeySpecException("Could not create DH private key", generalSecurityException);
            }
        }
        if (!(keySpec instanceof DHPrivateKeySpec)) {
            throw new InvalidKeySpecException("Only DHPrivateKeySpec and PKCS8EncodedKeySpec supported for DH private keys");
        }
        try {
            DHPrivateKeySpec dHPrivateKeySpec = (DHPrivateKeySpec)keySpec;
            return this.generatePrivate(dHPrivateKeySpec.getX(), dHPrivateKeySpec.getP(), dHPrivateKeySpec.getG());
        }
        catch (PKCS11Exception pKCS11Exception) {
            throw new InvalidKeySpecException("Could not create DH private key", pKCS11Exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublicKey generatePublic(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(256L, 2L), new CK_ATTRIBUTE(17L, bigInteger), new CK_ATTRIBUTE(304L, bigInteger2), new CK_ATTRIBUTE(306L, bigInteger3)};
        cK_ATTRIBUTEArray = this.token.getAttributes("import", 2L, 2L, cK_ATTRIBUTEArray);
        Session session = null;
        try {
            session = this.token.getObjSession();
            long l = this.token.p11.C_CreateObject(session.id(), cK_ATTRIBUTEArray);
            PublicKey publicKey = P11Key.publicKey(session, l, "DH", bigInteger2.bitLength(), cK_ATTRIBUTEArray);
            return publicKey;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrivateKey generatePrivate(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws PKCS11Exception {
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(256L, 2L), new CK_ATTRIBUTE(17L, bigInteger), new CK_ATTRIBUTE(304L, bigInteger2), new CK_ATTRIBUTE(306L, bigInteger3)};
        cK_ATTRIBUTEArray = this.token.getAttributes("import", 3L, 2L, cK_ATTRIBUTEArray);
        Session session = null;
        try {
            session = this.token.getObjSession();
            long l = this.token.p11.C_CreateObject(session.id(), cK_ATTRIBUTEArray);
            PrivateKey privateKey = P11Key.privateKey(session, l, "DH", bigInteger2.bitLength(), cK_ATTRIBUTEArray);
            return privateKey;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    @Override
    KeySpec implGetPublicKeySpec(P11Key p11Key, Class clazz, Session[] sessionArray) throws PKCS11Exception, InvalidKeySpecException {
        if (DHPublicKeySpec.class.isAssignableFrom(clazz)) {
            sessionArray[0] = this.token.getObjSession();
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L), new CK_ATTRIBUTE(304L), new CK_ATTRIBUTE(306L)};
            this.token.p11.C_GetAttributeValue(sessionArray[0].id(), p11Key.keyID, cK_ATTRIBUTEArray);
            DHPublicKeySpec dHPublicKeySpec = new DHPublicKeySpec(cK_ATTRIBUTEArray[0].getBigInteger(), cK_ATTRIBUTEArray[1].getBigInteger(), cK_ATTRIBUTEArray[2].getBigInteger());
            return dHPublicKeySpec;
        }
        throw new InvalidKeySpecException("Only DHPublicKeySpec and X509EncodedKeySpec supported for DH public keys");
    }

    @Override
    KeySpec implGetPrivateKeySpec(P11Key p11Key, Class clazz, Session[] sessionArray) throws PKCS11Exception, InvalidKeySpecException {
        if (DHPrivateKeySpec.class.isAssignableFrom(clazz)) {
            sessionArray[0] = this.token.getObjSession();
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L), new CK_ATTRIBUTE(304L), new CK_ATTRIBUTE(306L)};
            this.token.p11.C_GetAttributeValue(sessionArray[0].id(), p11Key.keyID, cK_ATTRIBUTEArray);
            DHPrivateKeySpec dHPrivateKeySpec = new DHPrivateKeySpec(cK_ATTRIBUTEArray[0].getBigInteger(), cK_ATTRIBUTEArray[1].getBigInteger(), cK_ATTRIBUTEArray[2].getBigInteger());
            return dHPrivateKeySpec;
        }
        throw new InvalidKeySpecException("Only DHPrivateKeySpec and PKCS8EncodedKeySpec supported for DH private keys");
    }

    @Override
    KeyFactory implGetSoftwareFactory() throws GeneralSecurityException {
        return KeyFactory.getInstance("DH", P11Util.getSunJceProvider());
    }
}

