/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.propertyInspector.InplaceContext;
import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public final class StartInplaceEditingAction
extends AnAction {
    private GuiEditor myEditor;

    public StartInplaceEditingAction(@Nullable GuiEditor editor) {
        this.myEditor = editor;
    }

    public void setEditor(GuiEditor editor) {
        this.myEditor = editor;
    }

    public void actionPerformed(AnActionEvent e) {
        ArrayList<RadComponent> selection = FormEditingUtil.getAllSelectedComponents(this.myEditor);
        RadComponent component = selection.get(0);
        Property defaultInplaceProperty = component.getDefaultInplaceProperty();
        this.myEditor.getInplaceEditingLayer().startInplaceEditing(component, defaultInplaceProperty, component.getDefaultInplaceEditorBounds(), new InplaceContext(true));
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        ArrayList<RadComponent> selection = FormEditingUtil.getAllSelectedComponents(this.myEditor);
        if (selection.size() != 1) {
            presentation.setEnabled(false);
            return;
        }
        RadComponent component = selection.get(0);
        presentation.setEnabled(component.getDefaultInplaceProperty() != null);
    }
}

