/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.rt.engine.local.saxon;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.Mode;
import com.icl.saxon.NodeHandler;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.om.Navigator;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.output.GeneralOutputter;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.trace.TraceListener;
import java.lang.reflect.Field;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.intellij.plugins.xsltDebugger.rt.engine.local.LocalDebugger;
import org.intellij.plugins.xsltDebugger.rt.engine.local.OutputEventQueueImpl;
import org.intellij.plugins.xsltDebugger.rt.engine.local.saxon.SaxonFrameImpl;
import org.intellij.plugins.xsltDebugger.rt.engine.local.saxon.SaxonSourceFrame;

public class SaxonTraceListener
implements TraceListener {
    private static final boolean TRACE = "true".equals(System.getProperty("xslt.debugger.trace", "false"));
    private String indent = "";
    private final LocalDebugger myDebugger;
    private final Controller myController;
    private boolean myIsInitialized;

    public SaxonTraceListener(LocalDebugger debugger, Controller controller) {
        this.myDebugger = debugger;
        this.myController = controller;
    }

    public void open() {
        this.myDebugger.getEventQueue().startDocument();
        if (TRACE) {
            SaxonTraceListener.trace("<trace>");
        }
    }

    private static void trace(String s) {
        if (TRACE) {
            System.err.println(s);
        }
    }

    public void close() {
        this.myDebugger.getEventQueue().endDocument();
        if (TRACE) {
            SaxonTraceListener.trace("</trace>");
        }
    }

    public void toplevel(NodeInfo element) {
        if (!this.myIsInitialized) {
            this.myIsInitialized = true;
            Properties properties = this.myController.getOutputProperties();
            String method = properties.getProperty("method");
            if (method == null || "xml".equals(method) || "html".equals(method)) {
                try {
                    Emitter emitter = this.myController.getOutputter().getEmitter();
                    TracingOutputter outputter = new TracingOutputter(emitter, this.myController.getNamePool());
                    Field fOutputter = Controller.class.getDeclaredField("currentOutputter");
                    fOutputter.setAccessible(true);
                    fOutputter.set(this.myController, (Object)outputter);
                }
                catch (Exception e1) {
                    System.err.println("Failed to change output emitter");
                    e1.printStackTrace();
                }
            }
        }
        if (TRACE) {
            StyleElement e = (StyleElement)element;
            SaxonTraceListener.trace("<Top-level element=\"" + e.getDisplayName() + "\" line=\"" + e.getLineNumber() + "\" file=\"" + e.getSystemId() + "\" precedence=\"" + e.getPrecedence() + "\"/>");
        }
    }

    public void enterSource(NodeHandler handler, Context context) {
        NodeInfo curr = context.getContextNodeInfo();
        String path = Navigator.getPath((NodeInfo)curr);
        if (TRACE) {
            SaxonTraceListener.trace(this.indent + "<Source node=\"" + path + "\" line=\"" + curr.getLineNumber() + "\" mode=\"" + SaxonTraceListener.getModeName(context) + "\">");
            this.indent = this.indent + " ";
        }
        this.myDebugger.pushSource(new SaxonSourceFrame(this.myDebugger.getSourceFrame(), curr));
    }

    public void leaveSource(NodeHandler handler, Context context) {
        if (TRACE) {
            this.indent = this.indent.substring(0, this.indent.length() - 1);
            SaxonTraceListener.trace(this.indent + "</Source><!-- " + Navigator.getPath((NodeInfo)context.getContextNodeInfo()) + " -->");
        }
        this.myDebugger.popSource();
    }

    public void enter(NodeInfo element, Context context) {
        if (element.getNodeType() == 1) {
            if (TRACE) {
                SaxonTraceListener.trace(this.indent + "<Instruction element=\"" + element.getDisplayName() + "\" line=\"" + element.getLineNumber() + "\">");
                this.indent = this.indent + " ";
            }
            this.myDebugger.enter(new SaxonFrameImpl(this.myDebugger.getCurrentFrame(), context, (StyleElement)element));
        }
    }

    public void leave(NodeInfo element, Context context) {
        if (element.getNodeType() == 1) {
            this.myDebugger.leave();
            if (TRACE) {
                this.indent = this.indent.substring(0, this.indent.length() - 1);
                SaxonTraceListener.trace(this.indent + "</Instruction> <!-- " + element.getDisplayName() + " -->");
            }
        }
    }

    static String getModeName(Context context) {
        Mode mode = context.getMode();
        if (mode == null) {
            return "#none";
        }
        int nameCode = mode.getNameCode();
        if (nameCode == -1) {
            return "#default";
        }
        return context.getController().getNamePool().getDisplayName(nameCode);
    }

    private final class TracingOutputter
    extends GeneralOutputter {
        private final NamePool myNamePool;
        private final OutputEventQueueImpl myEventQueue;

        public TracingOutputter(Emitter emitter, NamePool namePool) {
            super(namePool);
            this.emitter = emitter;
            this.myNamePool = namePool;
            this.myEventQueue = SaxonTraceListener.this.myDebugger.getEventQueue();
        }

        public void writeAttribute(int nameCode, String value, boolean noEscape) throws TransformerException {
            if (this.myEventQueue.isEnabled()) {
                String localName = this.myNamePool.getLocalName(nameCode);
                String prefix = this.myNamePool.getPrefix(nameCode);
                this.myEventQueue.attribute(prefix, localName, this.myNamePool.getURI(nameCode), value);
            }
            super.writeAttribute(nameCode, value, noEscape);
        }

        public void writeComment(String comment) throws TransformerException {
            this.myEventQueue.comment(comment);
            super.writeComment(comment);
        }

        public void writeContent(char[] chars, int start, int length) throws TransformerException {
            this.myEventQueue.characters(new String(chars, start, length));
            super.writeContent(chars, start, length);
        }

        public void writeContent(StringBuffer chars, int start, int len) throws TransformerException {
            this.myEventQueue.characters(chars.substring(start, start + len));
            super.writeContent(chars, start, len);
        }

        public void writeEndTag(int nameCode) throws TransformerException {
            this.myEventQueue.endElement();
            super.writeEndTag(nameCode);
        }

        public void writePI(String target, String data) throws TransformerException {
            this.myEventQueue.pi(target, data);
            super.writePI(target, data);
        }

        public void writeStartTag(int nameCode) throws TransformerException {
            if (this.myEventQueue.isEnabled()) {
                String localName = this.myNamePool.getLocalName(nameCode);
                String prefix = this.myNamePool.getPrefix(nameCode);
                this.myEventQueue.startElement(prefix, localName, this.myNamePool.getURI(nameCode));
            }
            super.writeStartTag(nameCode);
        }
    }
}

