/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.parameters;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import java.util.HashSet;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.VariableInitializer;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.annotations.Annotation;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.typeDefinitions.ReferenceElement;
import org.jetbrains.plugins.groovy.lang.parser.parsing.types.TypeSpec;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class ParameterDeclaration {
    public static boolean parseTraditionalForParameter(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker pdMarker = builder.mark();
        boolean hasModifiers = ParameterDeclaration.parseOptionalModifier(builder, parser);
        PsiBuilder.Marker rb = builder.mark();
        ReferenceElement.ReferenceElementResult result = TypeSpec.parseStrict(builder, true);
        if (result == ReferenceElement.ReferenceElementResult.FAIL && !hasModifiers) {
            rb.drop();
            pdMarker.rollbackTo();
            return false;
        }
        if (GroovyTokenTypes.mIDENT.equals(builder.getTokenType())) {
            rb.drop();
        } else {
            rb.rollbackTo();
            if (!hasModifiers) {
                pdMarker.rollbackTo();
                return false;
            }
        }
        if (ParserUtils.getToken(builder, GroovyTokenTypes.mIDENT)) {
            if (GroovyTokenTypes.mASSIGN.equals(builder.getTokenType())) {
                VariableInitializer.parse(builder, parser);
            }
            pdMarker.done(GroovyElementTypes.PARAMETER);
            return true;
        }
        pdMarker.rollbackTo();
        return false;
    }

    public static boolean parseSimpleParameter(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker pdMarker = builder.mark();
        ParameterDeclaration.parseOptionalModifier(builder, parser);
        PsiBuilder.Marker rb = builder.mark();
        ReferenceElement.ReferenceElementResult result = TypeSpec.parseStrict(builder, false);
        if (GroovyTokenTypes.mIDENT.equals(builder.getTokenType()) || GroovyTokenTypes.mTRIPLE_DOT.equals(builder.getTokenType())) {
            rb.drop();
        } else {
            if (result == ReferenceElement.ReferenceElementResult.REF_WITH_TYPE_PARAMS || result == ReferenceElement.ReferenceElementResult.PATH_REF) {
                rb.drop();
                pdMarker.drop();
                builder.error(GroovyBundle.message("identifier.expected", new Object[0]));
                return true;
            }
            rb.rollbackTo();
        }
        boolean hasDots = ParserUtils.getToken(builder, GroovyTokenTypes.mTRIPLE_DOT);
        if (ParserUtils.getToken(builder, GroovyTokenTypes.mIDENT)) {
            if (GroovyTokenTypes.mASSIGN.equals(builder.getTokenType())) {
                VariableInitializer.parse(builder, parser);
            }
            pdMarker.done(GroovyElementTypes.PARAMETER);
            return true;
        }
        if (hasDots) {
            pdMarker.error(GroovyBundle.message("identifier.expected", new Object[0]));
            return true;
        }
        pdMarker.rollbackTo();
        return false;
    }

    public static boolean parseCatchParameter(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker pdMarker = builder.mark();
        ParameterDeclaration.parseOptionalModifier(builder, parser);
        PsiBuilder.Marker disjunctionMarker = builder.mark();
        PsiBuilder.Marker rb = builder.mark();
        int typeCount = 0;
        do {
            ++typeCount;
            rb.drop();
            rb = builder.mark();
            ReferenceElement.ReferenceElementResult result = TypeSpec.parseStrict(builder, false);
            if (result == ReferenceElement.ReferenceElementResult.FAIL && ParserUtils.lookAhead(builder, GroovyTokenTypes.mBOR)) {
                builder.error(GroovyBundle.message("type.expected", new Object[0]));
                continue;
            }
            if (builder.getTokenType() != GroovyTokenTypes.mTRIPLE_DOT) continue;
            builder.error(GroovyBundle.message("triple.is.not.expected.here", new Object[0]));
            builder.advanceLexer();
        } while (ParserUtils.getToken(builder, GroovyTokenTypes.mBOR));
        if (GroovyTokenTypes.mIDENT == builder.getTokenType()) {
            rb.drop();
        } else if (typeCount == 1) {
            rb.rollbackTo();
            --typeCount;
        } else {
            builder.error(GroovyBundle.message("identifier.expected", new Object[0]));
            rb.drop();
        }
        if (typeCount > 1) {
            disjunctionMarker.done((IElementType)GroovyElementTypes.DISJUNCTION_TYPE_ELEMENT);
        } else {
            disjunctionMarker.drop();
        }
        if (ParserUtils.getToken(builder, GroovyTokenTypes.mIDENT)) {
            pdMarker.done(GroovyElementTypes.PARAMETER);
            return true;
        }
        pdMarker.drop();
        return false;
    }

    private static boolean parseOptionalModifier(PsiBuilder builder, GroovyParser parser) {
        HashSet<IElementType> modSet = new HashSet<IElementType>();
        PsiBuilder.Marker marker = builder.mark();
        boolean hasModifiers = false;
        while (builder.getTokenType() == GroovyTokenTypes.kFINAL || builder.getTokenType() == GroovyTokenTypes.kDEF || builder.getTokenType() == GroovyTokenTypes.mAT) {
            hasModifiers = true;
            if (GroovyTokenTypes.kFINAL.equals(builder.getTokenType())) {
                if (modSet.contains(GroovyTokenTypes.kFINAL)) {
                    ParserUtils.wrapError(builder, GroovyBundle.message("duplicate.modifier", "final"));
                } else {
                    builder.advanceLexer();
                    modSet.add(GroovyTokenTypes.kFINAL);
                }
                ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
                continue;
            }
            if (GroovyTokenTypes.kDEF.equals(builder.getTokenType())) {
                if (modSet.contains(GroovyTokenTypes.kDEF)) {
                    ParserUtils.wrapError(builder, GroovyBundle.message("duplicate.modifier", "def"));
                } else {
                    builder.advanceLexer();
                    modSet.add(GroovyTokenTypes.kDEF);
                }
                ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
                continue;
            }
            if (!Annotation.parse(builder, parser)) {
                ParserUtils.wrapError(builder, GroovyBundle.message("annotation.expected", new Object[0]));
            }
            ParserUtils.getToken(builder, GroovyTokenTypes.mNLS);
        }
        marker.done(GroovyElementTypes.MODIFIERS);
        return hasModifiers;
    }
}

