/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.closure;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.ErrorUtil;

class ExplicitClosureCallPredicate
implements PsiElementPredicate {
    ExplicitClosureCallPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof GrMethodCallExpression)) {
            return false;
        }
        GrMethodCallExpression call = (GrMethodCallExpression)element;
        GrExpression invokedExpression = call.getInvokedExpression();
        if (invokedExpression == null) {
            return false;
        }
        if (!(invokedExpression instanceof GrReferenceExpression)) {
            return false;
        }
        GrReferenceExpression referenceExpression = (GrReferenceExpression)invokedExpression;
        String name = referenceExpression.getReferenceName();
        if (!"call".equals(name)) {
            return false;
        }
        GrExpression qualifier = referenceExpression.getQualifierExpression();
        if (qualifier == null) {
            return false;
        }
        PsiType qualifierType = qualifier.getType();
        if (qualifierType == null) {
            return false;
        }
        if (!qualifierType.equalsToText("groovy.lang.Closure")) {
            return false;
        }
        return !ErrorUtil.containsError(element);
    }
}

