/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.refactorings.introduce;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.replaceInProject.ReplaceInProjectManager;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Processor;
import com.intellij.util.containers.hash.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomProperties;
import org.jetbrains.idea.maven.dom.refactorings.introduce.IntroducePropertyDialog;

public class IntroducePropertyAction
extends BaseRefactoringAction {
    private static final String PREFIX = "${";
    private static final String SUFFIX = "}";

    public IntroducePropertyAction() {
        this.setInjectedContext(true);
    }

    protected boolean isAvailableInEditorOnly() {
        return true;
    }

    protected boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction", "isEnabledOnElements"));
        }
        return false;
    }

    protected boolean isAvailableForLanguage(Language language) {
        return true;
    }

    protected RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction", "getHandler"));
        }
        return new MyRefactoringActionHandler();
    }

    protected boolean isAvailableForFile(PsiFile file) {
        VirtualFile virtualFile = file.getVirtualFile();
        return MavenDomUtil.isMavenFile(file) && virtualFile != null && virtualFile.getFileSystem() != JarFileSystem.getInstance();
    }

    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element, @NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (!super.isAvailableOnElementInEditorAndFile(element, editor, file, context)) {
            return false;
        }
        return IntroducePropertyAction.getSelectedElementAndTextRange(editor, file) != null;
    }

    @Nullable
    public static Pair<XmlElement, TextRange> getSelectedElementAndTextRange(Editor editor, PsiFile file) {
        int startOffset = editor.getSelectionModel().getSelectionStart();
        int endOffset = editor.getSelectionModel().getSelectionEnd();
        PsiElement elementAtStart = file.findElementAt(startOffset);
        if (elementAtStart == null) {
            return null;
        }
        PsiElement elementAtEnd = file.findElementAt(endOffset == startOffset ? endOffset : endOffset - 1);
        if (elementAtEnd == null) {
            return null;
        }
        PsiElement elementAt = PsiTreeUtil.findCommonParent((PsiElement)elementAtStart, (PsiElement)elementAtEnd);
        if (elementAt instanceof XmlToken) {
            elementAt = elementAt.getParent();
        }
        if (elementAt instanceof XmlText || elementAt instanceof XmlAttributeValue) {
            TextRange range = editor.getSelectionModel().hasSelection() ? new TextRange(startOffset, endOffset) : elementAt.getTextRange();
            return Pair.create((Object)((XmlElement)elementAt), (Object)range);
        }
        return null;
    }

    private static List<TextRange> getPropertiesTextRanges(String s) {
        int endOffset;
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        int startOffset = s.indexOf(PREFIX);
        while (startOffset >= 0 && (endOffset = s.indexOf(SUFFIX, startOffset)) > startOffset) {
            if (s.substring(startOffset + PREFIX.length(), endOffset).contains(PREFIX)) {
                startOffset = s.indexOf(PREFIX, startOffset + 1);
                continue;
            }
            ranges.add(new TextRange(startOffset, endOffset));
            startOffset = s.indexOf(PREFIX, endOffset);
        }
        return ranges;
    }

    private static boolean isIntersectWithRanges(@NotNull Collection<TextRange> ranges, int start, int end) {
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction", "isIntersectWithRanges"));
        }
        for (TextRange range : ranges) {
            if (start <= range.getStartOffset() && end >= range.getEndOffset() || end <= range.getStartOffset() || start >= range.getEndOffset()) continue;
            return true;
        }
        return false;
    }

    private static class MyRefactoringActionHandler
    implements RefactoringActionHandler {
        private MyRefactoringActionHandler() {
        }

        public void invoke(final @NotNull Project project, final Editor editor, PsiFile file, DataContext dataContext) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction$MyRefactoringActionHandler", "invoke"));
            }
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            Pair<XmlElement, TextRange> elementAndRange = IntroducePropertyAction.getSelectedElementAndTextRange(editor, file);
            if (elementAndRange == null) {
                return;
            }
            XmlElement selectedElement = (XmlElement)elementAndRange.first;
            final TextRange range = (TextRange)elementAndRange.second;
            String stringValue = selectedElement.getText();
            if (stringValue == null) {
                return;
            }
            MavenDomProjectModel model = MavenDomUtil.getMavenDomModel(file, MavenDomProjectModel.class);
            final String selectedString = editor.getDocument().getText(range);
            List ranges = IntroducePropertyAction.getPropertiesTextRanges(stringValue);
            int offsetInElement = range.getStartOffset() - selectedElement.getTextOffset();
            if (model == null || StringUtil.isEmptyOrSpaces((String)selectedString) || IntroducePropertyAction.isIntersectWithRanges(ranges, offsetInElement, offsetInElement + selectedString.length())) {
                return;
            }
            editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
            IntroducePropertyDialog dialog = new IntroducePropertyDialog(project, selectedElement, model, selectedString);
            dialog.show();
            if (dialog.getExitCode() != 0) {
                return;
            }
            final String propertyName = dialog.getEnteredName();
            final String replaceWith = IntroducePropertyAction.PREFIX + propertyName + IntroducePropertyAction.SUFFIX;
            final MavenDomProjectModel selectedProject = dialog.getSelectedProject();
            if (ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(MyRefactoringActionHandler.getFiles(file, selectedProject)).hasReadonlyFiles()) {
                return;
            }
            new WriteCommandAction(project, new PsiFile[0]){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction$MyRefactoringActionHandler$1", "run"));
                    }
                    editor.getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)replaceWith);
                    PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                    MyRefactoringActionHandler.createMavenProperty(selectedProject, propertyName, selectedString);
                    PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                }
            }.execute();
            MyRefactoringActionHandler.showFindUsages(project, propertyName, selectedString, replaceWith, selectedProject);
        }

        private static VirtualFile[] getFiles(PsiFile file, MavenDomProjectModel model) {
            VirtualFile vf;
            XmlElement xmlElement;
            HashSet virtualFiles = new HashSet();
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile != null) {
                virtualFiles.add(virtualFile);
            }
            if ((xmlElement = model.getXmlElement()) != null && (vf = xmlElement.getContainingFile().getVirtualFile()) != null) {
                virtualFiles.add(vf);
            }
            return VfsUtil.toVirtualFileArray((Collection)virtualFiles);
        }

        private static void createMavenProperty(@NotNull MavenDomProjectModel model, @NotNull String enteredName, @NotNull String selectedString) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction$MyRefactoringActionHandler", "createMavenProperty"));
            }
            if (enteredName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enteredName", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction$MyRefactoringActionHandler", "createMavenProperty"));
            }
            if (selectedString == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedString", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction$MyRefactoringActionHandler", "createMavenProperty"));
            }
            MavenDomProperties mavenDomProperties = model.getProperties();
            XmlTag xmlTag = mavenDomProperties.ensureTagExists();
            XmlTag propertyTag = xmlTag.createChildTag(enteredName, xmlTag.getNamespace(), selectedString, false);
            xmlTag.add((PsiElement)propertyTag);
        }

        private static void showFindUsages(@NotNull Project project, @NotNull String propertyName, @NotNull String selectedString, @NotNull String replaceWith, @NotNull MavenDomProjectModel model) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction$MyRefactoringActionHandler", "showFindUsages"));
            }
            if (propertyName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction$MyRefactoringActionHandler", "showFindUsages"));
            }
            if (selectedString == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedString", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction$MyRefactoringActionHandler", "showFindUsages"));
            }
            if (replaceWith == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replaceWith", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction$MyRefactoringActionHandler", "showFindUsages"));
            }
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction$MyRefactoringActionHandler", "showFindUsages"));
            }
            UsageViewManager manager = UsageViewManager.getInstance((Project)project);
            if (manager == null) {
                return;
            }
            MyRefactoringActionHandler.assureFindToolWindowRegistered(project);
            FindManager findManager = FindManager.getInstance((Project)project);
            FindModel findModel = MyRefactoringActionHandler.createFindModel(findManager, selectedString, replaceWith);
            UsageViewPresentation presentation = FindInProjectUtil.setupViewPresentation((boolean)true, (FindModel)findModel);
            FindUsagesProcessPresentation processPresentation = FindInProjectUtil.setupProcessPresentation((Project)project, (boolean)true, (UsageViewPresentation)presentation);
            findManager.getFindInProjectModel().copyFrom(findModel);
            FindModel findModelCopy = findModel.clone();
            ReplaceInProjectManager.getInstance((Project)project).searchAndShowUsages(manager, (Factory)new MyUsageSearcherFactory(model, propertyName, selectedString), findModelCopy, presentation, processPresentation, findManager);
        }

        private static void assureFindToolWindowRegistered(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction$MyRefactoringActionHandler", "assureFindToolWindowRegistered"));
            }
            com.intellij.usageView.UsageViewManager uvm = com.intellij.usageView.UsageViewManager.getInstance((Project)project);
        }

        private static FindModel createFindModel(FindManager findManager, String selectedString, String replaceWith) {
            FindModel findModel = findManager.getFindInProjectModel().clone();
            findModel.setStringToFind(selectedString);
            findModel.setStringToReplace(replaceWith);
            findModel.setReplaceState(true);
            findModel.setPromptOnReplace(true);
            findModel.setCaseSensitive(true);
            findModel.setRegularExpressions(false);
            return findModel;
        }

        public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction$MyRefactoringActionHandler", "invoke"));
            }
            if (elements == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction$MyRefactoringActionHandler", "invoke"));
            }
        }

        private static class MyUsageSearcherFactory
        implements Factory<UsageSearcher> {
            private final MavenDomProjectModel myModel;
            private final String myPropertyName;
            private final String mySelectedString;

            public MyUsageSearcherFactory(MavenDomProjectModel model, String propertyName, String selectedString) {
                this.myModel = model;
                this.myPropertyName = propertyName;
                this.mySelectedString = selectedString;
            }

            public UsageSearcher create() {
                return new UsageSearcher(){
                    Set<UsageInfo> usages = new HashSet();

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void generate(@NotNull Processor<Usage> processor) {
                        if (processor == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction$MyRefactoringActionHandler$MyUsageSearcherFactory$1", "generate"));
                        }
                        AccessToken accessToken = ApplicationManager.getApplication().acquireReadActionLock();
                        try {
                            this.collectUsages(MyUsageSearcherFactory.this.myModel);
                            for (MavenDomProjectModel model : MavenDomProjectProcessorUtils.getChildrenProjects(MyUsageSearcherFactory.this.myModel)) {
                                this.collectUsages(model);
                            }
                            for (UsageInfo usage : this.usages) {
                                processor.process(UsageInfo2UsageAdapter.CONVERTER.fun((Object)usage));
                            }
                        }
                        finally {
                            accessToken.finish();
                        }
                    }

                    private void collectUsages(@NotNull MavenDomProjectModel model) {
                        XmlElement root;
                        if (model == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction$MyRefactoringActionHandler$MyUsageSearcherFactory$1", "collectUsages"));
                        }
                        if (model.isValid() && (root = model.getXmlElement()) != null) {
                            root.acceptChildren((PsiElementVisitor)new XmlElementVisitor(){

                                public void visitXmlText(XmlText text) {
                                    XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)text, XmlTag.class);
                                    if (xmlTag != null && !xmlTag.getName().equals(MyUsageSearcherFactory.this.myPropertyName)) {
                                        usages.addAll(this.getUsages((XmlElement)text));
                                    }
                                }

                                public void visitXmlAttributeValue(XmlAttributeValue value) {
                                    XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)value, XmlTag.class);
                                    if (xmlTag != null && !xmlTag.equals(root)) {
                                        usages.addAll(this.getUsages((XmlElement)value));
                                    }
                                }

                                public void visitXmlElement(XmlElement element) {
                                    element.acceptChildren((PsiElementVisitor)this);
                                }
                            });
                        }
                    }

                    @NotNull
                    private Set<UsageInfo> getUsages(@NotNull XmlElement xmlElement) {
                        int end;
                        if (xmlElement == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlElement", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction$MyRefactoringActionHandler$MyUsageSearcherFactory$1", "getUsages"));
                        }
                        String s = xmlElement.getText();
                        if (StringUtil.isEmptyOrSpaces((String)s)) {
                            Set<UsageInfo> set = Collections.emptySet();
                            if (set == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction$MyRefactoringActionHandler$MyUsageSearcherFactory$1", "getUsages"));
                            }
                            return set;
                        }
                        int start = s.indexOf(MyUsageSearcherFactory.this.mySelectedString);
                        if (start == -1) {
                            Set<UsageInfo> set = Collections.emptySet();
                            if (set == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction$MyRefactoringActionHandler$MyUsageSearcherFactory$1", "getUsages"));
                            }
                            return set;
                        }
                        HashSet usages = new HashSet();
                        List ranges = IntroducePropertyAction.getPropertiesTextRanges(s);
                        TextRange elementTextRange = xmlElement.getTextRange();
                        PsiFile containingFile = xmlElement.getContainingFile();
                        do {
                            boolean isInsideProperty;
                            if (isInsideProperty = IntroducePropertyAction.isIntersectWithRanges(ranges, start, end = start + MyUsageSearcherFactory.this.mySelectedString.length())) continue;
                            usages.add(new UsageInfo((PsiElement)containingFile, elementTextRange.getStartOffset() + start, elementTextRange.getStartOffset() + end));
                        } while ((start = s.indexOf(MyUsageSearcherFactory.this.mySelectedString, end)) != -1);
                        HashSet hashSet = usages;
                        if (hashSet == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction$MyRefactoringActionHandler$MyUsageSearcherFactory$1", "getUsages"));
                        }
                        return hashSet;
                    }
                };
            }
        }
    }
}

