/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.util.SmartList;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;

public class BoundedTaskExecutorService
extends BoundedTaskExecutor
implements ExecutorService {
    public BoundedTaskExecutorService(@NotNull ExecutorService backendExecutor, int maxSimultaneousTasks) {
        if (backendExecutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backendExecutor", "com/intellij/util/concurrency/BoundedTaskExecutorService", "<init>"));
        }
        super(backendExecutor, maxSimultaneousTasks);
    }

    @Override
    public void shutdown() {
        this.getBackendExecutor().shutdown();
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        List<Runnable> list = this.getBackendExecutor().shutdownNow();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/BoundedTaskExecutorService", "shutdownNow"));
        }
        return list;
    }

    @Override
    public boolean isShutdown() {
        return this.getBackendExecutor().isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.getBackendExecutor().isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.getBackendExecutor().awaitTermination(timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        SmartList<Future<T>> futures = new SmartList<Future<T>>();
        for (Callable<T> task : tasks) {
            futures.add(this.submit(task));
        }
        boolean done = false;
        for (Future future : futures) {
            if (future.isDone()) continue;
            try {
                future.get();
            }
            catch (ExecutionException executionException) {}
        }
        done = true;
        SmartList<Future<T>> smartList = futures;
        SmartList<Future<T>> smartList2 = smartList;
        if (smartList2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/BoundedTaskExecutorService", "invokeAll"));
        }
        return smartList2;
        finally {
            if (!done) {
                for (Future future : futures) {
                    future.cancel(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        SmartList<Future<T>> futures = new SmartList<Future<T>>();
        boolean done = false;
        long lastCheck = System.nanoTime();
        for (Callable<T> task : tasks) {
            futures.add(this.submit(task));
        }
        long now = System.nanoTime();
        if ((nanos -= now - lastCheck) <= 0L) {
            SmartList<Future<T>> smartList = futures;
            SmartList<Future<T>> smartList2 = smartList;
            if (smartList2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/BoundedTaskExecutorService", "invokeAll"));
            }
            return smartList2;
        }
        lastCheck = now;
        for (Future future : futures) {
            if (future.isDone()) continue;
            if (nanos <= 0L) {
                SmartList<Future<T>> smartList = futures;
                SmartList<Future<T>> smartList3 = smartList;
                if (smartList3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/BoundedTaskExecutorService", "invokeAll"));
                }
                return smartList3;
            }
            try {
                future.get(nanos, TimeUnit.NANOSECONDS);
            }
            catch (ExecutionException executionException) {
            }
            catch (TimeoutException timeoutException) {
                SmartList<Future<T>> smartList = futures;
                if (!done) {
                    for (Future future2 : futures) {
                        future2.cancel(true);
                    }
                }
                SmartList<Future<T>> smartList4 = smartList;
                if (smartList4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/BoundedTaskExecutorService", "invokeAll"));
                }
                return smartList4;
            }
            now = System.nanoTime();
            nanos -= now - lastCheck;
            lastCheck = now;
        }
        done = true;
        SmartList<Future<T>> smartList = futures;
        SmartList<Future<T>> smartList5 = smartList;
        if (smartList5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/BoundedTaskExecutorService", "invokeAll"));
        }
        return smartList5;
        finally {
            if (!done) {
                for (Future future : futures) {
                    future.cancel(true);
                }
            }
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new RuntimeException("invokeAny is not supported by this ExecutorService implementation");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new RuntimeException("invokeAny is not supported by this ExecutorService implementation");
    }

    @NotNull
    private ExecutorService getBackendExecutor() {
        ExecutorService executorService = (ExecutorService)this.myBackendExecutor;
        if (executorService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/BoundedTaskExecutorService", "getBackendExecutor"));
        }
        return executorService;
    }
}

