/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi.ssl;

import com.intellij.execution.rmi.ssl.PrivateKeyReader;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.security.CompositeX509TrustManager;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.UUID;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SslSocketFactory
extends SSLSocketFactory {
    public static final String SSL_CA_CERT_PATH = "sslCaCertPath";
    public static final String SSL_CLIENT_CERT_PATH = "sslClientCertPath";
    public static final String SSL_CLIENT_KEY_PATH = "sslClientKeyPath";
    public static final String SSL_TRUST_EVERYBODY = "sslTrustEverybody";
    private static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    private SSLSocketFactory myFactory;

    public SslSocketFactory() throws GeneralSecurityException, IOException {
        KeyManager[] kms;
        TrustManager[] tms;
        SSLContext ctx = SSLContext.getInstance("TLS");
        try {
            KeyManager[] keyManagerArray;
            TrustManager[] trustManagerArray;
            String caCertPath = System.getProperty(SSL_CA_CERT_PATH);
            String clientCertPath = System.getProperty(SSL_CLIENT_CERT_PATH);
            String clientKeyPath = System.getProperty(SSL_CLIENT_KEY_PATH);
            boolean trustEverybody = StringUtilRt.parseBoolean(System.getProperty(SSL_TRUST_EVERYBODY), false);
            if (trustEverybody) {
                TrustManager[] trustManagerArray2 = new TrustManager[1];
                trustManagerArray = trustManagerArray2;
                trustManagerArray2[0] = new MyTrustEverybodyManager();
            } else {
                trustManagerArray = tms = caCertPath == null ? new TrustManager[]{} : SslSocketFactory.createTrustManagers(caCertPath);
            }
            if (clientCertPath != null && clientKeyPath != null) {
                KeyManager[] keyManagerArray2 = new KeyManager[1];
                keyManagerArray = keyManagerArray2;
                keyManagerArray2[0] = new MyKeyManager(clientCertPath, clientKeyPath);
            } else {
                keyManagerArray = new KeyManager[]{};
            }
            kms = keyManagerArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ctx.init(kms, tms, null);
        this.myFactory = ctx.getSocketFactory();
    }

    @NotNull
    public static TrustManager[] createTrustManagers(@NotNull String caCertPath) throws Exception {
        if (caCertPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caCertPath", "com/intellij/execution/rmi/ssl/SslSocketFactory", "createTrustManagers"));
        }
        String string = FileUtilRt.loadFile(new File(caCertPath));
        String[] tokens = string.split(END_CERTIFICATE);
        ArrayList<TrustManager> result = ContainerUtilRt.newArrayListWithCapacity(tokens.length);
        for (String token : tokens) {
            if (token == null || token.trim().isEmpty()) continue;
            result.add(new MyTrustManager(SslSocketFactory.readCertificate(SslSocketFactory.stringStream(token + END_CERTIFICATE))));
        }
        TrustManager[] trustManagerArray = new TrustManager[]{new CompositeX509TrustManager(new TrustManager[][]{result.toArray(new TrustManager[result.size()])})};
        if (trustManagerArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/ssl/SslSocketFactory", "createTrustManagers"));
        }
        return trustManagerArray;
    }

    @NotNull
    public static InputStream stringStream(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/execution/rmi/ssl/SslSocketFactory", "stringStream"));
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(str.getBytes(Charset.forName("UTF-8")));
        if (byteArrayInputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/ssl/SslSocketFactory", "stringStream"));
        }
        return byteArrayInputStream;
    }

    @Override
    @NotNull
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket socket = this.myFactory.createSocket(host, port);
        if (socket == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/ssl/SslSocketFactory", "createSocket"));
        }
        return socket;
    }

    @Override
    @NotNull
    public Socket createSocket(String host, int port) throws IOException {
        Socket socket = this.myFactory.createSocket(host, port);
        if (socket == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/ssl/SslSocketFactory", "createSocket"));
        }
        return socket;
    }

    @Override
    @NotNull
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        Socket socket = this.myFactory.createSocket(host, port, localHost, localPort);
        if (socket == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/ssl/SslSocketFactory", "createSocket"));
        }
        return socket;
    }

    @Override
    @NotNull
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket socket = this.myFactory.createSocket(address, port, localAddress, localPort);
        if (socket == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/ssl/SslSocketFactory", "createSocket"));
        }
        return socket;
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        return this.myFactory.createSocket(socket, host, port, autoClose);
    }

    @Override
    @NotNull
    public String[] getDefaultCipherSuites() {
        String[] stringArray = this.myFactory.getDefaultCipherSuites();
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/ssl/SslSocketFactory", "getDefaultCipherSuites"));
        }
        return stringArray;
    }

    @Override
    @NotNull
    public String[] getSupportedCipherSuites() {
        String[] stringArray = this.myFactory.getSupportedCipherSuites();
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/ssl/SslSocketFactory", "getSupportedCipherSuites"));
        }
        return stringArray;
    }

    @NotNull
    public static X509Certificate readCertificate(@NotNull String filePath) throws CertificateException, IOException {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/execution/rmi/ssl/SslSocketFactory", "readCertificate"));
        }
        X509Certificate x509Certificate = SslSocketFactory.readCertificate(new FileInputStream(filePath));
        if (x509Certificate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/ssl/SslSocketFactory", "readCertificate"));
        }
        return x509Certificate;
    }

    @NotNull
    public static X509Certificate readCertificate(@NotNull InputStream stream) throws CertificateException, IOException {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/execution/rmi/ssl/SslSocketFactory", "readCertificate"));
        }
        X509Certificate certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(stream);
        stream.close();
        X509Certificate x509Certificate = certificate;
        if (x509Certificate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/ssl/SslSocketFactory", "readCertificate"));
        }
        return x509Certificate;
    }

    @NotNull
    public static PrivateKey readPrivateKey(@NotNull String filePath) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/execution/rmi/ssl/SslSocketFactory", "readPrivateKey"));
        }
        PrivateKey privateKey = new PrivateKeyReader(filePath).getPrivateKey();
        if (privateKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/ssl/SslSocketFactory", "readPrivateKey"));
        }
        return privateKey;
    }

    private static class MyKeyManager
    extends X509ExtendedKeyManager {
        private final String myAlias;
        @NotNull
        private final X509Certificate[] myCertificates;
        @NotNull
        private final PrivateKey myPrivateKey;

        private MyKeyManager(@NotNull String certPath, @NotNull String keyPath) throws Exception {
            if (certPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "certPath", "com/intellij/execution/rmi/ssl/SslSocketFactory$MyKeyManager", "<init>"));
            }
            if (keyPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyPath", "com/intellij/execution/rmi/ssl/SslSocketFactory$MyKeyManager", "<init>"));
            }
            this.myAlias = UUID.randomUUID().toString();
            this.myCertificates = new X509Certificate[]{SslSocketFactory.readCertificate(certPath)};
            this.myPrivateKey = SslSocketFactory.readPrivateKey(keyPath);
        }

        @Override
        @NotNull
        public String[] getClientAliases(String s, Principal[] principals) {
            String[] stringArray = new String[]{};
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/ssl/SslSocketFactory$MyKeyManager", "getClientAliases"));
            }
            return stringArray;
        }

        @Override
        public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
            return this.myAlias;
        }

        @Override
        @NotNull
        public String[] getServerAliases(String s, Principal[] principals) {
            String[] stringArray = new String[]{};
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/ssl/SslSocketFactory$MyKeyManager", "getServerAliases"));
            }
            return stringArray;
        }

        @Override
        @Nullable
        public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
            return null;
        }

        @Override
        @NotNull
        public X509Certificate[] getCertificateChain(String s) {
            if (this.myCertificates == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/ssl/SslSocketFactory$MyKeyManager", "getCertificateChain"));
            }
            return this.myCertificates;
        }

        @Override
        @NotNull
        public PrivateKey getPrivateKey(String s) {
            PrivateKey privateKey = this.myPrivateKey;
            if (privateKey == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/ssl/SslSocketFactory$MyKeyManager", "getPrivateKey"));
            }
            return privateKey;
        }
    }

    private static class MyTrustEverybodyManager
    implements X509TrustManager {
        private MyTrustEverybodyManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        @NotNull
        public X509Certificate[] getAcceptedIssuers() {
            X509Certificate[] x509CertificateArray = new X509Certificate[]{};
            if (x509CertificateArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/ssl/SslSocketFactory$MyTrustEverybodyManager", "getAcceptedIssuers"));
            }
            return x509CertificateArray;
        }
    }

    private static class MyTrustManager
    implements X509TrustManager {
        private X509TrustManager trustManager;

        private MyTrustManager(@NotNull X509Certificate caCertPath) throws Exception {
            if (caCertPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caCertPath", "com/intellij/execution/rmi/ssl/SslSocketFactory$MyTrustManager", "<init>"));
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(MyTrustManager.createStore(caCertPath));
            for (TrustManager tm : tmf.getTrustManagers()) {
                if (!(tm instanceof X509TrustManager)) continue;
                this.trustManager = (X509TrustManager)tm;
                break;
            }
            if (this.trustManager == null) {
                throw new RuntimeException("No X509TrustManager found");
            }
        }

        @NotNull
        private static KeyStore createStore(@NotNull X509Certificate certificate) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
            if (certificate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "certificate", "com/intellij/execution/rmi/ssl/SslSocketFactory$MyTrustManager", "createStore"));
            }
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null);
            ks.setCertificateEntry(UUID.randomUUID().toString(), certificate);
            KeyStore keyStore = ks;
            if (keyStore == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/ssl/SslSocketFactory$MyTrustManager", "createStore"));
            }
            return keyStore;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            if (this.trustManager == null) {
                throw new RuntimeException("No X509TrustManager found");
            }
            this.trustManager.checkServerTrusted(x509Certificates, s);
        }

        @Override
        @NotNull
        public X509Certificate[] getAcceptedIssuers() {
            X509Certificate[] x509CertificateArray = new X509Certificate[]{};
            if (x509CertificateArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/rmi/ssl/SslSocketFactory$MyTrustManager", "getAcceptedIssuers"));
            }
            return x509CertificateArray;
        }
    }
}

