/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts.impl;

import com.intellij.openapi.util.Pair;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.jps.incremental.artifacts.instructions.DestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.JarDestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.JarInfo;

public class DependentJarsEvaluator {
    private final Set<JarInfo> myJars = new LinkedHashSet<JarInfo>();

    public void addJarWithDependencies(JarInfo jarInfo) {
        if (this.myJars.add(jarInfo)) {
            DestinationInfo destination = jarInfo.getDestination();
            if (destination instanceof JarDestinationInfo) {
                this.addJarWithDependencies(((JarDestinationInfo)destination).getJarInfo());
            }
            for (Pair<String, Object> pair : jarInfo.getContent()) {
                if (!(pair.getSecond() instanceof JarInfo)) continue;
                this.addJarWithDependencies((JarInfo)pair.getSecond());
            }
        }
    }

    public Set<JarInfo> getJars() {
        return this.myJars;
    }
}

