/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class JarPathUtil {
    public static final String JAR_SEPARATOR = "!/";

    @NotNull
    public static File getLocalFile(@NotNull String fullPath) {
        if (fullPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullPath", "org/jetbrains/jps/incremental/artifacts/JarPathUtil", "getLocalFile"));
        }
        int i = fullPath.indexOf(JAR_SEPARATOR);
        String filePath = i == -1 ? fullPath : fullPath.substring(0, i);
        File file = new File(FileUtil.toSystemDependentName((String)filePath));
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/artifacts/JarPathUtil", "getLocalFile"));
        }
        return file;
    }
}

