/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.ide.Bootstrap;
import com.intellij.openapi.application.JetBrainsProtocolHandler;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Restarter;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTError;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;

public class Main {
    public static final int NO_GRAPHICS = 1;
    public static final int UPDATE_FAILED = 2;
    public static final int STARTUP_EXCEPTION = 3;
    public static final int JDK_CHECK_FAILED = 4;
    public static final int DIR_CHECK_FAILED = 5;
    public static final int INSTANCE_CHECK_FAILED = 6;
    public static final int LICENSE_ERROR = 7;
    public static final int PLUGIN_ERROR = 8;
    private static final String AWT_HEADLESS = "java.awt.headless";
    private static final String PLATFORM_PREFIX_PROPERTY = "idea.platform.prefix";
    private static final String[] NO_ARGS = new String[0];
    private static boolean isHeadless;
    private static boolean isCommandLine;
    private static boolean hasGraphics;

    private Main() {
    }

    public static void main(String[] args) {
        if (args.length == 1 && "%f".equals(args[0])) {
            args = NO_ARGS;
        }
        if (args.length == 1 && args[0].startsWith("jetbrains://")) {
            JetBrainsProtocolHandler.processJetBrainsLauncherParameters((String)args[0]);
            args = NO_ARGS;
        }
        Main.setFlags(args);
        if (Main.isHeadless()) {
            System.setProperty(AWT_HEADLESS, Boolean.TRUE.toString());
        } else if (!Main.checkGraphics()) {
            System.exit(1);
        }
        if (args.length == 0 || args.length == 1 && "nosplash".equals(args[0])) {
            try {
                Main.installPatch();
            }
            catch (Throwable t) {
                Main.showMessage("Update Failed", t);
                System.exit(2);
            }
        }
        try {
            Bootstrap.main(args, Main.class.getName() + "Impl", "start");
        }
        catch (Throwable t) {
            Main.showMessage("Start Failed", t);
            System.exit(3);
        }
    }

    public static boolean isHeadless() {
        return isHeadless;
    }

    public static boolean isCommandLine() {
        return isCommandLine;
    }

    public static void setFlags(String[] args) {
        isHeadless = Main.isHeadless(args);
        isCommandLine = Main.isCommandLine(args);
    }

    private static boolean isHeadless(String[] args) {
        if (Boolean.valueOf(System.getProperty(AWT_HEADLESS)).booleanValue()) {
            return true;
        }
        if (args.length == 0) {
            return false;
        }
        String firstArg = args[0];
        return Comparing.strEqual((String)firstArg, (String)"ant") || Comparing.strEqual((String)firstArg, (String)"duplocate") || Comparing.strEqual((String)firstArg, (String)"traverseUI") || firstArg.length() < 20 && firstArg.endsWith("inspect");
    }

    private static boolean isCommandLine(String[] args) {
        if (Main.isHeadless()) {
            return true;
        }
        return args.length > 0 && Comparing.strEqual((String)args[0], (String)"diff");
    }

    private static boolean checkGraphics() {
        if (GraphicsEnvironment.isHeadless()) {
            Main.showMessage("Startup Error", "Unable to detect graphics environment", true);
            return false;
        }
        return true;
    }

    public static boolean isUITraverser(String[] args) {
        return args.length > 0 && Comparing.strEqual((String)args[0], (String)"traverseUI");
    }

    private static boolean checkBundledJava(File java) throws Exception {
        String[] command = new String[]{java.getPath(), "-version"};
        try {
            int pos;
            Process process = Runtime.getRuntime().exec(command);
            String line = new BufferedReader(new InputStreamReader(process.getErrorStream())).readLine();
            if (line != null && (line.toLowerCase().startsWith("java version") || line.toLowerCase().startsWith("openjdk version")) && (pos = line.indexOf(46)) > 0) {
                int majorVersion = Integer.parseInt(line.substring(pos - 1, pos));
                int minorVersion = Integer.parseInt(line.substring(pos + 1, pos + 2));
                if (majorVersion > 1 || minorVersion > 5) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            System.out.println("updater: the java: " + command[0] + " is invalid.");
        }
        return false;
    }

    private static String getBundledJava(String javaHome) throws Exception {
        File javaCopy;
        String javaHomeCopy = System.getProperty("user.home") + "/." + System.getProperty("idea.paths.selector") + "/restart/jre";
        File file = javaCopy = SystemInfoRt.isWindows ? new File(javaHomeCopy + "/bin/java.exe") : new File(javaHomeCopy + "/bin/java");
        if (javaCopy != null && javaCopy.isFile() && Main.checkBundledJava(javaCopy)) {
            javaHome = javaHomeCopy;
        }
        if (javaHome != javaHomeCopy) {
            File javaHomeCopyDir = new File(javaHomeCopy);
            if (javaHomeCopyDir.exists()) {
                FileUtil.delete((File)javaHomeCopyDir);
            }
            System.out.println("Updater: java: " + javaHome + " copied to " + javaHomeCopy);
            FileUtil.copyDir((File)new File(javaHome), (File)javaHomeCopyDir);
            javaHome = javaHomeCopy;
        }
        return javaHome;
    }

    private static String getJava() throws Exception {
        String javaHome = System.getProperty("java.home");
        if (javaHome.toLowerCase().startsWith(PathManager.getHomePath().toLowerCase())) {
            System.out.println("Updater: uses bundled java.");
            javaHome = Main.getBundledJava(javaHome);
        }
        return javaHome + "/bin/java";
    }

    private static void installPatch() throws Exception {
        String platform = System.getProperty(PLATFORM_PREFIX_PROPERTY, "idea");
        String patchFileName = ("jetbrains.patch.jar." + platform).toLowerCase(Locale.US);
        String tempDir = System.getProperty("java.io.tmpdir");
        File patch = new File(tempDir, patchFileName);
        File patchCopy = new File(tempDir, patchFileName + "_copy");
        File log4jCopy = new File(tempDir, "log4j.jar." + platform + "_copy");
        File jnaUtilsCopy = new File(tempDir, "jna-platform.jar." + platform + "_copy");
        File jnaCopy = new File(tempDir, "jna.jar." + platform + "_copy");
        if (!(FileUtilRt.delete((File)patchCopy) && FileUtilRt.delete((File)log4jCopy) && FileUtilRt.delete((File)jnaUtilsCopy) && FileUtilRt.delete((File)jnaCopy))) {
            throw new IOException("Cannot delete temporary files in " + tempDir);
        }
        if (!patch.exists()) {
            return;
        }
        File log4j = new File(PathManager.getLibPath(), "log4j.jar");
        if (!log4j.exists()) {
            throw new IOException("Log4J is missing: " + log4j);
        }
        File jnaUtils = new File(PathManager.getLibPath(), "jna-platform.jar");
        if (!jnaUtils.exists()) {
            throw new IOException("jna-platform.jar is missing: " + jnaUtils);
        }
        File jna = new File(PathManager.getLibPath(), "jna.jar");
        if (!jna.exists()) {
            throw new IOException("jna is missing: " + jna);
        }
        Main.copyFile(patch, patchCopy, true);
        Main.copyFile(log4j, log4jCopy, false);
        Main.copyFile(jna, jnaCopy, false);
        Main.copyFile(jnaUtils, jnaUtilsCopy, false);
        int status = 0;
        if (Restarter.isSupported()) {
            ArrayList<String> args = new ArrayList<String>();
            if (SystemInfoRt.isWindows) {
                File launcher = new File(PathManager.getBinPath(), "VistaLauncher.exe");
                args.add(Restarter.createTempExecutable((File)launcher).getPath());
                Restarter.createTempExecutable((File)new File(PathManager.getBinPath(), "restarter.exe"));
            }
            String java = Main.getJava();
            Collections.addAll(args, java, "-Xmx750m", "-Djna.nosys=true", "-Djna.boot.library.path=", "-Djna.debug_load=true", "-Djna.debug_load.jna=true", "-classpath", patchCopy.getPath() + File.pathSeparator + log4jCopy.getPath() + File.pathSeparator + jnaCopy.getPath() + File.pathSeparator + jnaUtilsCopy.getPath(), "-Djava.io.tmpdir=" + tempDir, "-Didea.updater.log=" + PathManager.getLogPath(), "-Dswing.defaultlaf=" + UIManager.getSystemLookAndFeelClassName(), "com.intellij.updater.Runner", "install", PathManager.getHomePath());
            status = Restarter.scheduleRestart((String[])ArrayUtilRt.toStringArray(args));
        } else {
            String message = "Patch update is not supported - please do it manually";
            Main.showMessage("Update Error", message, true);
        }
        System.exit(status);
    }

    private static void copyFile(File original, File copy, boolean move) throws IOException {
        if (move) {
            if (!original.renameTo(copy) || !FileUtilRt.delete((File)original)) {
                throw new IOException("Cannot create temporary file: " + copy);
            }
        } else {
            FileUtilRt.copy((File)original, (File)copy);
            if (!copy.exists()) {
                throw new IOException("Cannot create temporary file: " + copy);
            }
        }
    }

    public static void showMessage(String title, Throwable t) {
        StringWriter message = new StringWriter();
        AWTError awtError = Main.findGraphicsError(t);
        if (awtError != null) {
            message.append("Failed to initialize graphics environment\n\n");
            hasGraphics = false;
            t = awtError;
        } else {
            message.append("Internal error. Please report to ");
            boolean studio = "AndroidStudio".equalsIgnoreCase(System.getProperty(PLATFORM_PREFIX_PROPERTY));
            message.append(studio ? "https://code.google.com/p/android/issues" : "http://jb.gg/ide/critical-startup-errors");
            message.append("\n\n");
        }
        t.printStackTrace(new PrintWriter(message));
        Main.showMessage(title, message.toString(), true);
    }

    private static AWTError findGraphicsError(Throwable t) {
        while (t != null) {
            if (t instanceof AWTError) {
                return (AWTError)t;
            }
            t = t.getCause();
        }
        return null;
    }

    public static void showMessage(String title, String message, boolean error) {
        boolean headless;
        PrintStream stream = error ? System.err : System.out;
        stream.println("\n" + title + ": " + message);
        boolean bl = headless = !hasGraphics || Main.isCommandLine() || GraphicsEnvironment.isHeadless();
        if (!headless) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                JTextPane textPane = new JTextPane();
                textPane.setEditable(false);
                textPane.setText(message.replaceAll("\t", "    "));
                textPane.setBackground(UIUtil.getPanelBackground());
                textPane.setCaretPosition(0);
                JScrollPane scrollPane = new JScrollPane(textPane, 20, 30);
                scrollPane.setBorder(null);
                int maxHeight = Math.min(JBUI.scale((int)600), Toolkit.getDefaultToolkit().getScreenSize().height - 150);
                int maxWidth = Math.min(JBUI.scale((int)600), Toolkit.getDefaultToolkit().getScreenSize().width - 150);
                Dimension component = scrollPane.getPreferredSize();
                if (component.height > maxHeight || component.width > maxWidth) {
                    scrollPane.setPreferredSize(new Dimension(Math.min(maxWidth, component.width), Math.min(maxHeight, component.height)));
                }
                int type = error ? 0 : 1;
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), scrollPane, title, type);
            }
            catch (Throwable t) {
                stream.println("\nAlso, an UI exception occurred on attempt to show above message:");
                t.printStackTrace(stream);
            }
        }
    }

    static {
        hasGraphics = true;
    }
}

