/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2;

import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.StickyHeadGetter;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.changeBrowser.CvsBinaryContentRevision;
import com.intellij.cvsSupport2.changeBrowser.CvsContentRevision;
import com.intellij.cvsSupport2.connections.CvsConnectionSettings;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.RevisionOrDate;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.RevisionOrDateImpl;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.SimpleRevision;
import com.intellij.cvsSupport2.history.CvsRevisionNumber;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.netbeans.lib.cvsclient.admin.Entry;

public class CvsDiffProvider
implements DiffProvider {
    private final Project myProject;

    public CvsDiffProvider(Project project) {
        this.myProject = project;
    }

    public VcsRevisionNumber getCurrentRevision(VirtualFile file) {
        Entry entry = CvsEntriesManager.getInstance().getEntryFor(file);
        if (entry == null) {
            return null;
        }
        return new CvsRevisionNumber(entry.getRevision());
    }

    public ItemLatestState getLastRevision(VirtualFile virtualFile) {
        if (virtualFile.getParent() == null) {
            return new ItemLatestState((VcsRevisionNumber)new CvsRevisionNumber("HEAD"), true, true);
        }
        return this.getLastState(virtualFile.getParent(), virtualFile.getName());
    }

    public ContentRevision createFileContent(VcsRevisionNumber revisionNumber, VirtualFile selectedFile) {
        if (revisionNumber instanceof CvsRevisionNumber) {
            CvsConnectionSettings settings = CvsEntriesManager.getInstance().getCvsConnectionSettingsFor(selectedFile.getParent());
            File file = new File(CvsUtil.getModuleName(selectedFile));
            CvsRevisionNumber cvsRevisionNumber = (CvsRevisionNumber)revisionNumber;
            Object versionInfo = cvsRevisionNumber.getDateOrRevision() != null ? RevisionOrDateImpl.createOn(cvsRevisionNumber.getDateOrRevision()) : new SimpleRevision(cvsRevisionNumber.asString());
            if (selectedFile.getFileType().isBinary()) {
                return new CvsBinaryContentRevision(file, file, (RevisionOrDate)versionInfo, settings, this.myProject);
            }
            return new CvsContentRevision(file, file, (RevisionOrDate)versionInfo, settings, this.myProject);
        }
        return null;
    }

    public ItemLatestState getLastRevision(FilePath filePath) {
        VirtualFile parent = filePath.getVirtualFileParent();
        if (parent == null) {
            parent = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(filePath.getParentPath().getIOFile());
        }
        if (parent != null) {
            return this.getLastState(parent, filePath.getName());
        }
        return new ItemLatestState((VcsRevisionNumber)new CvsRevisionNumber("HEAD"), true, true);
    }

    public VcsRevisionNumber getLatestCommittedRevision(VirtualFile vcsRoot) {
        return null;
    }

    private ItemLatestState getLastState(VirtualFile parent, String name) {
        Entry entry = CvsEntriesManager.getInstance().getEntryFor(parent, name);
        if (entry == null) {
            return new ItemLatestState((VcsRevisionNumber)new CvsRevisionNumber("HEAD"), true, true);
        }
        String stickyHead = new StickyHeadGetter.MyStickyBranchHeadGetter(entry.getRevision(), this.myProject).getHead(parent, name);
        if (stickyHead == null) {
            return new ItemLatestState((VcsRevisionNumber)new CvsRevisionNumber("HEAD"), true, true);
        }
        return new ItemLatestState((VcsRevisionNumber)new CvsRevisionNumber(stickyHead), !entry.isRemoved(), false);
    }
}

