/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.resolve.GradleMethodContextContributor;
import org.jetbrains.plugins.gradle.service.resolve.GradleResolverUtil;
import org.jetbrains.plugins.gradle.settings.GradleLocalSettings;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;

public class GradleImplicitContributor
implements GradleMethodContextContributor {
    private static final Map<String, String> BUILT_IN_TASKS = ContainerUtil.newHashMap((Pair)Couple.of((Object)"assemble", (Object)"org.gradle.api.DefaultTask"), (Pair[])new Pair[]{Couple.of((Object)"build", (Object)"org.gradle.api.DefaultTask"), Couple.of((Object)"buildDependents", (Object)"org.gradle.api.DefaultTask"), Couple.of((Object)"buildNeeded", (Object)"org.gradle.api.DefaultTask"), Couple.of((Object)"clean", (Object)"org.gradle.api.tasks.Delete"), Couple.of((Object)"jar", (Object)"org.gradle.api.tasks.bundling.Jar"), Couple.of((Object)"war", (Object)"org.gradle.api.tasks.bundling.War"), Couple.of((Object)"classes", (Object)"org.gradle.api.DefaultTask"), Couple.of((Object)"compileJava", (Object)"org.gradle.api.tasks.compile.JavaCompile"), Couple.of((Object)"compileTestJava", (Object)"org.gradle.api.DefaultTask"), Couple.of((Object)"processTestResources", (Object)"org.gradle.api.DefaultTask"), Couple.of((Object)"testClasses", (Object)"org.gradle.api.DefaultTask"), Couple.of((Object)"processResources", (Object)"org.gradle.language.jvm.tasks.ProcessResources"), Couple.of((Object)"setupBuild", (Object)"org.gradle.buildsetup.tasks.SetupBuild"), Couple.of((Object)"wrapper", (Object)"org.gradle.api.tasks.wrapper.Wrapper"), Couple.of((Object)"javadoc", (Object)"org.gradle.api.tasks.javadoc.Javadoc"), Couple.of((Object)"dependencies", (Object)"org.gradle.api.tasks.diagnostics.DependencyReportTask"), Couple.of((Object)"dependencyInsight", (Object)"org.gradle.api.tasks.diagnostics.DependencyInsightReportTask"), Couple.of((Object)"projects", (Object)"org.gradle.api.tasks.diagnostics.ProjectReportTask"), Couple.of((Object)"properties", (Object)"org.gradle.api.tasks.diagnostics.PropertyReportTask"), Couple.of((Object)"tasks", (Object)"org.gradle.api.tasks.diagnostics.TaskReportTask"), Couple.of((Object)"check", (Object)"org.gradle.api.DefaultTask"), Couple.of((Object)"test", (Object)"org.gradle.api.tasks.testing.Test"), Couple.of((Object)"uploadArchives", (Object)"org.gradle.api.tasks.Upload")});

    @Override
    public void process(@NotNull List<String> methodCallInfo, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        PsiType psiType;
        GrClosableBlock closableBlock;
        GroovyPsiManager psiManager;
        if (methodCallInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallInfo", "org/jetbrains/plugins/gradle/service/resolve/GradleImplicitContributor", "process"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/gradle/service/resolve/GradleImplicitContributor", "process"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/gradle/service/resolve/GradleImplicitContributor", "process"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/gradle/service/resolve/GradleImplicitContributor", "process"));
        }
        if (methodCallInfo.isEmpty()) {
            GradleImplicitContributor.checkForAvailableTasks(0, place.getText(), processor, state, place);
            return;
        }
        String methodCall = (String)ContainerUtil.getLastItem(methodCallInfo);
        if (methodCall == null) {
            return;
        }
        if (!methodCall.equals("task")) {
            if (methodCallInfo.size() == 1) {
                GradleImplicitContributor.checkForAvailableTasks(1, place.getText(), processor, state, place);
            }
            if (methodCallInfo.size() == 2) {
                GradleImplicitContributor.processAvailableTasks(methodCallInfo, methodCall, processor, state, place);
            }
        }
        if (methodCallInfo.size() >= 3 && Arrays.equals(ContainerUtil.ar((Object[])new String[]{"dirs", "flatDir", "repositories"}), methodCallInfo.subList(0, 3).toArray())) {
            psiManager = GroovyPsiManager.getInstance((Project)place.getProject());
            GradleResolverUtil.processDeclarations(psiManager, processor, state, place, "org.gradle.api.artifacts.repositories.FlatDirectoryArtifactRepository");
        }
        if (methodCallInfo.size() == 3) {
            psiManager = GroovyPsiManager.getInstance((Project)place.getProject());
            if ("manifest".equals(methodCallInfo.get(1)) && "jar".equals(methodCallInfo.get(2))) {
                GradleResolverUtil.processDeclarations(psiManager, processor, state, place, "org.gradle.api.java.archives.Manifest");
            }
        }
        if (place instanceof GrExpression && GradleResolverUtil.getTypeOf((GrExpression)place) == null && (closableBlock = GradleResolverUtil.findParent(place, GrClosableBlock.class)) != null && closableBlock.getParent() instanceof GrMethodCallExpression && (psiType = GradleResolverUtil.getTypeOf((GrExpression)closableBlock.getParent())) != null) {
            GroovyPsiManager psiManager2 = GroovyPsiManager.getInstance((Project)place.getProject());
            GradleResolverUtil.processDeclarations(psiManager2, processor, state, place, TypesUtil.getQualifiedName((PsiType)psiType));
        }
    }

    public static void processImplicitDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/gradle/service/resolve/GradleImplicitContributor", "processImplicitDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/gradle/service/resolve/GradleImplicitContributor", "processImplicitDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/gradle/service/resolve/GradleImplicitContributor", "processImplicitDeclarations"));
        }
        if (!place.getText().equals("resources")) {
            GroovyPsiManager psiManager = GroovyPsiManager.getInstance((Project)place.getProject());
            GradleResolverUtil.processDeclarations(psiManager, processor, state, place, "org.gradle.api.Project");
        }
    }

    private static void checkForAvailableTasks(int level, @Nullable String taskName, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/gradle/service/resolve/GradleImplicitContributor", "checkForAvailableTasks"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/gradle/service/resolve/GradleImplicitContributor", "checkForAvailableTasks"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/gradle/service/resolve/GradleImplicitContributor", "checkForAvailableTasks"));
        }
        if (taskName == null) {
            return;
        }
        GroovyPsiManager psiManager = GroovyPsiManager.getInstance((Project)place.getProject());
        PsiClass gradleApiProjectClass = psiManager.findClassWithCache("org.gradle.api.Project", place.getResolveScope());
        if (GradleResolverUtil.canBeMethodOf(taskName, gradleApiProjectClass)) {
            return;
        }
        if (GradleResolverUtil.canBeMethodOf(GroovyPropertyUtils.getGetterNameNonBoolean((String)taskName), gradleApiProjectClass)) {
            return;
        }
        String className = BUILT_IN_TASKS.get(taskName);
        if (className != null) {
            if (level <= 1) {
                GradleResolverUtil.addImplicitVariable(processor, state, place, className);
            }
            GradleImplicitContributor.processTask(taskName, className, psiManager, processor, state, place);
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)place);
        if (module == null) {
            return;
        }
        String path = module.getOptionValue("external.root.project.path");
        GradleLocalSettings localSettings = GradleLocalSettings.getInstance(place.getProject());
        Collection taskPojos = (Collection)localSettings.getAvailableTasks().get(path);
        if (taskPojos == null) {
            return;
        }
        for (ExternalTaskPojo taskPojo : taskPojos) {
            if (!taskName.equals(taskPojo.getName())) continue;
            GradleImplicitContributor.processTask(taskName, "org.gradle.api.Task", psiManager, processor, state, place);
            return;
        }
    }

    private static void processTask(@NotNull String taskName, @NotNull String fqName, @NotNull GroovyPsiManager psiManager, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        if (taskName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskName", "org/jetbrains/plugins/gradle/service/resolve/GradleImplicitContributor", "processTask"));
        }
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/plugins/gradle/service/resolve/GradleImplicitContributor", "processTask"));
        }
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "org/jetbrains/plugins/gradle/service/resolve/GradleImplicitContributor", "processTask"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/gradle/service/resolve/GradleImplicitContributor", "processTask"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/gradle/service/resolve/GradleImplicitContributor", "processTask"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/gradle/service/resolve/GradleImplicitContributor", "processTask"));
        }
        if (taskName.equals(place.getText())) {
            if (!(place instanceof GrClosableBlock)) {
                GrLightMethodBuilder methodBuilder = GradleResolverUtil.createMethodWithClosure(taskName, fqName, null, place, psiManager);
                if (methodBuilder == null) {
                    return;
                }
                processor.execute((PsiElement)methodBuilder, state);
                PsiClass contributorClass = psiManager.findClassWithCache(fqName, place.getResolveScope());
                if (contributorClass == null) {
                    return;
                }
                GradleResolverUtil.processMethod(taskName, contributorClass, processor, state, place);
            }
        } else {
            GradleResolverUtil.processDeclarations(psiManager, processor, state, place, fqName);
        }
    }

    private static void processAvailableTasks(List<String> methodCallInfo, @NotNull String taskName, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        if (taskName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskName", "org/jetbrains/plugins/gradle/service/resolve/GradleImplicitContributor", "processAvailableTasks"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/gradle/service/resolve/GradleImplicitContributor", "processAvailableTasks"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/gradle/service/resolve/GradleImplicitContributor", "processAvailableTasks"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/gradle/service/resolve/GradleImplicitContributor", "processAvailableTasks"));
        }
        GroovyPsiManager psiManager = GroovyPsiManager.getInstance((Project)place.getProject());
        PsiClass gradleApiProjectClass = psiManager.findClassWithCache("org.gradle.api.Project", place.getResolveScope());
        if (GradleResolverUtil.canBeMethodOf(taskName, gradleApiProjectClass)) {
            return;
        }
        if (GradleResolverUtil.canBeMethodOf(GroovyPropertyUtils.getGetterNameNonBoolean((String)taskName), gradleApiProjectClass)) {
            return;
        }
        String className = BUILT_IN_TASKS.get(taskName);
        if (className != null) {
            GradleResolverUtil.processDeclarations(methodCallInfo.size() > 0 ? methodCallInfo.get(0) : null, psiManager, processor, state, place, className);
        }
    }
}

