/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.converters.values;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiType;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.converters.values.BooleanValueConverter;
import com.intellij.util.xml.converters.values.CharacterValueConverter;
import com.intellij.util.xml.converters.values.ClassArrayConverter;
import com.intellij.util.xml.converters.values.ClassValueConverter;
import com.intellij.util.xml.converters.values.NumberValueConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericDomValueConvertersRegistry {
    private final Map<Condition<Pair<PsiType, GenericDomValue>>, Converter<?>> myConditionConverters = new LinkedHashMap();

    public void registerFromExtensions(ExtensionPointName<Provider> extensionPointName) {
        Provider[] providers;
        for (Provider provider : providers = (Provider[])Extensions.getExtensions(extensionPointName)) {
            this.registerConverter(provider.getConverter(), provider.getCondition());
        }
    }

    public void registerDefaultConverters() {
        this.registerBooleanConverters();
        this.registerCharacterConverter();
        this.registerNumberValueConverters();
        this.registerClassValueConverters();
    }

    private void registerBooleanConverters() {
        this.registerConverter(new BooleanValueConverter(false), PsiType.BOOLEAN);
        this.registerConverter(new BooleanValueConverter(true), Boolean.class);
    }

    public void registerClassValueConverters() {
        this.registerConverter(ClassValueConverter.getClassValueConverter(), Class.class);
        this.registerConverter(ClassArrayConverter.getClassArrayConverter(), Class[].class);
    }

    public void registerCharacterConverter() {
        this.registerConverter(new CharacterValueConverter(false), PsiType.CHAR);
        this.registerConverter(new CharacterValueConverter(true), Character.class);
    }

    public void registerNumberValueConverters() {
        this.registerConverter(new NumberValueConverter(Byte.TYPE, false), PsiType.BYTE);
        this.registerConverter(new NumberValueConverter(Byte.class, true), Byte.class);
        this.registerConverter(new NumberValueConverter(Short.TYPE, false), PsiType.SHORT);
        this.registerConverter(new NumberValueConverter(Short.class, true), Short.class);
        this.registerConverter(new NumberValueConverter(Integer.TYPE, false), PsiType.INT);
        this.registerConverter(new NumberValueConverter(Integer.class, true), Integer.class);
        this.registerConverter(new NumberValueConverter(Long.TYPE, false), PsiType.LONG);
        this.registerConverter(new NumberValueConverter(Long.class, true), Long.class);
        this.registerConverter(new NumberValueConverter(Float.TYPE, false), PsiType.FLOAT);
        this.registerConverter(new NumberValueConverter(Float.class, true), Float.class);
        this.registerConverter(new NumberValueConverter(Double.TYPE, false), PsiType.DOUBLE);
        this.registerConverter(new NumberValueConverter(Double.class, true), Double.class);
        this.registerConverter(new NumberValueConverter(BigDecimal.class, true), BigDecimal.class);
        this.registerConverter(new NumberValueConverter(BigInteger.class, true), BigInteger.class);
    }

    public void registerConverter(@NotNull Converter<?> provider, final @NotNull PsiType type) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/util/xml/converters/values/GenericDomValueConvertersRegistry", "registerConverter"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/util/xml/converters/values/GenericDomValueConvertersRegistry", "registerConverter"));
        }
        this.registerConverter(provider, new Condition<Pair<PsiType, GenericDomValue>>(){

            public boolean value(Pair<PsiType, GenericDomValue> pair) {
                return Comparing.equal((Object)pair.getFirst(), (Object)type);
            }
        });
    }

    public void registerConverter(@NotNull Converter<?> provider, @NotNull Condition<Pair<PsiType, GenericDomValue>> condition) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/util/xml/converters/values/GenericDomValueConvertersRegistry", "registerConverter"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/xml/converters/values/GenericDomValueConvertersRegistry", "registerConverter"));
        }
        this.myConditionConverters.put(condition, provider);
    }

    @Nullable
    public Converter<?> getConverter(@NotNull GenericDomValue domValue, @Nullable PsiType type) {
        if (domValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domValue", "com/intellij/util/xml/converters/values/GenericDomValueConvertersRegistry", "getConverter"));
        }
        Pair pair = Pair.create((Object)type, (Object)domValue);
        for (Condition<Pair<PsiType, GenericDomValue>> condition : this.myConditionConverters.keySet()) {
            if (!condition.value((Object)pair)) continue;
            return this.myConditionConverters.get(condition);
        }
        return null;
    }

    public void registerConverter(@NotNull Converter<?> provider, @NotNull Class type) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/util/xml/converters/values/GenericDomValueConvertersRegistry", "registerConverter"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/util/xml/converters/values/GenericDomValueConvertersRegistry", "registerConverter"));
        }
        final String name = type.getCanonicalName();
        this.registerConverter(provider, new Condition<Pair<PsiType, GenericDomValue>>(){

            public boolean value(Pair<PsiType, GenericDomValue> pair) {
                return pair.first != null && Comparing.equal((String)name, (String)((PsiType)pair.first).getCanonicalText());
            }
        });
    }

    public static interface Provider {
        public Converter getConverter();

        public Condition<Pair<PsiType, GenericDomValue>> getCondition();
    }
}

