/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.annotate.VcsAnnotation;
import com.intellij.openapi.vcs.history.HistoryCacheBaseKey;
import com.intellij.openapi.vcs.history.HistoryCacheWithRevisionKey;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsCacheableHistorySessionFactory;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.util.Consumer;
import com.intellij.util.containers.SLRUMap;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsHistoryCache {
    private final Object myLock = new Object();
    private final SLRUMap<HistoryCacheBaseKey, CachedHistory> myHistoryCache = new SLRUMap(10, 10);
    private final SLRUMap<HistoryCacheWithRevisionKey, VcsAnnotation> myAnnotationCache = new SLRUMap(10, 5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <C extends Serializable, T extends VcsAbstractHistorySession> void put(FilePath filePath2, @Nullable FilePath correctedPath, VcsKey vcsKey, T session, @NotNull VcsCacheableHistorySessionFactory<C, T> factory, boolean isFull) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/openapi/vcs/history/VcsHistoryCache", "put"));
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myHistoryCache.put((Object)new HistoryCacheBaseKey(filePath2, vcsKey), (Object)new CachedHistory(correctedPath != null ? correctedPath : filePath2, session.getRevisionList(), session.getCurrentRevisionNumber(), factory.getAddinionallyCachedData(session), isFull));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editCached(FilePath filePath2, VcsKey vcsKey, Consumer<List<VcsFileRevision>> consumer) {
        Object object = this.myLock;
        synchronized (object) {
            CachedHistory cachedHistory = (CachedHistory)this.myHistoryCache.get((Object)new HistoryCacheBaseKey(filePath2, vcsKey));
            if (cachedHistory != null) {
                consumer.consume(cachedHistory.getRevisions());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <C extends Serializable, T extends VcsAbstractHistorySession> T getFull(FilePath filePath2, VcsKey vcsKey, @NotNull VcsCacheableHistorySessionFactory<C, T> factory) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/openapi/vcs/history/VcsHistoryCache", "getFull"));
        }
        Object object = this.myLock;
        synchronized (object) {
            CachedHistory cachedHistory = (CachedHistory)this.myHistoryCache.get((Object)new HistoryCacheBaseKey(filePath2, vcsKey));
            if (cachedHistory == null || !cachedHistory.isIsFull()) {
                return null;
            }
            return factory.createFromCachedData((Serializable)cachedHistory.getCustomData(), cachedHistory.getRevisions(), cachedHistory.getPath(), cachedHistory.getCurrentRevision());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <C extends Serializable, T extends VcsAbstractHistorySession> T getMaybePartial(FilePath filePath2, VcsKey vcsKey, @NotNull VcsCacheableHistorySessionFactory<C, T> factory) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/openapi/vcs/history/VcsHistoryCache", "getMaybePartial"));
        }
        Object object = this.myLock;
        synchronized (object) {
            CachedHistory cachedHistory = (CachedHistory)this.myHistoryCache.get((Object)new HistoryCacheBaseKey(filePath2, vcsKey));
            if (cachedHistory == null) {
                return null;
            }
            return factory.createFromCachedData((Serializable)cachedHistory.getCustomData(), cachedHistory.getRevisions(), cachedHistory.getPath(), cachedHistory.getCurrentRevision());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.myLock;
        synchronized (object) {
            Iterator iterator = this.myHistoryCache.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = (Map.Entry)iterator.next();
                if (((HistoryCacheBaseKey)next.getKey()).getFilePath().isNonLocal()) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(@NotNull FilePath filePath2, @NotNull VcsKey vcsKey, @NotNull VcsRevisionNumber number, @NotNull VcsAnnotation vcsAnnotation) {
        if (filePath2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/history/VcsHistoryCache", "put"));
        }
        if (vcsKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsKey", "com/intellij/openapi/vcs/history/VcsHistoryCache", "put"));
        }
        if (number == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "number", "com/intellij/openapi/vcs/history/VcsHistoryCache", "put"));
        }
        if (vcsAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsAnnotation", "com/intellij/openapi/vcs/history/VcsHistoryCache", "put"));
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myAnnotationCache.put((Object)new HistoryCacheWithRevisionKey(filePath2, vcsKey, number), (Object)vcsAnnotation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VcsAnnotation get(@NotNull FilePath filePath2, @NotNull VcsKey vcsKey, @NotNull VcsRevisionNumber number) {
        if (filePath2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/vcs/history/VcsHistoryCache", "get"));
        }
        if (vcsKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsKey", "com/intellij/openapi/vcs/history/VcsHistoryCache", "get"));
        }
        if (number == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "number", "com/intellij/openapi/vcs/history/VcsHistoryCache", "get"));
        }
        Object object = this.myLock;
        synchronized (object) {
            return (VcsAnnotation)this.myAnnotationCache.get((Object)new HistoryCacheWithRevisionKey(filePath2, vcsKey, number));
        }
    }

    public static class CachedHistory {
        private final FilePath myPath;
        private final List<VcsFileRevision> myRevisions;
        private final VcsRevisionNumber myCurrentRevision;
        private final Object myCustomData;
        private final boolean myIsFull;

        public CachedHistory(FilePath path2, List<VcsFileRevision> revisions, VcsRevisionNumber currentRevision, Object customData, boolean isFull) {
            this.myPath = path2;
            this.myRevisions = revisions;
            this.myCurrentRevision = currentRevision;
            this.myCustomData = customData;
            this.myIsFull = isFull;
        }

        public FilePath getPath() {
            return this.myPath;
        }

        public List<VcsFileRevision> getRevisions() {
            return this.myRevisions;
        }

        public VcsRevisionNumber getCurrentRevision() {
            return this.myCurrentRevision;
        }

        public Object getCustomData() {
            return this.myCustomData;
        }

        public boolean isIsFull() {
            return this.myIsFull;
        }
    }
}

