/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.wizard;

import com.intellij.ide.wizard.AbstractWizard;
import com.intellij.ide.wizard.AbstractWizardStepEx;
import com.intellij.ide.wizard.CommitStepCancelledException;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class AbstractWizardEx
extends AbstractWizard<AbstractWizardStepEx> {
    private final String myTitle;
    private final Map<Object, Integer> myStepId2Index = new HashMap<Object, Integer>();
    private final Map<Integer, AbstractWizardStepEx> myIndex2Step = new HashMap<Integer, AbstractWizardStepEx>();

    public AbstractWizardEx(String title, @Nullable Project project, List<? extends AbstractWizardStepEx> steps) {
        super(title, project);
        this.myTitle = title;
        int index = 0;
        for (AbstractWizardStepEx abstractWizardStepEx : steps) {
            this.myStepId2Index.put(abstractWizardStepEx.getStepId(), index);
            this.myIndex2Step.put(index, abstractWizardStepEx);
            this.addStep(abstractWizardStepEx);
            abstractWizardStepEx.addStepListener(new AbstractWizardStepEx.Listener(){

                @Override
                public void stateChanged() {
                    AbstractWizardEx.this.updateButtons();
                }

                @Override
                public void doNextAction() {
                    if (AbstractWizardEx.this.getNextButton().isEnabled()) {
                        AbstractWizardEx.this.doNextAction();
                    }
                }
            });
            ++index;
        }
        this.init();
    }

    @Override
    protected void doPreviousAction() {
        AbstractWizardStepEx currentStep = (AbstractWizardStepEx)this.mySteps.get(this.myCurrentStep);
        try {
            currentStep._commitPrev();
        }
        catch (CommitStepCancelledException e) {
            return;
        }
        catch (CommitStepException e) {
            Messages.showErrorDialog(this.getContentPane(), e.getMessage());
            return;
        }
        this.myCurrentStep = this.getPreviousStep(this.myCurrentStep);
        this.updateStep();
    }

    @Override
    protected void doNextAction() {
        AbstractWizardStepEx currentStep = (AbstractWizardStepEx)this.mySteps.get(this.myCurrentStep);
        try {
            currentStep._commit(false);
        }
        catch (CommitStepCancelledException e) {
            return;
        }
        catch (CommitStepException e) {
            Messages.showErrorDialog(this.getContentPane(), e.getMessage());
            return;
        }
        if (this.isLastStep()) {
            this.doOKAction();
            return;
        }
        this.myCurrentStep = this.getNextStep(this.myCurrentStep);
        this.updateStep();
    }

    @Override
    protected int getNextStep(int step) {
        AbstractWizardStepEx stepObject = this.myIndex2Step.get(step);
        Object nextStepId = stepObject.getNextStepId();
        return this.myStepId2Index.get(nextStepId);
    }

    @Override
    protected int getPreviousStep(int step) {
        AbstractWizardStepEx stepObject = this.myIndex2Step.get(step);
        Object previousStepId = stepObject.getPreviousStepId();
        return this.myStepId2Index.get(previousStepId);
    }

    @Override
    protected String getHelpID() {
        return ((AbstractWizardStepEx)this.getCurrentStepObject()).getHelpId();
    }

    @Override
    protected void updateStep() {
        super.updateStep();
        this.updateButtons();
        AbstractWizardStepEx step = (AbstractWizardStepEx)this.getCurrentStepObject();
        String stepTitle = step.getTitle();
        this.setTitle(stepTitle != null ? this.myTitle + ": " + stepTitle : this.myTitle);
        JComponent toFocus = step.getPreferredFocusedComponent();
        if (toFocus != null) {
            IdeFocusManager.findInstanceByComponent(this.getWindow()).requestFocus(toFocus, true);
        }
    }

    @Override
    protected void updateButtons() {
        super.updateButtons();
        this.getPreviousButton().setEnabled(((AbstractWizardStepEx)this.getCurrentStepObject()).getPreviousStepId() != null);
        this.getNextButton().setEnabled(((AbstractWizardStepEx)this.getCurrentStepObject()).isComplete() && !this.isLastStep() || this.isLastStep() && this.canFinish());
    }

    @Override
    protected boolean canGoNext() {
        return ((AbstractWizardStepEx)this.getCurrentStepObject()).isComplete();
    }

    @Override
    protected boolean isLastStep() {
        return this.myIndex2Step.get(this.myCurrentStep).getNextStepId() == null;
    }

    @Override
    protected boolean canFinish() {
        for (AbstractWizardStepEx step : this.mySteps) {
            if (step.isComplete()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void dispose() {
        super.dispose();
        for (AbstractWizardStepEx step : this.mySteps) {
            Disposer.dispose((Disposable)step);
        }
    }
}

