/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.ui.libraries;

import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RemoteRepositoryInfo {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.ui.libraries.RemoteRepositoryInfo");
    private final String myId;
    private final String myPresentableName;
    private final String[] myMirrors;

    public RemoteRepositoryInfo(@NotNull @NonNls String id, @NotNull @Nls String presentableName, @NotNull @NonNls String[] mirrors) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/facet/ui/libraries/RemoteRepositoryInfo", "<init>"));
        }
        if (presentableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "com/intellij/facet/ui/libraries/RemoteRepositoryInfo", "<init>"));
        }
        if (mirrors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mirrors", "com/intellij/facet/ui/libraries/RemoteRepositoryInfo", "<init>"));
        }
        this.myId = id;
        LOG.assertTrue(mirrors.length > 0);
        this.myPresentableName = presentableName;
        this.myMirrors = mirrors;
    }

    public String getId() {
        return this.myId;
    }

    public String getPresentableName() {
        return this.myPresentableName;
    }

    public String[] getMirrors() {
        return this.myMirrors;
    }

    public String getDefaultMirror() {
        return this.myMirrors[0];
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteRepositoryInfo that = (RemoteRepositoryInfo)o;
        return this.myId.equals(that.myId);
    }

    public int hashCode() {
        return this.myId.hashCode();
    }
}

