/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.fixtures.LightCodeInsightFixtureTestCase;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class LightFixtureCompletionTestCase
extends LightCodeInsightFixtureTestCase {
    protected LookupElement[] myItems;

    @Override
    @NotNull
    protected LightProjectDescriptor getProjectDescriptor() {
        LightProjectDescriptor lightProjectDescriptor = JAVA_1_6;
        if (lightProjectDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/LightFixtureCompletionTestCase", "getProjectDescriptor"));
        }
        return lightProjectDescriptor;
    }

    @Override
    protected void tearDown() throws Exception {
        this.myItems = null;
        super.tearDown();
    }

    protected void configureByFile(String path2) {
        this.myFixture.configureFromExistingVirtualFile(this.myFixture.copyFileToProject(path2, StringUtil.getShortName((String)path2, (char)'/')));
        this.complete();
    }

    protected void configureByTestName() {
        this.configureByFile("/" + this.getTestName(false) + ".java");
    }

    protected void doAntiTest() {
        this.configureByTestName();
        this.checkResultByFile(this.getTestName(false) + ".java");
        LightFixtureCompletionTestCase.assertEmpty((Object[])this.myItems);
        LightFixtureCompletionTestCase.assertNull((Object)this.getLookup());
    }

    protected void complete() {
        this.myItems = this.myFixture.completeBasic();
    }

    protected void selectItem(LookupElement item) {
        this.selectItem(item, '\u0000');
    }

    protected void checkResultByFile(String path2) {
        this.myFixture.checkResultByFile(path2);
    }

    protected void selectItem(LookupElement item, final char completionChar) {
        final LookupImpl lookup = this.getLookup();
        lookup.setCurrentItem(item);
        if (LookupEvent.isSpecialCompletionChar(completionChar)) {
            new WriteCommandAction.Simple(this.getProject(), new PsiFile[0]){

                @Override
                protected void run() throws Throwable {
                    lookup.finishLookup(completionChar);
                }
            }.execute().throwException();
        } else {
            this.type(completionChar);
        }
    }

    protected LookupImpl getLookup() {
        return (LookupImpl)LookupManager.getInstance((Project)this.getProject()).getActiveLookup();
    }

    protected void assertFirstStringItems(String ... items) {
        List strings = this.myFixture.getLookupElementStrings();
        LightFixtureCompletionTestCase.assertNotNull((Object)strings);
        LightFixtureCompletionTestCase.assertOrderedEquals(strings.subList(0, Math.min(items.length, strings.size())), (Object[])items);
    }

    protected void assertStringItems(String ... items) {
        LightFixtureCompletionTestCase.assertOrderedEquals((Iterable)this.myFixture.getLookupElementStrings(), (Object[])items);
    }

    protected void type(String s) {
        this.myFixture.type(s);
    }

    protected void type(char c) {
        this.myFixture.type(c);
    }
}

