/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.provider;

import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusFactory;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.LocallyDeletedChange;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgChange;
import org.zmlx.hg4idea.HgContentRevision;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgFileStatusEnum;
import org.zmlx.hg4idea.HgNameWithHashInfo;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.command.HgResolveCommand;
import org.zmlx.hg4idea.command.HgResolveStatusEnum;
import org.zmlx.hg4idea.command.HgStatusCommand;
import org.zmlx.hg4idea.command.HgWorkingCopyRevisionsCommand;
import org.zmlx.hg4idea.provider.HgCurrentContentRevision;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgUtil;

public class HgChangeProvider
implements ChangeProvider {
    private final Project myProject;
    private final VcsKey myVcsKey;
    public static final FileStatus COPIED = FileStatusFactory.getInstance().createFileStatus("COPIED", "Copied", FileStatus.COLOR_ADDED);
    public static final FileStatus RENAMED = FileStatusFactory.getInstance().createFileStatus("RENAMED", "Renamed", JBColor.CYAN.darker().darker());
    private static final EnumMap<HgFileStatusEnum, HgChangeProcessor> PROCESSORS = new EnumMap(HgFileStatusEnum.class);

    public HgChangeProvider(Project project, VcsKey vcsKey) {
        this.myProject = project;
        this.myVcsKey = vcsKey;
    }

    public boolean isModifiedDocumentTrackingRequired() {
        return true;
    }

    public void doCleanup(List<VirtualFile> files) {
    }

    public void getChanges(VcsDirtyScope dirtyScope, ChangelistBuilder builder, ProgressIndicator progress, ChangeListManagerGate addGate) throws VcsException {
        if (this.myProject.isDisposed()) {
            return;
        }
        HashSet<HgChange> changes = new HashSet<HgChange>();
        changes.addAll(this.process(builder, dirtyScope.getRecursivelyDirtyDirectories()));
        changes.addAll(this.process(builder, dirtyScope.getDirtyFiles()));
        this.processUnsavedChanges(builder, dirtyScope.getDirtyFilesNoExpand(), changes);
    }

    private Collection<HgChange> process(ChangelistBuilder builder, Collection<FilePath> files) {
        HashSet<HgChange> hgChanges = new HashSet<HgChange>();
        for (Map.Entry<VirtualFile, Collection<FilePath>> entry : HgUtil.groupFilePathsByHgRoots(this.myProject, files).entrySet()) {
            VirtualFile repo = entry.getKey();
            HgRevisionNumber workingRevision = (HgRevisionNumber)new HgWorkingCopyRevisionsCommand(this.myProject).identify(repo).getFirst();
            HgRevisionNumber parentRevision = new HgWorkingCopyRevisionsCommand(this.myProject).firstParent(repo);
            Map<HgFile, HgResolveStatusEnum> list = new HgResolveCommand(this.myProject).getListSynchronously(repo);
            hgChanges.addAll(new HgStatusCommand.Builder(true).build(this.myProject).execute(repo, entry.getValue()));
            final HgRepository hgRepo = HgUtil.getRepositoryForFile(this.myProject, repo);
            if (hgRepo != null && hgRepo.hasSubrepos()) {
                hgChanges.addAll(ContainerUtil.mapNotNull(hgRepo.getSubrepos(), (Function)new Function<HgNameWithHashInfo, HgChange>(){

                    public HgChange fun(HgNameWithHashInfo info) {
                        return HgChangeProvider.this.findChange(hgRepo, info);
                    }
                }));
            }
            this.sendChanges(builder, hgChanges, list, workingRevision, parentRevision);
        }
        return hgChanges;
    }

    @Nullable
    private HgChange findChange(@NotNull HgRepository hgRepo, @NotNull HgNameWithHashInfo info) {
        if (hgRepo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hgRepo", "org/zmlx/hg4idea/provider/HgChangeProvider", "findChange"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/zmlx/hg4idea/provider/HgChangeProvider", "findChange"));
        }
        File file = new File(hgRepo.getRoot().getPath(), info.getName());
        VirtualFile virtualSubrepoFile = VfsUtil.findFileByIoFile((File)file, (boolean)false);
        HgRepository subrepo = HgUtil.getRepositoryForFile(this.myProject, virtualSubrepoFile);
        if (subrepo != null && !info.getHash().asString().equals(subrepo.getCurrentRevision())) {
            return new HgChange(new HgFile(hgRepo.getRoot(), VcsUtil.getFilePath((VirtualFile)virtualSubrepoFile)), HgFileStatusEnum.MODIFIED);
        }
        return null;
    }

    private void sendChanges(ChangelistBuilder builder, Set<HgChange> changes, Map<HgFile, HgResolveStatusEnum> resolveStatus, HgRevisionNumber workingRevision, HgRevisionNumber parentRevision) {
        for (HgChange change : changes) {
            HgChangeProcessor processor;
            HgFile afterFile = change.afterFile();
            HgFile beforeFile = change.beforeFile();
            HgFileStatusEnum status = change.getStatus();
            if (resolveStatus.containsKey(afterFile) && resolveStatus.get(afterFile) == HgResolveStatusEnum.UNRESOLVED) {
                builder.processChange(new Change((ContentRevision)HgContentRevision.create(this.myProject, beforeFile, parentRevision), HgCurrentContentRevision.create(afterFile, workingRevision), FileStatus.MERGED_WITH_CONFLICTS), this.myVcsKey);
                continue;
            }
            if (HgChangeProvider.isDeleteOfCopiedFile(change, changes) || (processor = PROCESSORS.get((Object)status)) == null) continue;
            processor.process(this.myProject, this.myVcsKey, builder, workingRevision, parentRevision, beforeFile, afterFile);
        }
    }

    private static boolean isDeleteOfCopiedFile(@NotNull HgChange change, Set<HgChange> changes) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "org/zmlx/hg4idea/provider/HgChangeProvider", "isDeleteOfCopiedFile"));
        }
        if (change.getStatus().equals((Object)HgFileStatusEnum.DELETED)) {
            for (HgChange otherChange : changes) {
                if (!otherChange.getStatus().equals((Object)HgFileStatusEnum.COPY) || !otherChange.beforeFile().equals(change.afterFile())) continue;
                return true;
            }
        }
        return false;
    }

    public void processUnsavedChanges(ChangelistBuilder builder, Set<FilePath> dirtyFiles, Collection<HgChange> alreadyProcessed) {
        for (HgChange c : alreadyProcessed) {
            dirtyFiles.remove(c.beforeFile().toFilePath());
            dirtyFiles.remove(c.afterFile().toFilePath());
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        for (FilePath filePath : dirtyFiles) {
            VirtualFile root;
            VirtualFile vf = filePath.getVirtualFile();
            if (vf == null || !fileDocumentManager.isFileModified(vf) || (root = vcsManager.getVcsRootFor(vf)) == null || !HgUtil.isHgRoot(root)) continue;
            HgRevisionNumber beforeRevisionNumber = new HgWorkingCopyRevisionsCommand(this.myProject).tip(root);
            HgContentRevision beforeRevision = beforeRevisionNumber == null ? null : HgContentRevision.create(this.myProject, new HgFile(this.myProject, vf), beforeRevisionNumber);
            builder.processChange(new Change((ContentRevision)beforeRevision, CurrentContentRevision.create((FilePath)filePath), FileStatus.MODIFIED), this.myVcsKey);
        }
    }

    static {
        PROCESSORS.put(HgFileStatusEnum.ADDED, HgChangeProcessor.ADDED);
        PROCESSORS.put(HgFileStatusEnum.DELETED, HgChangeProcessor.DELETED);
        PROCESSORS.put(HgFileStatusEnum.IGNORED, HgChangeProcessor.IGNORED);
        PROCESSORS.put(HgFileStatusEnum.MISSING, HgChangeProcessor.MISSING);
        PROCESSORS.put(HgFileStatusEnum.COPY, HgChangeProcessor.COPIED);
        PROCESSORS.put(HgFileStatusEnum.MODIFIED, HgChangeProcessor.MODIFIED);
        PROCESSORS.put(HgFileStatusEnum.UNMODIFIED, HgChangeProcessor.UNMODIFIED);
        PROCESSORS.put(HgFileStatusEnum.UNVERSIONED, HgChangeProcessor.UNVERSIONED);
    }

    private static enum HgChangeProcessor {
        ADDED{

            @Override
            void process(Project project, VcsKey vcsKey, ChangelistBuilder builder, HgRevisionNumber currentNumber, HgRevisionNumber parentRevision, HgFile beforeFile, HgFile afterFile) {
                1.processChange(null, HgCurrentContentRevision.create(afterFile, currentNumber), FileStatus.ADDED, builder, vcsKey);
            }
        }
        ,
        DELETED{

            @Override
            void process(Project project, VcsKey vcsKey, ChangelistBuilder builder, HgRevisionNumber currentNumber, HgRevisionNumber parentRevision, HgFile beforeFile, HgFile afterFile) {
                2.processChange(HgContentRevision.create(project, beforeFile, parentRevision), null, FileStatus.DELETED, builder, vcsKey);
            }
        }
        ,
        IGNORED{

            @Override
            void process(Project project, VcsKey vcsKey, ChangelistBuilder builder, HgRevisionNumber currentNumber, HgRevisionNumber parentRevision, HgFile beforeFile, HgFile afterFile) {
                builder.processIgnoredFile(VcsUtil.getVirtualFile((File)afterFile.getFile()));
            }
        }
        ,
        MISSING{

            @Override
            void process(Project project, VcsKey vcsKey, ChangelistBuilder builder, HgRevisionNumber currentNumber, HgRevisionNumber parentRevision, HgFile beforeFile, HgFile afterFile) {
                builder.processLocallyDeletedFile(new LocallyDeletedChange(beforeFile.toFilePath()));
            }
        }
        ,
        COPIED{

            @Override
            void process(Project project, VcsKey vcsKey, ChangelistBuilder builder, HgRevisionNumber currentNumber, HgRevisionNumber parentRevision, HgFile beforeFile, HgFile afterFile) {
                if (beforeFile.getFile().exists()) {
                    5.processChange(null, HgCurrentContentRevision.create(afterFile, currentNumber), FileStatus.ADDED, builder, vcsKey);
                } else {
                    5.processChange(HgContentRevision.create(project, beforeFile, parentRevision), HgCurrentContentRevision.create(afterFile, currentNumber), RENAMED, builder, vcsKey);
                }
            }
        }
        ,
        MODIFIED{

            @Override
            void process(Project project, VcsKey vcsKey, ChangelistBuilder builder, HgRevisionNumber currentNumber, HgRevisionNumber parentRevision, HgFile beforeFile, HgFile afterFile) {
                6.processChange(HgContentRevision.create(project, beforeFile, parentRevision), HgCurrentContentRevision.create(afterFile, currentNumber), FileStatus.MODIFIED, builder, vcsKey);
            }
        }
        ,
        UNMODIFIED{

            @Override
            void process(Project project, VcsKey vcsKey, ChangelistBuilder builder, HgRevisionNumber currentNumber, HgRevisionNumber parentRevision, HgFile beforeFile, HgFile afterFile) {
            }
        }
        ,
        UNVERSIONED{

            @Override
            void process(Project project, VcsKey vcsKey, ChangelistBuilder builder, HgRevisionNumber currentNumber, HgRevisionNumber parentRevision, HgFile beforeFile, HgFile afterFile) {
                builder.processUnversionedFile(VcsUtil.getVirtualFile((File)afterFile.getFile()));
            }
        };


        abstract void process(Project var1, VcsKey var2, ChangelistBuilder var3, HgRevisionNumber var4, HgRevisionNumber var5, HgFile var6, HgFile var7);

        static void processChange(ContentRevision contentRevisionBefore, ContentRevision contentRevisionAfter, FileStatus fileStatus, ChangelistBuilder builder, VcsKey vcsKey) {
            if (contentRevisionBefore == null && contentRevisionAfter == null) {
                return;
            }
            builder.processChange(new Change(contentRevisionBefore, contentRevisionAfter, fileStatus), vcsKey);
        }
    }
}

