/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.LineHandlerHelper;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.execution.HgCommandProcessHandler;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.ShellCommandException;

public final class ShellCommand {
    private final GeneralCommandLine myCommandLine;

    public ShellCommand(@Nullable List<String> commandLine, @Nullable String dir, @Nullable Charset charset) {
        if (commandLine == null || commandLine.isEmpty()) {
            throw new IllegalArgumentException("commandLine is empty");
        }
        this.myCommandLine = new GeneralCommandLine(commandLine);
        if (dir != null) {
            this.myCommandLine.setWorkDirectory(new File(dir));
        }
        if (charset != null) {
            this.myCommandLine.setCharset(charset);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myCommandLine.getEnvironment().put("HGRCPATH", "");
        }
    }

    @NotNull
    public HgCommandResult execute(final boolean showTextOnIndicator, boolean isBinary) throws ShellCommandException, InterruptedException {
        HgCommandResult hgCommandResult;
        block3: {
            final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            try {
                ProcessOutput output;
                HgCommandProcessHandler processHandler = new HgCommandProcessHandler(this.myCommandLine, isBinary);
                CapturingProcessAdapter outputAdapter = new CapturingProcessAdapter(){

                    public void onTextAvailable(ProcessEvent event, Key outputType) {
                        Iterator lines = LineHandlerHelper.splitText((String)event.getText()).iterator();
                        if (ProcessOutputTypes.STDOUT == outputType) {
                            while (lines.hasNext()) {
                                String line = (String)lines.next();
                                if (indicator != null && showTextOnIndicator) {
                                    indicator.setText2(line);
                                }
                                this.addToOutput(line, ProcessOutputTypes.STDOUT);
                            }
                        } else {
                            super.onTextAvailable(event, outputType);
                        }
                    }
                };
                processHandler.addProcessListener((ProcessListener)outputAdapter);
                processHandler.startNotify();
                while (!processHandler.waitFor(300L)) {
                    if (indicator == null || !indicator.isCanceled()) continue;
                    processHandler.destroyProcess();
                    outputAdapter.getOutput().setExitCode(255);
                    break;
                }
                if ((hgCommandResult = new HgCommandResult(output = outputAdapter.getOutput(), processHandler.getBinaryOutput())) != null) break block3;
            }
            catch (ExecutionException e) {
                throw new ShellCommandException(e);
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/execution/ShellCommand", "execute"));
        }
        return hgCommandResult;
    }
}

