/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl.configuration;

import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.impl.AntBuildFileImpl;
import com.intellij.lang.ant.config.impl.AntConfigurationImpl;
import com.intellij.lang.ant.config.impl.AntInstallation;
import com.intellij.lang.ant.config.impl.AntReference;
import com.intellij.lang.ant.config.impl.BuildFileProperty;
import com.intellij.lang.ant.config.impl.GlobalAntConfiguration;
import com.intellij.lang.ant.config.impl.TargetFilter;
import com.intellij.lang.ant.config.impl.configuration.AntClasspathEditorPanel;
import com.intellij.lang.ant.config.impl.configuration.AntSetPanel;
import com.intellij.lang.ant.config.impl.configuration.AntUIUtil;
import com.intellij.lang.ant.config.impl.configuration.ChooseAndEditComboBoxController;
import com.intellij.lang.ant.config.impl.configuration.RunWithAntBinding;
import com.intellij.lang.ant.config.impl.configuration.UIPropertyBinding;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ui.ProjectJdksEditor;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildFilePropertiesPanel {
    @NonNls
    private static final String DIMENSION_SERVICE_KEY = "antBuildFilePropertiesDialogDimension";
    private final Form myForm;
    private AntBuildFileBase myBuildFile;

    private BuildFilePropertiesPanel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/ant/config/impl/configuration/BuildFilePropertiesPanel", "<init>"));
        }
        this.myForm = new Form(project);
    }

    private void reset(AntBuildFileBase buildFile) {
        this.myBuildFile = buildFile;
        buildFile.updateProperties();
        this.myForm.reset(this.myBuildFile);
    }

    private void apply() {
        this.myForm.apply(this.myBuildFile);
        this.myBuildFile.updateConfig();
    }

    private boolean showDialog() {
        boolean isOk;
        DialogBuilder builder = new DialogBuilder(this.myBuildFile.getProject());
        builder.setCenterPanel((JComponent)this.myForm.myWholePanel);
        builder.setDimensionServiceKey(DIMENSION_SERVICE_KEY);
        builder.setPreferredFocusComponent(this.myForm.getPreferedFocusComponent());
        builder.setTitle(AntBundle.message("build.file.properties.dialog.title", new Object[0]));
        builder.removeAllActions();
        builder.addOkAction();
        builder.addCancelAction();
        builder.setHelpId("reference.dialogs.buildfileproperties");
        boolean bl = isOk = builder.show() == 0;
        if (isOk) {
            this.apply();
        }
        this.beforeClose();
        return isOk;
    }

    private void beforeClose() {
        this.myForm.beforeClose(this.myBuildFile);
        Disposer.dispose((Disposable)this.myForm);
    }

    public static boolean editBuildFile(AntBuildFileBase buildFile, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/ant/config/impl/configuration/BuildFilePropertiesPanel", "editBuildFile"));
        }
        BuildFilePropertiesPanel panel = new BuildFilePropertiesPanel(project);
        panel.reset(buildFile);
        return panel.showDialog();
    }

    private static void setLabelFor(JLabel label, ComponentWithBrowseButton component) {
        label.setLabelFor(component.getChildComponent());
    }

    private static class AdditionalClasspathTab
    extends Tab {
        private JPanel myWholePanel;
        private AntClasspathEditorPanel myClasspath;

        public AdditionalClasspathTab() {
            this.$$$setupUI$$$();
            this.getBinding().addBinding(this.myClasspath.setClasspathProperty(AntBuildFileImpl.ADDITIONAL_CLASSPATH));
        }

        @Override
        public JComponent getComponent() {
            return this.myWholePanel;
        }

        @Override
        @Nullable
        public String getDisplayName() {
            return AntBundle.message("edit.ant.properties.additional.classpath.tab.display.name", new Object[0]);
        }

        @Override
        public JComponent getPreferedFocusComponent() {
            return this.myClasspath.getPreferedFocusComponent();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            AntClasspathEditorPanel antClasspathEditorPanel;
            JPanel jPanel;
            this.myWholePanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(6, 6, 6, 6), -1, -1, false, false));
            this.myClasspath = antClasspathEditorPanel = new AntClasspathEditorPanel();
            ((Component)antClasspathEditorPanel).setEnabled(true);
            jPanel.add((Component)antClasspathEditorPanel, new GridConstraints(0, 0, 1, 1, 8, 3, 7, 7, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myWholePanel;
        }
    }

    static class ExecutionTab
    extends Tab {
        private JPanel myWholePanel;
        private JLabel myAntCmdLineLabel;
        private JLabel myJDKLabel;
        private RawCommandLineEditor myAntCommandLine;
        private ComboboxWithBrowseButton myAnts;
        private ComboboxWithBrowseButton myJDKs;
        private final ChooseAndEditComboBoxController<Sdk, String> myJDKsController;
        private JButton mySetDefaultAnt;
        private SimpleColoredComponent myDefaultAnt;
        private JRadioButton myUseCastomAnt;
        private JRadioButton myUseDefaultAnt;
        private AntReference myProjectDefaultAnt;
        private final GlobalAntConfiguration myAntGlobalConfiguration;
        private final Project myProject;

        public ExecutionTab(GlobalAntConfiguration antConfiguration, @NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/ant/config/impl/configuration/BuildFilePropertiesPanel$ExecutionTab", "<init>"));
            }
            this.myProjectDefaultAnt = null;
            this.myAntGlobalConfiguration = antConfiguration;
            this.myProject = project;
            this.$$$setupUI$$$();
            this.myAntCommandLine.attachLabel(this.myAntCmdLineLabel);
            this.myAntCommandLine.setDialogCaption(AntBundle.message("run.execution.tab.ant.command.line.dialog.title", new Object[0]));
            BuildFilePropertiesPanel.setLabelFor(this.myJDKLabel, (ComponentWithBrowseButton)this.myJDKs);
            this.myJDKsController = new ChooseAndEditComboBoxController<Sdk, String>(this.myJDKs, (Convertor)new Convertor<Sdk, String>(){

                public String convert(Sdk jdk) {
                    return jdk != null ? jdk.getName() : "";
                }
            }, String.CASE_INSENSITIVE_ORDER){

                @Override
                public Iterator<Sdk> getAllListItems() {
                    Application application = ApplicationManager.getApplication();
                    if (application == null) {
                        return Collections.singletonList(null).iterator();
                    }
                    ArrayList<Sdk> allJdks = new ArrayList<Sdk>(Arrays.asList(ProjectJdkTable.getInstance().getAllJdks()));
                    allJdks.add(0, null);
                    return allJdks.iterator();
                }

                @Override
                public Sdk openConfigureDialog(Sdk jdk, JComponent parent) {
                    ProjectJdksEditor editor = new ProjectJdksEditor(jdk, (Component)ExecutionTab.this.myJDKs.getComboBox());
                    editor.show();
                    return editor.getSelectedJdk();
                }
            };
            UIPropertyBinding.Composite binding = this.getBinding();
            binding.bindString(this.myAntCommandLine.getTextField(), (AbstractProperty<String>)AntBuildFileImpl.ANT_COMMAND_LINE_PARAMETERS);
            binding.bindString(this.myJDKs.getComboBox(), (AbstractProperty<String>)AntBuildFileImpl.CUSTOM_JDK_NAME);
            binding.addBinding(new RunWithAntBinding(this.myUseDefaultAnt, this.myUseCastomAnt, this.myAnts, this.myAntGlobalConfiguration));
            this.mySetDefaultAnt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AntSetPanel antSetPanel = new AntSetPanel(ExecutionTab.this.myAntGlobalConfiguration);
                    antSetPanel.reset();
                    antSetPanel.setSelection(ExecutionTab.this.myProjectDefaultAnt.find(ExecutionTab.this.myAntGlobalConfiguration));
                    AntInstallation antInstallation = antSetPanel.showDialog(ExecutionTab.this.mySetDefaultAnt);
                    if (antInstallation == null) {
                        return;
                    }
                    ExecutionTab.this.myProjectDefaultAnt = antInstallation.getReference();
                    ExecutionTab.this.updateDefaultAnt();
                }
            });
        }

        @Override
        public JComponent getComponent() {
            return this.myWholePanel;
        }

        @Override
        @Nullable
        public String getDisplayName() {
            return AntBundle.message("edit.ant.properties.execution.tab.display.name", new Object[0]);
        }

        @Override
        public void reset(AbstractProperty.AbstractPropertyContainer options) {
            String projectJdkName = (String)AntConfigurationImpl.DEFAULT_JDK_NAME.get(options);
            this.myJDKsController.setRenderer((ListCellRenderer)((Object)new AntUIUtil.ProjectJdkRenderer(true, projectJdkName)));
            super.reset(options);
            this.myJDKsController.resetList(null);
            this.myProjectDefaultAnt = (AntReference)AntConfigurationImpl.DEFAULT_ANT.get(options);
            this.updateDefaultAnt();
        }

        private void updateDefaultAnt() {
            this.myDefaultAnt.clear();
            AntUIUtil.customizeReference(this.myProjectDefaultAnt, this.myDefaultAnt, this.myAntGlobalConfiguration);
            this.myDefaultAnt.revalidate();
            this.myDefaultAnt.repaint();
        }

        @Override
        public void apply(AbstractProperty.AbstractPropertyContainer options) {
            AntConfigurationImpl.DEFAULT_ANT.set(options, (Object)this.myProjectDefaultAnt);
            super.apply(options);
        }

        @Override
        public JComponent getPreferedFocusComponent() {
            return this.myAntCommandLine.getTextField();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            ComboboxWithBrowseButton comboboxWithBrowseButton;
            JRadioButton jRadioButton;
            SimpleColoredComponent simpleColoredComponent;
            JButton jButton;
            JRadioButton jRadioButton2;
            JLabel jLabel;
            RawCommandLineEditor rawCommandLineEditor;
            ComboboxWithBrowseButton comboboxWithBrowseButton2;
            JLabel jLabel2;
            JPanel jPanel;
            this.myWholePanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(6, 6, 6, 6), -1, -1, false, false));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 3, 0, 3), -1, -1, false, false));
            jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myJDKLabel = jLabel2 = new JLabel();
            this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/AntBundle").getString("run.execution.tab.run.under.jdk.label"));
            jPanel2.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myJDKs = comboboxWithBrowseButton2 = new ComboboxWithBrowseButton();
            jPanel2.add((Component)comboboxWithBrowseButton2, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel2.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(10, 0, 10, 0), -1, 0, false, false));
            jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
            this.myAntCommandLine = rawCommandLineEditor = new RawCommandLineEditor();
            jPanel3.add((Component)rawCommandLineEditor, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
            this.myAntCmdLineLabel = jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/AntBundle").getString("run.execution.tab.ant.command.line.label"));
            jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            JBLabel jBLabel = new JBLabel();
            jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
            jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
            this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/AntBundle").getString("run.execution.tab.ant.command.line.hint"));
            jPanel3.add((Component)jBLabel, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null, 1));
            JLabel jLabel3 = new JLabel();
            this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/AntBundle").getString("run.execution.tab.run.with.ant.border"));
            jPanel2.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel2.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myUseDefaultAnt = jRadioButton2 = new JRadioButton();
            this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/AntBundle").getString("run.execution.tab.use.project.default.ant.radio"));
            jPanel4.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            JPanel jPanel5 = new JPanel();
            jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel4.add((Component)jPanel5, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
            this.mySetDefaultAnt = jButton = new JButton();
            this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/AntBundle").getString("run.execution.tab.set.default.button"));
            jPanel5.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 4, 0, 0, 0, null, null, null));
            this.myDefaultAnt = simpleColoredComponent = new SimpleColoredComponent();
            jPanel5.add((Component)simpleColoredComponent, new GridConstraints(0, 0, 1, 1, 8, 0, 2, 0, null, null, null));
            this.myUseCastomAnt = jRadioButton = new JRadioButton();
            this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/AntBundle").getString("run.execution.tab.use.custom.ant.radio"));
            jPanel4.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myAnts = comboboxWithBrowseButton = new ComboboxWithBrowseButton();
            jPanel4.add((Component)comboboxWithBrowseButton, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myWholePanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }

    private static class FiltersTab
    extends Tab {
        private JTable myFiltersTable;
        private JPanel myWholePanel;
        private static final int PREFERRED_CHECKBOX_COLUMN_WIDTH = new JCheckBox().getPreferredSize().width + 4;
        private static final ColumnInfo<TargetFilter, Boolean> CHECK_BOX_COLUMN = new ColumnInfo<TargetFilter, Boolean>(""){

            public Boolean valueOf(TargetFilter targetFilter) {
                return targetFilter.isVisible();
            }

            public void setValue(TargetFilter targetFilter, Boolean aBoolean) {
                targetFilter.setVisible(aBoolean);
            }

            public int getWidth(JTable table) {
                return PREFERRED_CHECKBOX_COLUMN_WIDTH;
            }

            public Class getColumnClass() {
                return Boolean.class;
            }

            public boolean isCellEditable(TargetFilter targetFilter) {
                return true;
            }
        };
        private static final Comparator<TargetFilter> NAME_COMPARATOR = new Comparator<TargetFilter>(){

            @Override
            public int compare(TargetFilter o1, TargetFilter o2) {
                String name1 = o1.getTargetName();
                if (name1 == null) {
                    return -1;
                }
                String name2 = o2.getTargetName();
                if (name2 == null) {
                    return 1;
                }
                return name1.compareToIgnoreCase(name2);
            }
        };
        private static final ColumnInfo<TargetFilter, String> NAME_COLUMN = new ColumnInfo<TargetFilter, String>(AntBundle.message("ant.target", new Object[0])){

            public String valueOf(TargetFilter targetFilter) {
                return targetFilter.getTargetName();
            }

            public Comparator<TargetFilter> getComparator() {
                return NAME_COMPARATOR;
            }
        };
        private static final Comparator<TargetFilter> DESCRIPTION_COMPARATOR = new Comparator<TargetFilter>(){

            @Override
            public int compare(TargetFilter o1, TargetFilter o2) {
                String description2;
                String description1 = o1.getDescription();
                if (description1 == null) {
                    description1 = "";
                }
                if ((description2 = o2.getDescription()) == null) {
                    description2 = "";
                }
                return description1.compareToIgnoreCase(description2);
            }
        };
        private static final ColumnInfo<TargetFilter, String> DESCRIPTION = new ColumnInfo<TargetFilter, String>(AntBundle.message("edit.ant.properties.description.column.name", new Object[0])){

            public String valueOf(TargetFilter targetFilter) {
                return targetFilter.getDescription();
            }

            public Comparator<TargetFilter> getComparator() {
                return DESCRIPTION_COMPARATOR;
            }
        };
        private static final ColumnInfo[] COLUMNS = new ColumnInfo[]{CHECK_BOX_COLUMN, NAME_COLUMN, DESCRIPTION};

        public FiltersTab() {
            this.$$$setupUI$$$();
            this.myFiltersTable.getTableHeader().setReorderingAllowed(false);
            UIPropertyBinding.TableListBinding<TargetFilter> tableListBinding = this.getBinding().bindList(this.myFiltersTable, COLUMNS, AntBuildFileImpl.TARGET_FILTERS);
            tableListBinding.setColumnWidths(GlobalAntConfiguration.FILTERS_TABLE_LAYOUT);
            tableListBinding.setSortable(true);
        }

        @Override
        public JComponent getComponent() {
            return this.myWholePanel;
        }

        @Override
        @Nullable
        public String getDisplayName() {
            return AntBundle.message("edit.ant.properties.filters.tab.display.name", new Object[0]);
        }

        @Override
        public JComponent getPreferedFocusComponent() {
            return this.myFiltersTable;
        }

        @Override
        public void reset(AbstractProperty.AbstractPropertyContainer options) {
            super.reset(options);
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JPanel jPanel;
            this.myWholePanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JBScrollPane jBScrollPane = new JBScrollPane();
            jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
            JBTable jBTable = new JBTable();
            this.myFiltersTable = jBTable;
            jBScrollPane.setViewportView((Component)jBTable);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myWholePanel;
        }
    }

    private static class PropertiesTab
    extends Tab {
        private JTable myPropertiesTable = new JBTable();
        private JPanel myWholePanel;
        private static final ColumnInfo<BuildFileProperty, String> NAME_COLUMN = new ColumnInfo<BuildFileProperty, String>(AntBundle.message("edit.ant.properties.name.column.name", new Object[0])){

            public String valueOf(BuildFileProperty buildFileProperty) {
                return buildFileProperty.getPropertyName();
            }

            public boolean isCellEditable(BuildFileProperty buildFileProperty) {
                return true;
            }

            public void setValue(BuildFileProperty buildFileProperty, String name) {
                buildFileProperty.setPropertyName(name);
            }
        };
        private static final ColumnInfo<BuildFileProperty, String> VALUE_COLUMN = new ColumnInfo<BuildFileProperty, String>(AntBundle.message("edit.ant.properties.value.column.name", new Object[0])){

            public boolean isCellEditable(BuildFileProperty buildFileProperty) {
                return true;
            }

            public String valueOf(BuildFileProperty buildFileProperty) {
                return buildFileProperty.getPropertyValue();
            }

            public void setValue(BuildFileProperty buildFileProperty, String value) {
                buildFileProperty.setPropertyValue(value);
            }

            public TableCellEditor getEditor(BuildFileProperty item) {
                return new AntUIUtil.PropertyValueCellEditor();
            }
        };
        private static final ColumnInfo[] PROPERTY_COLUMNS = new ColumnInfo[]{NAME_COLUMN, VALUE_COLUMN};

        public PropertiesTab() {
            UIPropertyBinding.TableListBinding<BuildFileProperty> tableListBinding = this.getBinding().bindList(this.myPropertiesTable, PROPERTY_COLUMNS, AntBuildFileImpl.ANT_PROPERTIES);
            tableListBinding.setColumnWidths(GlobalAntConfiguration.PROPERTIES_TABLE_LAYOUT);
            this.myWholePanel = ToolbarDecorator.createDecorator((JTable)this.myPropertiesTable).setAddAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    if (PropertiesTab.this.myPropertiesTable.isEditing() && !PropertiesTab.this.myPropertiesTable.getCellEditor().stopCellEditing()) {
                        return;
                    }
                    BuildFileProperty item = new BuildFileProperty();
                    ListTableModel model = (ListTableModel)PropertiesTab.this.myPropertiesTable.getModel();
                    ArrayList<BuildFileProperty> items = new ArrayList<BuildFileProperty>(model.getItems());
                    items.add(item);
                    model.setItems(items);
                    int newIndex = model.indexOf((Object)item);
                    ListSelectionModel selectionModel = PropertiesTab.this.myPropertiesTable.getSelectionModel();
                    selectionModel.clearSelection();
                    selectionModel.setSelectionInterval(newIndex, newIndex);
                    ColumnInfo[] columns = model.getColumnInfos();
                    for (int i = 0; i < columns.length; ++i) {
                        ColumnInfo column = columns[i];
                        if (!column.isCellEditable((Object)item)) continue;
                        PropertiesTab.this.myPropertiesTable.requestFocusInWindow();
                        PropertiesTab.this.myPropertiesTable.editCellAt(newIndex, i);
                        break;
                    }
                }
            }).disableUpDownActions().createPanel();
            this.myWholePanel.setBorder(null);
        }

        @Override
        public JComponent getComponent() {
            return this.myWholePanel;
        }

        @Override
        @Nullable
        public String getDisplayName() {
            return AntBundle.message("edit.ant.properties.tab.display.name", new Object[0]);
        }

        @Override
        public JComponent getPreferedFocusComponent() {
            return this.myPropertiesTable;
        }
    }

    private static class Form
    implements Disposable {
        private JLabel myBuildFileName;
        private JTextField myXmx;
        private JTextField myXss;
        private JCheckBox myRunInBackground;
        private JCheckBox myCloseOnNoError;
        private JPanel myTabsPlace;
        private JPanel myWholePanel;
        private JLabel myHeapSizeLabel;
        private final Tab[] myTabs;
        private final UIPropertyBinding.Composite myBinding;
        private final TabbedPaneWrapper myWrapper;

        private Form(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/ant/config/impl/configuration/BuildFilePropertiesPanel$Form", "<init>"));
            }
            this.$$$setupUI$$$();
            this.myBinding = new UIPropertyBinding.Composite();
            this.myTabs = new Tab[]{new PropertiesTab(), new ExecutionTab(GlobalAntConfiguration.getInstance(), project), new AdditionalClasspathTab(), new FiltersTab()};
            this.myHeapSizeLabel.setLabelFor(this.myXmx);
            this.myWrapper = new TabbedPaneWrapper((Disposable)this);
            this.myTabsPlace.setLayout(new BorderLayout());
            this.myTabsPlace.add((Component)this.myWrapper.getComponent(), "Center");
            this.myBinding.bindBoolean(this.myRunInBackground, (AbstractProperty<Boolean>)AntBuildFileImpl.RUN_IN_BACKGROUND);
            this.myBinding.bindBoolean(this.myCloseOnNoError, (AbstractProperty<Boolean>)AntBuildFileImpl.CLOSE_ON_NO_ERRORS);
            this.myBinding.bindInt(this.myXmx, (AbstractProperty<Integer>)AntBuildFileImpl.MAX_HEAP_SIZE);
            this.myBinding.bindInt(this.myXss, (AbstractProperty<Integer>)AntBuildFileImpl.MAX_STACK_SIZE);
            for (Tab tab : this.myTabs) {
                this.myWrapper.addTab(tab.getDisplayName(), tab.getComponent());
            }
        }

        public JComponent getComponent() {
            return this.myWholePanel;
        }

        public JComponent getPreferedFocusComponent() {
            return this.myTabs[0].getPreferedFocusComponent();
        }

        public void reset(AntBuildFileBase buildFile) {
            this.myBinding.loadValues(buildFile.getAllOptions());
            this.myBuildFileName.setText(buildFile.getPresentableUrl());
            for (Tab tab : this.myTabs) {
                tab.reset(buildFile.getAllOptions());
            }
        }

        public void apply(AntBuildFileBase buildFile) {
            this.myBinding.apply(buildFile.getAllOptions());
            for (Tab tab : this.myTabs) {
                tab.apply(buildFile.getAllOptions());
            }
        }

        public void beforeClose(AntBuildFileBase buildFile) {
            this.myBinding.beforeClose(buildFile.getAllOptions());
            for (Tab tab : this.myTabs) {
                tab.beforeClose(buildFile.getAllOptions());
            }
        }

        public void dispose() {
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JTextField jTextField;
            JTextField jTextField2;
            JCheckBox jCheckBox;
            JLabel jLabel;
            JPanel jPanel;
            JCheckBox jCheckBox2;
            JLabel jLabel2;
            JPanel jPanel2;
            this.myWholePanel = jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myBuildFileName = jLabel2 = new JLabel();
            jLabel2.setText("<######## ## ####> ");
            jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 4, 0, 1, 2, 0, null, null, null));
            this.myRunInBackground = jCheckBox2 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/AntBundle").getString("build.file.properties.make.in.background.cjeclbox"));
            jPanel2.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
            this.myTabsPlace = jPanel = new JPanel();
            jPanel2.add((Component)jPanel, new GridConstraints(3, 0, 1, 4, 0, 3, 3, 3, null, null, null));
            this.myHeapSizeLabel = jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/AntBundle").getString("build.file.properties.maximum.heap.size.label"));
            jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myCloseOnNoError = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/AntBundle").getString("build.file.properties.close.message.view.checkbox"));
            jCheckBox.setToolTipText("");
            jPanel2.add((Component)jCheckBox, new GridConstraints(2, 2, 1, 2, 8, 0, 5, 0, null, null, null));
            this.myXmx = jTextField2 = new JTextField();
            jTextField2.setColumns(4);
            jPanel2.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
            JLabel jLabel3 = new JLabel();
            this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/AntBundle").getString("build.file.properties.maximum.stack.size.label"));
            jPanel2.add((Component)jLabel3, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myXss = jTextField = new JTextField();
            jTextField.setColumns(4);
            jPanel2.add((Component)jTextField, new GridConstraints(1, 3, 1, 1, 8, 0, 4, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myWholePanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }

    static abstract class Tab {
        private final UIPropertyBinding.Composite myBinding = new UIPropertyBinding.Composite();

        Tab() {
        }

        public abstract JComponent getComponent();

        public abstract String getDisplayName();

        public UIPropertyBinding.Composite getBinding() {
            return this.myBinding;
        }

        public void reset(AbstractProperty.AbstractPropertyContainer options) {
            this.myBinding.loadValues(options);
        }

        public void apply(AbstractProperty.AbstractPropertyContainer options) {
            this.myBinding.apply(options);
        }

        public void beforeClose(AbstractProperty.AbstractPropertyContainer options) {
            this.myBinding.beforeClose(options);
        }

        public abstract JComponent getPreferedFocusComponent();
    }
}

