/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.vmtrace;

import com.android.annotations.Nullable;
import com.android.tools.perflib.vmtrace.Call;
import com.android.tools.perflib.vmtrace.TraceAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class CallStackReconstructor {
    private final long mTopLevelCallId;
    private final List<Call.Builder> mTopLevelCalls = new ArrayList<Call.Builder>();
    private final Stack<Call.Builder> mCallStack = new Stack();
    private Call mTopLevelCall;

    public CallStackReconstructor(long topLevelCallId) {
        this.mTopLevelCallId = topLevelCallId;
    }

    public void addTraceAction(long methodId, TraceAction action, int threadTime, int globalTime) {
        if (action == TraceAction.METHOD_ENTER) {
            this.enterMethod(methodId, threadTime, globalTime);
        } else {
            this.exitMethod(methodId, threadTime, globalTime);
        }
    }

    private void enterMethod(long methodId, int threadTime, int globalTime) {
        Call.Builder cb = new Call.Builder(methodId);
        cb.setMethodEntryTime(threadTime, globalTime);
        if (this.mCallStack.isEmpty()) {
            this.mTopLevelCalls.add(cb);
        } else {
            Call.Builder caller = this.mCallStack.peek();
            caller.addCallee(cb);
        }
        this.mCallStack.push(cb);
    }

    private void exitMethod(long methodId, int threadTime, int globalTime) {
        if (!this.mCallStack.isEmpty()) {
            Call.Builder c = this.mCallStack.pop();
            if (c.getMethodId() != methodId) {
                String msg = String.format("Error during call stack reconstruction. Attempt to exit from method 0x%1$x while in method 0x%2$x", c.getMethodId(), methodId);
                throw new RuntimeException(msg);
            }
            c.setMethodExitTime(threadTime, globalTime);
        } else {
            Call.Builder c = new Call.Builder(methodId);
            for (Call.Builder cb : this.mTopLevelCalls) {
                c.addCallee(cb);
            }
            this.mTopLevelCalls.clear();
            this.mTopLevelCalls.add(c);
            c.setMethodExitTime(threadTime, globalTime);
            int entryThreadTime = threadTime - 1;
            int entryGlobalTime = globalTime - 1;
            if (c.getCallees() != null && !c.getCallees().isEmpty()) {
                Call.Builder callee = c.getCallees().get(0);
                entryThreadTime = Math.max(callee.getMethodEntryThreadTime() - 1, 0);
                entryGlobalTime = Math.max(callee.getMethodEntryGlobalTime() - 1, 0);
            }
            c.setMethodEntryTime(entryThreadTime, entryGlobalTime);
        }
    }

    private void exitMethod(long methoId, int entryThreadTime, int entryGlobalTime, @Nullable List<Call.Builder> callees) {
        int lastExitGlobalTime;
        int lastExitThreadTime;
        if (callees == null || callees.isEmpty()) {
            lastExitThreadTime = entryThreadTime + 1;
            lastExitGlobalTime = entryGlobalTime + 1;
        } else {
            Call.Builder last = callees.get(callees.size() - 1);
            lastExitThreadTime = last.getMethodExitThreadTime() + 1;
            lastExitGlobalTime = last.getMethodExitGlobalTime() + 1;
        }
        this.exitMethod(methoId, lastExitThreadTime, lastExitGlobalTime);
    }

    private void fixupCallStacks() {
        if (this.mTopLevelCall != null) {
            return;
        }
        while (!this.mCallStack.isEmpty()) {
            Call.Builder cb = this.mCallStack.peek();
            this.exitMethod(cb.getMethodId(), cb.getMethodEntryThreadTime(), cb.getMethodEntryGlobalTime(), cb.getCallees());
        }
        this.exitMethod(this.mTopLevelCallId, 0, 0, this.mTopLevelCalls);
        assert (this.mTopLevelCalls.size() == 1);
        this.mTopLevelCall = this.mTopLevelCalls.get(0).build(new Stack<Long>());
    }

    public Call getTopLevel() {
        this.fixupCallStacks();
        return this.mTopLevelCall;
    }
}

