/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.local;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.io.FileOp;
import com.android.sdklib.repository.IDescription;
import com.android.sdklib.repository.IListDescription;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.local.LocalSdk;
import java.io.File;
import java.util.Properties;

public abstract class LocalPkgInfo
implements IDescription,
IListDescription,
Comparable<LocalPkgInfo> {
    private final LocalSdk mLocalSdk;
    private final File mLocalDir;
    private final Properties mSourceProperties;
    private String mLoadError;

    protected LocalPkgInfo(@NonNull LocalSdk localSdk, @NonNull File localDir, @NonNull Properties sourceProps) {
        this.mLocalSdk = localSdk;
        this.mLocalDir = localDir;
        this.mSourceProperties = sourceProps;
    }

    @NonNull
    public LocalSdk getLocalSdk() {
        return this.mLocalSdk;
    }

    @NonNull
    public File getLocalDir() {
        return this.mLocalDir;
    }

    @NonNull
    public Properties getSourceProperties() {
        return this.mSourceProperties;
    }

    @Nullable
    public String getLoadError() {
        return this.mLoadError;
    }

    @NonNull
    public abstract IPkgDesc getDesc();

    @Override
    public int compareTo(@NonNull LocalPkgInfo o) {
        return this.getDesc().compareTo(o.getDesc());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('<').append(this.getClass().getSimpleName()).append(' ');
        builder.append(this.getDesc().toString());
        builder.append('>');
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getDesc() == null ? 0 : this.getDesc().hashCode());
        result = 31 * result + (this.mLocalDir == null ? 0 : this.mLocalDir.hashCode());
        result = 31 * result + (this.mSourceProperties == null ? 0 : this.mSourceProperties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocalPkgInfo)) {
            return false;
        }
        LocalPkgInfo other = (LocalPkgInfo)obj;
        if (!this.getDesc().equals(other.getDesc())) {
            return false;
        }
        if (this.mLocalDir == null ? other.mLocalDir != null : !this.mLocalDir.equals(other.mLocalDir)) {
            return false;
        }
        return !(this.mSourceProperties == null ? other.mSourceProperties != null : !this.mSourceProperties.equals(other.mSourceProperties));
    }

    public boolean hasLoadError() {
        return this.mLoadError != null;
    }

    void appendLoadError(@NonNull String format, Object ... params) {
        String loadError = String.format(format, params);
        this.mLoadError = this.mLoadError == null ? loadError : this.mLoadError + '\n' + loadError;
    }

    @Override
    @NonNull
    public String getListDescription() {
        return this.getDesc().getListDescription();
    }

    @Override
    public String getShortDescription() {
        return this.getListDescription();
    }

    @Override
    public String getLongDescription() {
        StringBuilder sb = new StringBuilder();
        IPkgDesc desc = this.getDesc();
        sb.append(desc.getListDescription()).append('\n');
        if (desc.hasVendor()) {
            assert (desc.getVendor() != null);
            sb.append("By ").append(desc.getVendor().getDisplay()).append('\n');
        }
        if (desc.hasMinPlatformToolsRev()) {
            assert (desc.getMinPlatformToolsRev() != null);
            sb.append("Requires Platform-Tools revision ").append(desc.getMinPlatformToolsRev().toShortString()).append('\n');
        }
        if (desc.hasMinToolsRev()) {
            assert (desc.getMinToolsRev() != null);
            sb.append("Requires Tools revision ").append(desc.getMinToolsRev().toShortString()).append('\n');
        }
        sb.append("Location: ").append(this.mLocalDir.getAbsolutePath());
        return sb.toString();
    }

    public void delete() {
        new FileOp().deleteFileOrFolder(this.getLocalDir());
    }
}

