/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.runner;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import kotlin.collections.CollectionsKt;
import kotlin.io.ConsoleKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.runner.Classpath;
import org.jetbrains.kotlin.runner.ExpressionRunner;
import org.jetbrains.kotlin.runner.JarRunner;
import org.jetbrains.kotlin.runner.MainClassRunner;
import org.jetbrains.kotlin.runner.ReplRunner;
import org.jetbrains.kotlin.runner.Runner;
import org.jetbrains.kotlin.runner.RunnerException;
import org.jetbrains.kotlin.runner.ScriptRunner;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"%\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u0005)\u0001!B\u0001\t\u0012\u0015\t\u0001bB\u0003\u0002\t\t!1-\u0001\u0007\u00013\u0005A\n!i\u0002\u0005\u0003E\u001b\u0011\u0001C\u0001&\u001c\u0011\u001d\u0001RA\u0007\u00021\rIb\u0001c\u0002\u000e\t%\u0011\u0011\"\u0001M\u00051\u0011\t6!\u0001\u0005\u0006K\u0011!\u0011\u0001c\u0003\u000e\u0003a\u0019Q\u0005\u0002\u0003\u0002\u0011\u0019i\u0011\u0001G\u0002&\u001c\u0011\t\u0001RB\u0007\u00021\rIb\u0001c\u0002\u000e\t%\u0011\u0011\"\u0001M\u00051\u0011\t6!\u0001\u0005\u0006S\u001d!\u0011\t\u0003E\u0002\u001b\u0005A\"!U\u0002\u0002\u000b\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/runner/Main;", "", "()V", "KOTLIN_HOME", "Ljava/io/File;", "main", "", "args", "", "", "([Ljava/lang/String;)V", "printUsageAndExit", "printVersionAndExit", "run"}, moduleName="runner")
public final class Main {
    private static final File KOTLIN_HOME;
    public static final Main INSTANCE;
    public static final Main INSTANCE$;

    /*
     * WARNING - void declaration
     */
    private final void run(String[] args) {
        Object i;
        Classpath classpath = new Classpath();
        Runner runner = null;
        boolean collectingArguments = false;
        ArrayList<String> arguments = CollectionsKt.arrayListOf(new String[0]);
        classpath.add(".");
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        while (true) {
            void $receiver$iv;
            Object[] objectArray = args;
            int n = i.element;
            int n2 = ((void)$receiver$iv).length;
            if (n >= n2) break;
            String arg = args[i.element];
            if (collectingArguments) {
                arguments.add(arg);
                int n3 = i.element++;
                continue;
            }
            Function0<String> next$ = new Function0<String>((Ref.IntRef)i, args, arg){
                final /* synthetic */ Ref.IntRef $i;
                final /* synthetic */ String[] $args;
                final /* synthetic */ String $arg;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final String invoke() {
                    void $receiver$iv;
                    Ref.IntRef intRef = this.$i;
                    ++intRef.element;
                    Object[] objectArray = this.$args;
                    int n = intRef.element;
                    int n2 = ((void)$receiver$iv).length;
                    if (n == n2) {
                        throw (Throwable)new RunnerException("argument expected to " + this.$arg);
                    }
                    return this.$args[this.$i.element];
                }
                {
                    this.$i = intRef;
                    this.$args = stringArray;
                    this.$arg = string;
                    super(0);
                }
            };
            if (Intrinsics.areEqual("-help", arg) || Intrinsics.areEqual("-h", arg)) {
                this.printUsageAndExit();
            } else if (Intrinsics.areEqual("-version", arg)) {
                this.printVersionAndExit();
            } else if (Intrinsics.areEqual("-classpath", arg) || Intrinsics.areEqual("-cp", arg)) {
                classpath.add((String)next$.invoke());
            } else if (Intrinsics.areEqual("-expression", arg) || Intrinsics.areEqual("-e", arg)) {
                runner = new ExpressionRunner((String)next$.invoke());
                collectingArguments = true;
            } else {
                if (StringsKt.startsWith$default(arg, "-", false, 2)) {
                    throw (Throwable)new RunnerException("unsupported argument: " + arg);
                }
                if (StringsKt.endsWith$default(arg, ".jar", false, 2)) {
                    runner = new JarRunner(arg);
                    collectingArguments = true;
                } else if (StringsKt.endsWith$default(arg, ".kts", false, 2)) {
                    runner = new ScriptRunner(arg);
                    collectingArguments = true;
                } else {
                    runner = new MainClassRunner(arg);
                    collectingArguments = true;
                }
            }
            int n4 = i.element++;
        }
        classpath.add(KOTLIN_HOME.toString() + "/lib/kotlin-runtime.jar");
        classpath.add(KOTLIN_HOME.toString() + "/lib/kotlin-reflect.jar");
        if (runner == null) {
            runner = new ReplRunner();
        }
        runner.run(classpath, (List<String>)arguments);
        i = null;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkParameterIsNotNull(args, "args");
        try {
            INSTANCE.run(args);
        }
        catch (RunnerException e) {
            void $receiver$iv;
            Throwable throwable = e;
            StringBuilder stringBuilder = new StringBuilder().append("error: ");
            PrintStream printStream = System.err;
            String string = $receiver$iv.getMessage();
            printStream.println(stringBuilder.append(string).toString());
            System.exit(1);
        }
    }

    private final void printUsageAndExit() {
        ConsoleKt.println("kotlin: run Kotlin programs, scripts or REPL.\n\nUsage: kotlin <options> <command> <arguments>\nwhere command may be one of:\n  foo.Bar                    Runs the 'main' function from the class with the given qualified name\n  app.jar                    Runs the given JAR file as 'java -jar' would do\n                             (-classpath argument is ignored and no Kotlin runtime is added to the classpath)\n" + "and possible options include:\n  -classpath (-cp) <path>    Paths where to find user class files\n  -Dname=value               Set a system JVM property\n  -J<option>                 Pass an option directly to JVM\n  -version                   Display Kotlin version\n  -help (-h)                 Print a synopsis of options\n");
        System.exit(0);
    }

    private final void printVersionAndExit() {
        String string;
        try {
            string = new Scanner(new File(KOTLIN_HOME, "build.txt")).nextLine();
        }
        catch (FileNotFoundException e) {
            throw (Throwable)new RunnerException("no build.txt was found at home=" + KOTLIN_HOME);
        }
        String version = string;
        ConsoleKt.println("Kotlin version " + version + " (JRE " + System.getProperty("java.runtime.version") + ")");
        System.exit(0);
    }

    private Main() {
        INSTANCE = this;
        INSTANCE$ = this;
        String home = System.getProperty("kotlin.home");
        if (home == null) {
            System.err.println("error: no kotlin.home system property was passed");
            System.exit(1);
        }
        KOTLIN_HOME = new File(home);
    }

    static {
        new Main();
    }
}

