/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.registry.BindingPredicate;
import org.gradle.model.internal.registry.ModelBinding;
import org.gradle.model.internal.registry.ModelGraph;
import org.gradle.model.internal.registry.ModelNodeInternal;
import org.gradle.model.internal.registry.NodeAtState;
import org.gradle.model.internal.registry.RuleBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RuleBindings {
    private final ModelGraph modelGraph;
    private final NodeIndex rulesBySubject;
    private final NodeIndex rulesByInput;
    private final Multimap<ModelPath, Reference> pathReferences = ArrayListMultimap.create();
    private final Multimap<ModelPath, Reference> scopeReferences = ArrayListMultimap.create();

    public RuleBindings(ModelGraph graph) {
        this.modelGraph = graph;
        this.rulesBySubject = new NodeIndex();
        this.rulesByInput = new NodeIndex();
    }

    public void add(ModelNodeInternal node) {
        Collection references = this.pathReferences.get((Object)node.getPath());
        for (Reference reference : references) {
            this.bound(reference, node);
        }
        references = this.scopeReferences.get((Object)node.getPath());
        this.addTypeMatches(node, references);
        references = this.scopeReferences.get((Object)node.getPath().getParent());
        this.addTypeMatches(node, references);
    }

    private void addTypeMatches(ModelNodeInternal node, Collection<Reference> references) {
        for (Reference reference : references) {
            if (!reference.binding.isTypeCompatible(node.getPromise())) continue;
            this.bound(reference, node);
        }
    }

    private void bound(Reference reference, ModelNodeInternal node) {
        ModelBinding binding = reference.binding;
        binding.onCreate(node);
        if (binding.predicate.getState() != null) {
            reference.index.boundAtState.put((Object)new NodeAtState(node.getPath(), binding.predicate.getState()), (Object)reference.owner);
        } else {
            reference.index.boundNoState.put((Object)node.getPath(), (Object)reference.owner);
        }
    }

    public void remove(ModelNodeInternal node) {
        this.rulesBySubject.nodeRemoved(node);
        this.rulesByInput.nodeRemoved(node);
    }

    public void add(RuleBinder ruleBinder) {
        this.addRule(ruleBinder, this.rulesBySubject, this.subject(ruleBinder));
        for (ModelBinding binding : ruleBinder.getInputBindings()) {
            this.addRule(ruleBinder, this.rulesByInput, binding);
        }
    }

    private void addRule(RuleBinder rule, NodeIndex index, ModelBinding binding) {
        Reference reference = new Reference(rule, index, binding);
        BindingPredicate predicate = binding.getPredicate();
        if (predicate.getPath() != null) {
            if (predicate.getScope() != null) {
                throw new UnsupportedOperationException("Currently not implemented");
            }
            ModelNodeInternal node = this.modelGraph.find(predicate.getPath());
            if (node != null) {
                this.bound(reference, node);
            }
            this.pathReferences.put((Object)predicate.getPath(), (Object)reference);
        } else if (predicate.getScope() != null) {
            for (ModelNodeInternal node : this.modelGraph.findAllInScope(predicate.getScope())) {
                if (!binding.isTypeCompatible(node.getPromise())) continue;
                this.bound(reference, node);
            }
            this.scopeReferences.put((Object)predicate.getScope(), (Object)reference);
        } else {
            throw new UnsupportedOperationException("Currently not implemented");
        }
    }

    private ModelBinding subject(RuleBinder ruleBinder) {
        if (ruleBinder.getSubjectBinding() != null) {
            return ruleBinder.getSubjectBinding();
        }
        return new ModelBinding(ruleBinder.getDescriptor(), ruleBinder.getSubjectReference(), true){

            public void onCreate(ModelNodeInternal node) {
            }
        };
    }

    public Collection<RuleBinder> getRulesWithSubject(NodeAtState target) {
        return this.rulesBySubject.get(target);
    }

    public Collection<RuleBinder> getRulesWithSubject(ModelPath target) {
        return this.rulesBySubject.get(target);
    }

    public Collection<RuleBinder> getRulesWithInput(NodeAtState input) {
        return this.rulesByInput.get(input);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeIndex {
        private final Multimap<NodeAtState, RuleBinder> boundAtState = LinkedHashMultimap.create();
        private final Multimap<ModelPath, RuleBinder> boundNoState = LinkedHashMultimap.create();

        private NodeIndex() {
        }

        public void nodeRemoved(ModelNodeInternal node) {
            for (ModelNode.State state : ModelNode.State.values()) {
                for (RuleBinder rule : this.boundAtState.removeAll((Object)new NodeAtState(node.getPath(), state))) {
                    if (rule.getSubjectBinding() != null) {
                        rule.getSubjectBinding().onRemove(node);
                    }
                    for (ModelBinding binding : rule.getInputBindings()) {
                        binding.onRemove(node);
                    }
                }
            }
        }

        public Collection<RuleBinder> get(ModelPath path) {
            Collection result = this.boundNoState.get((Object)path);
            return result == null ? Collections.emptyList() : result;
        }

        public Collection<RuleBinder> get(NodeAtState nodeAtState) {
            Collection result = this.boundAtState.get((Object)nodeAtState);
            return result == null ? Collections.emptyList() : result;
        }
    }

    private static class Reference {
        final ModelBinding binding;
        final NodeIndex index;
        final RuleBinder owner;

        public Reference(RuleBinder owner, NodeIndex index, ModelBinding binding) {
            this.owner = owner;
            this.index = index;
            this.binding = binding;
        }
    }
}

