/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gradle.internal.reflect.ClassDetails;
import org.gradle.internal.reflect.ClassInspector;
import org.gradle.internal.reflect.PropertyDetails;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.manage.instance.ManagedInstance;
import org.gradle.model.internal.manage.instance.ModelElementState;
import org.gradle.model.internal.manage.schema.extract.AbstractProxyClassGenerator;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedProxyClassGenerator
extends AbstractProxyClassGenerator {
    private static final String STATE_FIELD_NAME = "$state";
    private static final String CAN_CALL_SETTERS_FIELD_NAME = "$canCallSetters";
    private static final String STATE_SET_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class), Type.getType(Object.class)});
    private static final String MANAGED_INSTANCE_TYPE = Type.getInternalName(ManagedInstance.class);
    private static final Type MODEL_ELEMENT_STATE_TYPE = Type.getType(ModelElementState.class);
    private static final String CONSTRUCTOR_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{MODEL_ELEMENT_STATE_TYPE});
    private static final String TO_STRING_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.getType(String.class), (Type[])new Type[0]);
    private static final String GET_BACKING_NODE_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.getType(MutableModelNode.class), (Type[])new Type[0]);
    private static final String GET_PROPERTY_MISSING_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(String.class)});
    private static final String MISSING_PROPERTY_EXCEPTION_TYPE = Type.getInternalName(MissingPropertyException.class);
    private static final String CLASS_TYPE = Type.getInternalName(Class.class);
    private static final String FOR_NAME_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.getType(Class.class), (Type[])new Type[]{Type.getType(String.class)});
    private static final String OBJECT_ARRAY_TYPE = Type.getInternalName(Object[].class);
    private static final String MISSING_METHOD_EXCEPTION_TYPE = Type.getInternalName(MissingMethodException.class);
    private static final String MISSING_PROPERTY_CONSTRUCTOR_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class), Type.getType(Class.class)});
    private static final String METHOD_MISSING_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(String.class), Type.getType(Object.class)});
    private static final String SET_PROPERTY_MISSING_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(String.class), Type.getType(Object.class)});
    private static final String MISSING_METHOD_EXCEPTION_CONSTRUCTOR_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class), Type.getType(Class.class), Type.getType(Object[].class)});

    public <T> Class<? extends T> generate(Class<T> managedTypeClass) {
        ImmutableList interfaceInternalNames;
        Class superclass;
        ClassWriter visitor = new ClassWriter(3);
        String generatedTypeName = managedTypeClass.getName() + "_Impl";
        Type generatedType = Type.getType((String)("L" + generatedTypeName.replaceAll("\\.", "/") + ";"));
        if (managedTypeClass.isInterface()) {
            superclass = Object.class;
            interfaceInternalNames = ImmutableList.of((Object)Type.getInternalName(managedTypeClass), (Object)MANAGED_INSTANCE_TYPE);
        } else {
            superclass = managedTypeClass;
            interfaceInternalNames = ImmutableList.of((Object)MANAGED_INSTANCE_TYPE);
        }
        this.generateProxyClass(visitor, managedTypeClass, (List<String>)interfaceInternalNames, generatedType, Type.getType(superclass));
        return this.defineClass(visitor, managedTypeClass.getClassLoader(), generatedTypeName);
    }

    private void generateProxyClass(ClassWriter visitor, Class<?> managedTypeClass, List<String> interfaceInternalNames, Type generatedType, Type superclassType) {
        this.declareClass((ClassVisitor)visitor, interfaceInternalNames, generatedType, superclassType);
        this.declareStateField((ClassVisitor)visitor);
        this.declareCanCallSettersField((ClassVisitor)visitor);
        this.writeConstructor((ClassVisitor)visitor, generatedType, superclassType);
        this.writeToString((ClassVisitor)visitor, generatedType, managedTypeClass);
        this.writeManagedInstanceMethods((ClassVisitor)visitor, generatedType);
        this.writeGroovyMethods((ClassVisitor)visitor, managedTypeClass);
        this.writeMutationMethods((ClassVisitor)visitor, generatedType, managedTypeClass);
        visitor.visitEnd();
    }

    private void declareClass(ClassVisitor visitor, List<String> interfaceInternalNames, Type generatedType, Type superclassType) {
        visitor.visit(50, 1, generatedType.getInternalName(), null, superclassType.getInternalName(), (String[])Iterables.toArray(interfaceInternalNames, String.class));
    }

    private void declareStateField(ClassVisitor visitor) {
        this.declareField(visitor, STATE_FIELD_NAME, ModelElementState.class);
    }

    private void declareCanCallSettersField(ClassVisitor visitor) {
        this.declareField(visitor, CAN_CALL_SETTERS_FIELD_NAME, Boolean.TYPE);
    }

    private void declareField(ClassVisitor visitor, String name, Class<?> fieldClass) {
        visitor.visitField(2, name, Type.getDescriptor(fieldClass), null, null);
    }

    private void writeConstructor(ClassVisitor visitor, Type generatedType, Type superclassType) {
        MethodVisitor constructorVisitor = visitor.visitMethod(1, "<init>", CONSTRUCTOR_DESCRIPTOR, CONCRETE_SIGNATURE, NO_EXCEPTIONS);
        constructorVisitor.visitCode();
        this.invokeSuperConstructor(constructorVisitor, superclassType);
        this.assignStateField(constructorVisitor, generatedType);
        this.setCanCallSettersField(constructorVisitor, generatedType, true);
        this.finishVisitingMethod(constructorVisitor);
    }

    private void invokeSuperConstructor(MethodVisitor constructorVisitor, Type superclassType) {
        this.putThisOnStack(constructorVisitor);
        constructorVisitor.visitMethodInsn(183, superclassType.getInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
    }

    private void writeToString(ClassVisitor visitor, Type generatedType, Class<?> managedTypeClass) {
        Method toStringMethod = this.getToStringMethod(managedTypeClass);
        if (toStringMethod == null || toStringMethod.getDeclaringClass().equals(Object.class)) {
            this.writeDefaultToString(visitor, generatedType);
        } else {
            this.writeNonAbstractMethodWrapper(visitor, generatedType, managedTypeClass, toStringMethod);
        }
    }

    private void writeDefaultToString(ClassVisitor visitor, Type generatedType) {
        MethodVisitor methodVisitor = visitor.visitMethod(1, "toString", TO_STRING_METHOD_DESCRIPTOR, CONCRETE_SIGNATURE, NO_EXCEPTIONS);
        methodVisitor.visitCode();
        this.putStateFieldValueOnStack(methodVisitor, generatedType);
        methodVisitor.visitMethodInsn(185, MODEL_ELEMENT_STATE_TYPE.getInternalName(), "getDisplayName", TO_STRING_METHOD_DESCRIPTOR, true);
        this.finishVisitingMethod(methodVisitor, 176);
    }

    private Method getToStringMethod(Class<?> managedTypeClass) {
        try {
            return managedTypeClass.getMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private void writeGroovyMethods(ClassVisitor visitor, Class<?> managedTypeClass) {
        MethodVisitor methodVisitor = visitor.visitMethod(1, "propertyMissing", GET_PROPERTY_MISSING_METHOD_DESCRIPTOR, CONCRETE_SIGNATURE, NO_EXCEPTIONS);
        methodVisitor.visitCode();
        methodVisitor.visitTypeInsn(187, MISSING_PROPERTY_EXCEPTION_TYPE);
        methodVisitor.visitInsn(89);
        this.putFirstMethodArgumentOnStack(methodVisitor);
        this.putClassOnStack(methodVisitor, managedTypeClass);
        methodVisitor.visitMethodInsn(183, MISSING_PROPERTY_EXCEPTION_TYPE, "<init>", MISSING_PROPERTY_CONSTRUCTOR_DESCRIPTOR, false);
        this.finishVisitingMethod(methodVisitor, 191);
        methodVisitor = visitor.visitMethod(1, "propertyMissing", SET_PROPERTY_MISSING_METHOD_DESCRIPTOR, CONCRETE_SIGNATURE, NO_EXCEPTIONS);
        methodVisitor.visitCode();
        methodVisitor.visitTypeInsn(187, MISSING_PROPERTY_EXCEPTION_TYPE);
        methodVisitor.visitInsn(89);
        this.putFirstMethodArgumentOnStack(methodVisitor);
        this.putClassOnStack(methodVisitor, managedTypeClass);
        methodVisitor.visitMethodInsn(183, MISSING_PROPERTY_EXCEPTION_TYPE, "<init>", MISSING_PROPERTY_CONSTRUCTOR_DESCRIPTOR, false);
        this.finishVisitingMethod(methodVisitor, 191);
        methodVisitor = visitor.visitMethod(1, "methodMissing", METHOD_MISSING_METHOD_DESCRIPTOR, CONCRETE_SIGNATURE, NO_EXCEPTIONS);
        methodVisitor.visitCode();
        methodVisitor.visitTypeInsn(187, MISSING_METHOD_EXCEPTION_TYPE);
        methodVisitor.visitInsn(89);
        this.putMethodArgumentOnStack(methodVisitor, 1);
        this.putClassOnStack(methodVisitor, managedTypeClass);
        this.putMethodArgumentOnStack(methodVisitor, 2);
        methodVisitor.visitTypeInsn(192, OBJECT_ARRAY_TYPE);
        methodVisitor.visitMethodInsn(183, MISSING_METHOD_EXCEPTION_TYPE, "<init>", MISSING_METHOD_EXCEPTION_CONSTRUCTOR_DESCRIPTOR, false);
        this.finishVisitingMethod(methodVisitor, 191);
    }

    private void putClassOnStack(MethodVisitor methodVisitor, Class<?> managedTypeClass) {
        this.putConstantOnStack(methodVisitor, managedTypeClass.getName());
        methodVisitor.visitMethodInsn(184, CLASS_TYPE, "forName", FOR_NAME_METHOD_DESCRIPTOR, false);
    }

    private void writeManagedInstanceMethods(ClassVisitor visitor, Type generatedType) {
        MethodVisitor methodVisitor = visitor.visitMethod(1, "getBackingNode", GET_BACKING_NODE_METHOD_DESCRIPTOR, CONCRETE_SIGNATURE, NO_EXCEPTIONS);
        methodVisitor.visitCode();
        this.putStateFieldValueOnStack(methodVisitor, generatedType);
        methodVisitor.visitMethodInsn(185, MODEL_ELEMENT_STATE_TYPE.getInternalName(), "getBackingNode", GET_BACKING_NODE_METHOD_DESCRIPTOR, true);
        this.finishVisitingMethod(methodVisitor, 176);
    }

    private void assignStateField(MethodVisitor constructorVisitor, Type generatedType) {
        this.putThisOnStack(constructorVisitor);
        this.putFirstMethodArgumentOnStack(constructorVisitor);
        constructorVisitor.visitFieldInsn(181, generatedType.getInternalName(), STATE_FIELD_NAME, MODEL_ELEMENT_STATE_TYPE.getDescriptor());
    }

    private void setCanCallSettersField(MethodVisitor methodVisitor, Type generatedType, boolean canCallSetters) {
        this.putThisOnStack(methodVisitor);
        methodVisitor.visitLdcInsn((Object)canCallSetters);
        methodVisitor.visitFieldInsn(181, generatedType.getInternalName(), CAN_CALL_SETTERS_FIELD_NAME, Type.BOOLEAN_TYPE.getDescriptor());
    }

    private void writeMutationMethods(ClassVisitor visitor, Type generatedType, Class<?> managedTypeClass) {
        ClassDetails classDetails = ClassInspector.inspect(managedTypeClass);
        for (PropertyDetails property : classDetails.getProperties()) {
            for (Method method : property.getGetters()) {
                if (Modifier.isAbstract(method.getModifiers())) {
                    this.writeGetter(visitor, generatedType, method);
                    continue;
                }
                if (Modifier.isFinal(method.getModifiers()) || property.getName().equals("metaClass")) continue;
                this.writeNonAbstractMethodWrapper(visitor, generatedType, managedTypeClass, method);
            }
            for (Method method : property.getSetters()) {
                this.writeSetter(visitor, generatedType, method);
            }
        }
    }

    private void writeSetter(ClassVisitor visitor, Type generatedType, Method method) {
        String propertyName = this.getPropertyName(method);
        Label calledOutsideOfConstructor = new Label();
        MethodVisitor methodVisitor = this.declareMethod(visitor, method);
        this.putCanCallSettersFieldValueOnStack(methodVisitor, generatedType);
        this.jumpToLabelIfStackEvaluatesToTrue(methodVisitor, calledOutsideOfConstructor);
        this.throwExceptionBecauseCalledOnItself(methodVisitor);
        this.writeLabel(methodVisitor, calledOutsideOfConstructor);
        this.putStateFieldValueOnStack(methodVisitor, generatedType);
        this.putConstantOnStack(methodVisitor, propertyName);
        this.putFirstMethodArgumentOnStack(methodVisitor);
        this.invokeStateSetMethod(methodVisitor);
        this.finishVisitingMethod(methodVisitor);
    }

    private void writeLabel(MethodVisitor methodVisitor, Label label) {
        methodVisitor.visitLabel(label);
        methodVisitor.visitFrame(3, 0, null, 0, null);
    }

    private void throwExceptionBecauseCalledOnItself(MethodVisitor methodVisitor) {
        String exceptionInternalName = Type.getInternalName(UnsupportedOperationException.class);
        methodVisitor.visitTypeInsn(187, exceptionInternalName);
        methodVisitor.visitInsn(89);
        this.putConstantOnStack(methodVisitor, "Calling setters of a managed type on itself is not allowed");
        String constructorDescriptor = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class)});
        methodVisitor.visitMethodInsn(183, exceptionInternalName, "<init>", constructorDescriptor, false);
        methodVisitor.visitInsn(191);
    }

    private void jumpToLabelIfStackEvaluatesToTrue(MethodVisitor methodVisitor, Label label) {
        methodVisitor.visitJumpInsn(154, label);
    }

    private void invokeStateSetMethod(MethodVisitor methodVisitor) {
        methodVisitor.visitMethodInsn(185, MODEL_ELEMENT_STATE_TYPE.getInternalName(), "set", STATE_SET_METHOD_DESCRIPTOR, true);
    }

    private void putConstantOnStack(MethodVisitor methodVisitor, Object value) {
        methodVisitor.visitLdcInsn(value);
    }

    private MethodVisitor declareMethod(ClassVisitor visitor, Method method) {
        MethodVisitor methodVisitor = visitor.visitMethod(1, method.getName(), Type.getMethodDescriptor((Method)method), CONCRETE_SIGNATURE, NO_EXCEPTIONS);
        methodVisitor.visitCode();
        return methodVisitor;
    }

    private void putFirstMethodArgumentOnStack(MethodVisitor methodVisitor) {
        methodVisitor.visitVarInsn(25, 1);
    }

    private void putMethodArgumentOnStack(MethodVisitor methodVisitor, int index) {
        methodVisitor.visitVarInsn(25, index);
    }

    private void putStateFieldValueOnStack(MethodVisitor methodVisitor, Type generatedType) {
        this.putFieldValueOnStack(methodVisitor, generatedType, STATE_FIELD_NAME, ModelElementState.class);
    }

    private void putCanCallSettersFieldValueOnStack(MethodVisitor methodVisitor, Type generatedType) {
        this.putFieldValueOnStack(methodVisitor, generatedType, CAN_CALL_SETTERS_FIELD_NAME, Boolean.TYPE);
    }

    private void putFieldValueOnStack(MethodVisitor methodVisitor, Type generatedType, String name, Class<?> fieldClass) {
        this.putThisOnStack(methodVisitor);
        methodVisitor.visitFieldInsn(180, generatedType.getInternalName(), name, Type.getDescriptor(fieldClass));
    }

    private void writeGetter(ClassVisitor visitor, Type generatedType, Method method) {
        String propertyName = this.getPropertyName(method);
        MethodVisitor methodVisitor = this.declareMethod(visitor, method);
        this.putStateFieldValueOnStack(methodVisitor, generatedType);
        this.putConstantOnStack(methodVisitor, propertyName);
        this.invokeStateGetMethod(methodVisitor);
        this.castFirstStackElement(methodVisitor, method.getReturnType());
        this.finishVisitingMethod(methodVisitor, 176);
    }

    private void castFirstStackElement(MethodVisitor methodVisitor, Class<?> returnType) {
        methodVisitor.visitTypeInsn(192, Type.getInternalName(returnType));
    }

    private String getPropertyName(Method method) {
        return StringUtils.uncapitalize((String)method.getName().substring(3));
    }

    private void invokeStateGetMethod(MethodVisitor methodVisitor) {
        String methodDescriptor = Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(String.class)});
        methodVisitor.visitMethodInsn(185, MODEL_ELEMENT_STATE_TYPE.getInternalName(), "get", methodDescriptor, true);
    }

    private void writeNonAbstractMethodWrapper(ClassVisitor visitor, Type generatedType, Class<?> managedTypeClass, Method method) {
        Label start = new Label();
        Label end = new Label();
        Label handler = new Label();
        MethodVisitor methodVisitor = this.declareMethod(visitor, method);
        methodVisitor.visitTryCatchBlock(start, end, handler, null);
        this.setCanCallSettersField(methodVisitor, generatedType, false);
        this.writeLabel(methodVisitor, start);
        this.invokeSuperMethod(methodVisitor, managedTypeClass, method);
        this.writeLabel(methodVisitor, end);
        this.setCanCallSettersField(methodVisitor, generatedType, true);
        methodVisitor.visitInsn(176);
        this.writeLabel(methodVisitor, handler);
        this.setCanCallSettersField(methodVisitor, generatedType, true);
        methodVisitor.visitInsn(191);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private void invokeSuperMethod(MethodVisitor methodVisitor, Class<?> superClass, Method method) {
        this.putThisOnStack(methodVisitor);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(superClass), method.getName(), Type.getMethodDescriptor((Method)method), false);
    }
}

