/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Scope;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.inspections.lint.IntellijLintUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public class IntellijGradleDetector
extends GradleDetector {
    static final Implementation IMPLEMENTATION = new Implementation(IntellijGradleDetector.class, Scope.GRADLE_SCOPE);

    @Nullable
    protected String getClosureName(@NonNull GrClosableBlock closure) {
        GrReferenceExpression invokedExpression;
        GrMethodCall parent;
        if (closure.getParent() instanceof GrMethodCall && (parent = (GrMethodCall)closure.getParent()).getInvokedExpression() instanceof GrReferenceExpression && (invokedExpression = (GrReferenceExpression)parent.getInvokedExpression()).getDotToken() == null) {
            return invokedExpression.getReferenceName();
        }
        return null;
    }

    public void visitBuildScript(final @NonNull Context context, Map<String, Object> sharedData) {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                PsiFile psiFile = IntellijLintUtils.getPsiFile(context);
                if (!(psiFile instanceof GroovyFile)) {
                    return;
                }
                GroovyFile groovyFile = (GroovyFile)psiFile;
                groovyFile.accept((GroovyElementVisitor)new GroovyRecursiveElementVisitor(){

                    public void visitClosure(GrClosableBlock closure) {
                        GrClosableBlock block;
                        String parentName = IntellijGradleDetector.this.getClosureName(closure);
                        String parentParentName = null;
                        if (parentName != null && (block = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)closure, GrClosableBlock.class, (boolean)true)) != null) {
                            parentParentName = IntellijGradleDetector.this.getClosureName(block);
                        }
                        if (parentName != null && IntellijGradleDetector.isInterestingBlock((String)parentName, (String)parentParentName)) {
                            for (PsiElement element : closure.getChildren()) {
                                GrExpression rValue;
                                GrReferenceExpression propertyRef;
                                String property;
                                GrAssignmentExpression assignment;
                                GrExpression lValue;
                                String value;
                                if (element instanceof GrApplicationStatement) {
                                    GrReferenceExpression propertyRef2;
                                    String property2;
                                    GrApplicationStatement call = (GrApplicationStatement)element;
                                    GrExpression propertyExpression = call.getInvokedExpression();
                                    GrCommandArgumentList argumentList = call.getArgumentList();
                                    if (!(propertyExpression instanceof GrReferenceExpression) || (property2 = (propertyRef2 = (GrReferenceExpression)propertyExpression).getReferenceName()) == null || !IntellijGradleDetector.isInterestingProperty((String)property2, (String)parentName, (String)parentParentName)) continue;
                                    value = argumentList.getText();
                                    IntellijGradleDetector.this.checkDslPropertyAssignment(context, property2, value, parentName, parentParentName, argumentList, call);
                                    continue;
                                }
                                if (!(element instanceof GrAssignmentExpression) || !((lValue = (assignment = (GrAssignmentExpression)element).getLValue()) instanceof GrReferenceExpression) || (property = (propertyRef = (GrReferenceExpression)lValue).getReferenceName()) == null || !IntellijGradleDetector.isInterestingProperty((String)property, (String)parentName, (String)parentParentName) || (rValue = assignment.getRValue()) == null) continue;
                                value = rValue.getText();
                                IntellijGradleDetector.this.checkDslPropertyAssignment(context, property, value, parentName, parentParentName, rValue, assignment);
                                if (!property.equals("minSdkVersion") && !property.equals("targetSdkVersion")) continue;
                                int lValueEnd = lValue.getTextRange().getEndOffset();
                                int rValueStart = rValue.getTextRange().getStartOffset();
                                assert (lValueEnd <= rValueStart);
                                DefaultPosition startPosition = new DefaultPosition(-1, -1, lValueEnd);
                                DefaultPosition endPosition = new DefaultPosition(-1, -1, rValueStart);
                                Location location = Location.create((File)context.file, (Position)startPosition, (Position)endPosition);
                                String message = String.format("Do not use assignment with the %1$s property (remove the '=')", property);
                                context.report(GradleDetector.IDE_SUPPORT, location, message, null);
                            }
                        }
                        super.visitClosure(closure);
                    }

                    public void visitApplicationStatement(GrApplicationStatement applicationStatement) {
                        GrClosableBlock block = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)applicationStatement, GrClosableBlock.class, (boolean)true);
                        String parentName = block != null ? IntellijGradleDetector.this.getClosureName(block) : null;
                        String statementName = applicationStatement.getInvokedExpression().getText();
                        if (IntellijGradleDetector.isInterestingStatement((String)statementName, (String)parentName)) {
                            GrCommandArgumentList argumentList = applicationStatement.getArgumentList();
                            HashMap namedArguments = Maps.newHashMap();
                            ArrayList unnamedArguments = Lists.newArrayList();
                            for (GroovyPsiElement groovyPsiElement : argumentList.getAllArguments()) {
                                if (groovyPsiElement instanceof GrNamedArgument) {
                                    Object value;
                                    GrNamedArgument namedArgument = (GrNamedArgument)groovyPsiElement;
                                    GrExpression expression = namedArgument.getExpression();
                                    if (expression == null || !(expression instanceof GrLiteral) || (value = ((GrLiteral)expression).getValue()) == null) continue;
                                    namedArguments.put(namedArgument.getLabelName(), value.toString());
                                    continue;
                                }
                                if (!(groovyPsiElement instanceof GrExpression)) continue;
                                unnamedArguments.add(groovyPsiElement.getText());
                            }
                            IntellijGradleDetector.this.checkMethodCall(context, statementName, parentName, namedArguments, unnamedArguments, applicationStatement);
                        }
                        super.visitApplicationStatement(applicationStatement);
                    }
                });
            }
        });
    }

    protected int getStartOffset(@NonNull Context context, @NonNull Object cookie) {
        PsiElement element = (PsiElement)cookie;
        TextRange textRange = element.getTextRange();
        return textRange.getStartOffset();
    }

    @NonNull
    protected Object getPropertyPairCookie(@NonNull Object cookie) {
        PsiElement element = (PsiElement)cookie;
        return element.getParent();
    }

    @NonNull
    protected Object getPropertyKeyCookie(@NonNull Object cookie) {
        PsiElement element = (PsiElement)cookie;
        PsiElement parent = element.getParent();
        if (parent instanceof GrApplicationStatement) {
            GrApplicationStatement call = (GrApplicationStatement)parent;
            return call.getInvokedExpression();
        }
        if (parent instanceof GrAssignmentExpression) {
            GrAssignmentExpression assignment = (GrAssignmentExpression)parent;
            return assignment.getLValue();
        }
        return super.getPropertyKeyCookie(cookie);
    }

    protected Location createLocation(@NonNull Context context, @NonNull Object cookie) {
        PsiElement element = (PsiElement)cookie;
        TextRange textRange = element.getTextRange();
        int start = textRange.getStartOffset();
        int end = textRange.getEndOffset();
        return Location.create((File)context.file, (Position)new DefaultPosition(-1, -1, start), (Position)new DefaultPosition(-1, -1, end));
    }
}

