/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.fileTypes;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.EmptyLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.android.fileTypes.AndroidIdlFileImpl;
import org.jetbrains.android.fileTypes.AndroidIdlFileType;
import org.jetbrains.annotations.NotNull;

public class AndroidIdlParserDefinition
implements ParserDefinition {
    public static final IElementType AIDL_TEXT = new IElementType("AIDL_TEXT", AndroidIdlFileType.ourFileType.getLanguage());
    public static final IFileElementType AIDL_FILE_ELEMENT_TYPE = new IFileElementType(AndroidIdlFileType.ourFileType.getLanguage()){

        public ASTNode parseContents(ASTNode chameleon) {
            return ASTFactory.leaf((IElementType)AIDL_TEXT, (CharSequence)chameleon.getChars());
        }
    };

    @NotNull
    public Lexer createLexer(Project project) {
        EmptyLexer emptyLexer = new EmptyLexer();
        if (emptyLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/fileTypes/AndroidIdlParserDefinition", "createLexer"));
        }
        return emptyLexer;
    }

    public PsiParser createParser(Project project) {
        throw new UnsupportedOperationException();
    }

    public IFileElementType getFileNodeType() {
        return AIDL_FILE_ELEMENT_TYPE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/fileTypes/AndroidIdlParserDefinition", "getWhitespaceTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/fileTypes/AndroidIdlParserDefinition", "getCommentTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/fileTypes/AndroidIdlParserDefinition", "getStringLiteralElements"));
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        PsiElement psiElement = PsiUtilCore.NULL_PSI_ELEMENT;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/fileTypes/AndroidIdlParserDefinition", "createElement"));
        }
        return psiElement;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new AndroidIdlFileImpl(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }
}

