/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.wrappers;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.android.dom.wrappers.ValueResourceElementWrapper;
import org.jetbrains.android.resourceManagers.ValueResourceInfo;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyValueResourceElementWrapper
extends RenameableFakePsiElement
implements PsiTarget,
Comparable<LazyValueResourceElementWrapper> {
    private final ValueResourceInfo myResourceInfo;
    private final PsiElement myParent;

    public LazyValueResourceElementWrapper(@NotNull ValueResourceInfo resourceInfo, @NotNull PsiElement parent) {
        if (resourceInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceInfo", "org/jetbrains/android/dom/wrappers/LazyValueResourceElementWrapper", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/android/dom/wrappers/LazyValueResourceElementWrapper", "<init>"));
        }
        super(parent);
        this.myParent = parent;
        this.myResourceInfo = resourceInfo;
    }

    public String getName() {
        return this.myResourceInfo.getName();
    }

    @Nullable
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/dom/wrappers/LazyValueResourceElementWrapper", "setName"));
        }
        XmlAttributeValue element = this.computeElement();
        if (element == null) {
            throw new IncorrectOperationException("Cannot find resource '" + this.myResourceInfo.getName() + "' in file " + this.myResourceInfo.getContainingFile().getPath());
        }
        return new ValueResourceElementWrapper(element).setName(name);
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                String name = LazyValueResourceElementWrapper.this.myResourceInfo.getName();
                VirtualFile file = LazyValueResourceElementWrapper.this.myResourceInfo.getContainingFile();
                VirtualFile dir = file.getParent();
                if (dir == null) {
                    return name;
                }
                return name + " (..." + File.separatorChar + dir.getName() + File.separatorChar + file.getName() + ')';
            }

            public String getLocationString() {
                return null;
            }

            public Icon getIcon(boolean open) {
                return null;
            }
        };
    }

    @Nullable
    public XmlAttributeValue computeElement() {
        return this.myResourceInfo.computeXmlElement();
    }

    @NotNull
    public PsiElement getNavigationElement() {
        XmlAttributeValue element = this.myResourceInfo.computeXmlElement();
        Object object = element != null ? element : this.myParent;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/wrappers/LazyValueResourceElementWrapper", "getNavigationElement"));
        }
        return object;
    }

    @NotNull
    public ValueResourceInfo getResourceInfo() {
        ValueResourceInfo valueResourceInfo = this.myResourceInfo;
        if (valueResourceInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/wrappers/LazyValueResourceElementWrapper", "getResourceInfo"));
        }
        return valueResourceInfo;
    }

    public String getTypeName() {
        return "Android Value Resource";
    }

    public Icon getIcon() {
        return null;
    }

    @Nullable
    public static PsiElement computeLazyElement(PsiElement element) {
        if (element instanceof LazyValueResourceElementWrapper) {
            element = ((LazyValueResourceElementWrapper)element).computeElement();
        }
        return element;
    }

    @Override
    public int compareTo(@NotNull LazyValueResourceElementWrapper other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/android/dom/wrappers/LazyValueResourceElementWrapper", "compareTo"));
        }
        return this.myResourceInfo.compareTo(other.myResourceInfo);
    }
}

