/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.morphing;

import com.intellij.android.designer.model.ComponentMorphingTool;
import com.intellij.android.designer.model.PropertyParser;
import com.intellij.android.designer.model.RadComponentOperations;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.ViewsMetaManager;
import com.intellij.android.designer.model.layout.RadLinearLayout;
import com.intellij.android.designer.model.layout.RadRadioGroupLayout;
import com.intellij.android.designer.model.layout.grid.RadGridLayout;
import com.intellij.android.designer.model.layout.grid.RadGridLayoutComponent;
import com.intellij.android.designer.model.layout.table.RadTableLayout;
import com.intellij.android.designer.model.layout.table.RadTableLayoutComponent;
import com.intellij.designer.model.MetaModel;
import com.intellij.designer.model.RadComponent;
import java.util.ArrayList;

public class LinearLayout {
    public static RadViewComponent RadioGroup(RadViewComponent component, MetaModel target) throws Exception {
        final boolean horizontal = ((RadLinearLayout)component.getLayout()).isHorizontal();
        return new ComponentMorphingTool(component, component, target, new RadRadioGroupLayout()){

            @Override
            protected void convertTag() {
                if (horizontal) {
                    this.myNewComponent.getTag().setAttribute("orientation", "http://schemas.android.com/apk/res/android", "horizontal");
                } else {
                    RadComponentOperations.deleteAttribute((RadComponent)this.myNewComponent, "orientation");
                }
            }
        }.result();
    }

    public static RadViewComponent GridLayout(RadViewComponent component, MetaModel target) throws Exception {
        return new ComponentMorphingTool(component, new RadGridLayoutComponent(), target, new RadGridLayout()).result();
    }

    public static RadViewComponent TableLayout(RadViewComponent component, MetaModel target) throws Exception {
        boolean horizontal = ((RadLinearLayout)component.getLayout()).isHorizontal();
        return LinearLayout.TableLayout(component, target, horizontal);
    }

    public static RadViewComponent TableLayout(RadViewComponent component, MetaModel target, final boolean horizontal) throws Exception {
        final MetaModel tableRowModel = ViewsMetaManager.getInstance(component.getTag().getProject()).getModelByTag("TableRow");
        return new ComponentMorphingTool(component, new RadTableLayoutComponent(), target, new RadTableLayout()){

            @Override
            protected void convertChildren() throws Exception {
                ArrayList<RadComponent> oldChildren = new ArrayList<RadComponent>(this.myOldComponent.getChildren());
                if (horizontal) {
                    RadViewComponent newRowComponent = RadComponentOperations.createComponent(null, tableRowModel);
                    RadComponentOperations.addComponent(this.myNewComponent, newRowComponent, null);
                    for (RadComponent childComponent : oldChildren) {
                        RadComponentOperations.moveComponent(newRowComponent, (RadViewComponent)childComponent, null);
                    }
                } else {
                    for (RadComponent childComponent : oldChildren) {
                        RadViewComponent newRowComponent = RadComponentOperations.createComponent(null, tableRowModel);
                        RadComponentOperations.addComponent(this.myNewComponent, newRowComponent, null);
                        RadComponentOperations.moveComponent(newRowComponent, (RadViewComponent)childComponent, null);
                    }
                }
            }

            @Override
            protected void convertTag() {
                RadComponentOperations.deleteAttribute((RadComponent)this.myNewComponent, "orientation");
            }

            @Override
            protected void loadChildProperties(PropertyParser propertyParser) throws Exception {
            }
        }.result();
    }
}

