/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model.morphing;

import com.intellij.android.designer.model.ComponentMorphingTool;
import com.intellij.android.designer.model.PropertyParser;
import com.intellij.android.designer.model.RadComponentOperations;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.ViewsMetaManager;
import com.intellij.android.designer.model.layout.Gravity;
import com.intellij.android.designer.model.layout.grid.RadGridLayout;
import com.intellij.android.designer.model.layout.grid.RadGridLayoutComponent;
import com.intellij.android.designer.model.layout.table.RadTableLayout;
import com.intellij.android.designer.model.layout.table.RadTableLayoutComponent;
import com.intellij.designer.model.MetaModel;
import com.intellij.designer.model.RadComponent;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.hash.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class FrameLayout {
    private static final String COLUMN_KEY = "Column";

    public static RadViewComponent TableLayout(RadViewComponent component, MetaModel target) throws Exception {
        final MetaModel tableRowModel = ViewsMetaManager.getInstance(component.getTag().getProject()).getModelByTag("TableRow");
        return new ComponentMorphingTool(component, new RadTableLayoutComponent(), target, new RadTableLayout()){

            @Override
            protected void convertChildren() throws Exception {
                Map rowMap;
                RadViewComponent[] rowComponents = new RadViewComponent[3];
                HashMap components = new HashMap();
                for (int i = 0; i < rowComponents.length; ++i) {
                    RadViewComponent newRowComponent = RadComponentOperations.createComponent(null, tableRowModel);
                    RadComponentOperations.addComponent(this.myNewComponent, newRowComponent, null);
                    rowComponents[i] = newRowComponent;
                }
                for (RadComponent childComponent : new ArrayList<RadComponent>(this.myOldComponent.getChildren())) {
                    ArrayList<RadViewComponent> rowChildren;
                    Pair<Gravity, Gravity> sides = Gravity.getSides(childComponent);
                    RadViewComponent rowComponent = rowComponents[FrameLayout.getRowIndex((Gravity)((Object)sides.second))];
                    rowMap = (Map)components.get((Object)rowComponent);
                    if (rowMap == null) {
                        rowMap = new HashMap();
                        components.put(rowComponent, rowMap);
                    }
                    if ((rowChildren = (ArrayList<RadViewComponent>)rowMap.get(sides.first)) == null) {
                        rowChildren = new ArrayList<RadViewComponent>();
                        rowMap.put(sides.first, rowChildren);
                    }
                    rowChildren.add((RadViewComponent)childComponent);
                }
                for (RadViewComponent rowComponent : rowComponents) {
                    rowMap = (Map)components.get((Object)rowComponent);
                    boolean column = FrameLayout.moveComponents(rowComponent, (Collection)rowMap.remove((Object)Gravity.left), -1);
                    column = FrameLayout.moveComponents(rowComponent, (Collection)rowMap.remove((Object)Gravity.center), column ? 1 : -1);
                    FrameLayout.moveComponents(rowComponent, (Collection)rowMap.remove((Object)Gravity.right), column ? 2 : -1);
                    for (List rowChildren : rowMap.values()) {
                        FrameLayout.moveComponents(rowComponent, rowChildren, -1);
                    }
                }
            }

            @Override
            protected void convertTag() {
                for (RadComponent rowComponent : this.myNewComponent.getChildren()) {
                    for (RadComponent cellComponent : rowComponent.getChildren()) {
                        XmlTag childTag = ((RadViewComponent)cellComponent).getTag();
                        RadComponentOperations.deleteAttribute(childTag, "layout_gravity");
                        Integer column = (Integer)cellComponent.extractClientProperty(FrameLayout.COLUMN_KEY);
                        if (column == null) continue;
                        childTag.setAttribute("layout_column", "http://schemas.android.com/apk/res/android", column.toString());
                    }
                }
            }

            @Override
            protected void loadChildProperties(PropertyParser propertyParser) throws Exception {
            }
        }.result();
    }

    private static boolean moveComponents(RadViewComponent container, Collection<RadViewComponent> children, int column) throws Exception {
        if (children != null) {
            for (RadViewComponent childComponent : children) {
                if (column != -1) {
                    childComponent.setClientProperty(COLUMN_KEY, column);
                }
                RadComponentOperations.moveComponent(container, childComponent, null);
            }
            return false;
        }
        return true;
    }

    private static int getRowIndex(Gravity side) {
        if (side == Gravity.center) {
            return 1;
        }
        if (side == Gravity.bottom) {
            return 2;
        }
        return 0;
    }

    public static RadViewComponent GridLayout(RadViewComponent component, MetaModel target) throws Exception {
        return new ComponentMorphingTool(component, new RadGridLayoutComponent(), target, new RadGridLayout()){

            @Override
            protected void convertTag() {
                XmlTag tag = this.myNewComponent.getTag();
                tag.setAttribute("rowCount", "http://schemas.android.com/apk/res/android", "3");
                tag.setAttribute("columnCount", "http://schemas.android.com/apk/res/android", "3");
                for (RadComponent childComponent : this.myNewComponent.getChildren()) {
                    XmlTag childTag = ((RadViewComponent)childComponent).getTag();
                    Pair<Gravity, Gravity> sides = Gravity.getSides(childComponent);
                    RadComponentOperations.deleteAttribute(childTag, "layout_gravity");
                    childTag.setAttribute("layout_row", "http://schemas.android.com/apk/res/android", FrameLayout.getRowIndexValue((Gravity)((Object)sides.second)));
                    childTag.setAttribute("layout_column", "http://schemas.android.com/apk/res/android", FrameLayout.getColumnIndexValue((Gravity)((Object)sides.first)));
                }
            }
        }.result();
    }

    private static String getRowIndexValue(Gravity side) {
        if (side == Gravity.center) {
            return "1";
        }
        if (side == Gravity.bottom) {
            return "2";
        }
        return "0";
    }

    private static String getColumnIndexValue(Gravity side) {
        if (side == Gravity.center) {
            return "1";
        }
        if (side == Gravity.right) {
            return "2";
        }
        return "0";
    }
}

