/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.welcome.wizard.FirstRunWizardStep;
import com.android.tools.idea.welcome.wizard.WelcomeUIUtils;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.google.common.base.Supplier;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InstallSummaryStep
extends FirstRunWizardStep {
    private final ScopedStateStore.Key<Boolean> myKeyCustomInstall;
    private final ScopedStateStore.Key<String> myKeySdkInstallLocation;
    private final Supplier<? extends Collection<RemotePkgInfo>> myPackagesProvider;
    private JPanel myPanel;
    private JTextPane mySummaryText;

    public InstallSummaryStep(ScopedStateStore.Key<Boolean> keyCustomInstall, ScopedStateStore.Key<String> keySdkInstallLocation, Supplier<? extends Collection<RemotePkgInfo>> packagesProvider) {
        super("Verify Settings");
        this.myKeyCustomInstall = keyCustomInstall;
        this.myKeySdkInstallLocation = keySdkInstallLocation;
        this.myPackagesProvider = packagesProvider;
        this.$$$setupUI$$$();
        this.mySummaryText.setContentType("text/html");
        this.mySummaryText.setBorder(new EmptyBorder(0, 12, 12, 12));
        this.setComponent(this.myPanel);
    }

    private static Section getPackagesSection(@NotNull Collection<RemotePkgInfo> remotePackages) {
        if (remotePackages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotePackages", "com/android/tools/idea/welcome/wizard/InstallSummaryStep", "getPackagesSection"));
        }
        return new Section("Sdk Components to Download", InstallSummaryStep.getPackagesTable(remotePackages));
    }

    @Nullable
    private static String getPackagesTable(@NotNull Collection<RemotePkgInfo> remotePackages) {
        if (remotePackages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotePackages", "com/android/tools/idea/welcome/wizard/InstallSummaryStep", "getPackagesTable"));
        }
        if (remotePackages.isEmpty()) {
            return null;
        }
        TreeSet sortedPackagesList = Sets.newTreeSet((Comparator)new PackageInfoComparator());
        sortedPackagesList.addAll(remotePackages);
        StringBuilder table = new StringBuilder("<table>");
        for (RemotePkgInfo remotePkgInfo : sortedPackagesList) {
            table.append("<tr><td>").append(remotePkgInfo.getShortDescription()).append("</td><td>&nbsp;&nbsp;</td><td>").append(WelcomeUIUtils.getSizeLabel(remotePkgInfo.getDownloadSize())).append("</td></tr>");
        }
        table.append("</table>");
        return table.toString();
    }

    private static Section getDownloadSizeSection(@NotNull Collection<RemotePkgInfo> remotePackages) {
        if (remotePackages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotePackages", "com/android/tools/idea/welcome/wizard/InstallSummaryStep", "getDownloadSizeSection"));
        }
        long downloadSize = 0L;
        for (RemotePkgInfo remotePackage : remotePackages) {
            downloadSize += remotePackage.getDownloadSize();
        }
        return new Section("Total Download Size", downloadSize == 0L ? "" : WelcomeUIUtils.getSizeLabel(downloadSize));
    }

    @Override
    public void onEnterStep() {
        super.onEnterStep();
        this.generateSummary();
    }

    @Override
    public void init() {
    }

    private void generateSummary() {
        Collection remotePackages = (Collection)this.myPackagesProvider.get();
        StringBuilder builder = new StringBuilder("<html><head>");
        builder.append(UIUtil.getCssFontDeclaration((Font)UIUtil.getLabelFont(), (Color)UIUtil.getLabelForeground(), null, null)).append("</head><body>");
        ImmutableList sections = ImmutableList.of((Object)this.getSetupTypeSection(), (Object)this.getDestinationFolderSection(), (Object)InstallSummaryStep.getDownloadSizeSection(remotePackages), (Object)InstallSummaryStep.getPackagesSection(remotePackages));
        for (Section section : sections) {
            if (section.isEmpty()) continue;
            builder.append(section.toHtml());
        }
        builder.append("</body></html>");
        this.mySummaryText.setText(builder.toString());
    }

    private Section getDestinationFolderSection() {
        String destinationFolder = PathUtil.toSystemDependentName((String)this.myState.get(this.myKeySdkInstallLocation));
        return new Section("Destination Folder", destinationFolder);
    }

    private Section getSetupTypeSection() {
        String setupType = this.myState.getNotNull(this.myKeyCustomInstall, false) != false ? "Custom" : "Standard";
        return new Section("Setup type", setupType);
    }

    @Override
    @Nullable
    public JLabel getMessageLabel() {
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySummaryText;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextPane jTextPane;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("If you want to review or change any of your installation settings, click Previous.");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Current Settings:");
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 16), new Dimension(-1, 16)));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(3, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        this.mySummaryText = jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jScrollPane.setViewportView(jTextPane);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static class PackageInfoComparator
    implements Comparator<RemotePkgInfo> {
        private PackageInfoComparator() {
        }

        @Override
        public int compare(RemotePkgInfo o1, RemotePkgInfo o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            ComparisonChain comparisonChain = ComparisonChain.start();
            return comparisonChain.compare((Comparable)((Object)o1.getShortDescription()), (Comparable)((Object)o2.getShortDescription())).result();
        }
    }

    private static final class Section {
        @NotNull
        private final String myTitle;
        @NotNull
        private final String myText;

        public Section(@NotNull String title, @Nullable String text) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/welcome/wizard/InstallSummaryStep$Section", "<init>"));
            }
            this.myTitle = title;
            this.myText = StringUtil.notNullize((String)text);
        }

        @NotNull
        public String getTitle() {
            String string = this.myTitle;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/wizard/InstallSummaryStep$Section", "getTitle"));
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/wizard/InstallSummaryStep$Section", "getText"));
            }
            return string;
        }

        public boolean isEmpty() {
            return StringUtil.isEmptyOrSpaces((String)this.myText);
        }

        public String toHtml() {
            return String.format("<p><strong>%1$s:</strong><br>%2$s</p>", this.myTitle, this.myText);
        }
    }
}

