/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.model.java;

import com.intellij.openapi.util.text.StringUtil;
import java.io.Serializable;
import org.gradle.tooling.model.idea.IdeaDependencyScope;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaModuleDependency;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaModuleDependency
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String myModuleName;
    @Nullable
    private final String myScope;
    private final boolean myExported;

    @Nullable
    public static JavaModuleDependency copy(IdeaModuleDependency original) {
        IdeaModule module = original.getDependencyModule();
        if (module != null && StringUtil.isNotEmpty((String)module.getName())) {
            String scope = null;
            IdeaDependencyScope originalScope = original.getScope();
            if (originalScope != null) {
                scope = originalScope.getScope();
            }
            return new JavaModuleDependency(module.getName(), scope, original.getExported());
        }
        return null;
    }

    public JavaModuleDependency(@NotNull String moduleName, @Nullable String scope, boolean exported) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/model/java/JavaModuleDependency", "<init>"));
        }
        this.myModuleName = moduleName;
        this.myScope = scope;
        this.myExported = exported;
    }

    @NotNull
    public String getModuleName() {
        String string = this.myModuleName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/model/java/JavaModuleDependency", "getModuleName"));
        }
        return string;
    }

    @Nullable
    public String getScope() {
        return this.myScope;
    }

    public boolean isExported() {
        return this.myExported;
    }
}

