/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.DeviceMenuAction;
import com.android.tools.idea.configurations.ThemeSelectionDialog;
import com.android.tools.idea.editors.theme.AttributesPanel;
import com.android.tools.idea.editors.theme.NewStyleDialog;
import com.android.tools.idea.editors.theme.ProjectThemeResolver;
import com.android.tools.idea.editors.theme.ResourcesCompletionProvider;
import com.android.tools.idea.editors.theme.StyleResolver;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorTable;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.android.tools.idea.editors.theme.ThemesListModel;
import com.android.tools.idea.editors.theme.attributes.AttributesGrouper;
import com.android.tools.idea.editors.theme.attributes.AttributesModelColorPaletteModel;
import com.android.tools.idea.editors.theme.attributes.AttributesTableModel;
import com.android.tools.idea.editors.theme.attributes.ShowJavadocAction;
import com.android.tools.idea.editors.theme.attributes.TableLabel;
import com.android.tools.idea.editors.theme.attributes.editors.AttributeReferenceRendererEditor;
import com.android.tools.idea.editors.theme.attributes.editors.BooleanRendererEditor;
import com.android.tools.idea.editors.theme.attributes.editors.ColorEditor;
import com.android.tools.idea.editors.theme.attributes.editors.ColorRenderer;
import com.android.tools.idea.editors.theme.attributes.editors.DelegatingCellEditor;
import com.android.tools.idea.editors.theme.attributes.editors.DelegatingCellRenderer;
import com.android.tools.idea.editors.theme.attributes.editors.DrawableEditor;
import com.android.tools.idea.editors.theme.attributes.editors.DrawableRenderer;
import com.android.tools.idea.editors.theme.attributes.editors.EnumRendererEditor;
import com.android.tools.idea.editors.theme.attributes.editors.FlagRendererEditor;
import com.android.tools.idea.editors.theme.attributes.editors.IntegerRenderer;
import com.android.tools.idea.editors.theme.attributes.editors.ParentRendererEditor;
import com.android.tools.idea.editors.theme.attributes.editors.StyleListCellRenderer;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.android.tools.idea.editors.theme.preview.AndroidThemePreviewPanel;
import com.android.tools.idea.gradle.compiler.PostProjectBuildTasksExecutor;
import com.android.tools.idea.gradle.project.GradleBuildListener;
import com.android.tools.idea.gradle.util.BuildMode;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.Processor;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.PanelUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableRowSorter;
import org.jetbrains.android.dom.drawable.DrawableDomElement;
import org.jetbrains.android.dom.resources.Flag;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.dom.resources.Style;
import org.jetbrains.android.dom.resources.StyleItem;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeEditorComponent
extends Splitter {
    private static final Logger LOG = Logger.getInstance(ThemeEditorComponent.class);
    private static final JBColor PREVIEW_BACKGROUND = new JBColor(new Color(0xFAFAFA), new Color(6316386));
    public static final float HEADER_FONT_SCALE = 1.3f;
    public static final int REGULAR_CELL_PADDING = 4;
    public static final int LARGE_CELL_PADDING = 10;
    private final Project myProject;
    private Font myHeaderFont;
    private StyleResolver myStyleResolver;
    private String myPreviousSelectedTheme;
    private ThemeEditorStyle myCurrentSubStyle;
    private EditedStyleItem mySubStyleSourceAttribute;
    private final ThemeEditorContext myThemeEditorContext;
    private final AndroidThemePreviewPanel myPreviewPanel;
    private final StyleAttributesFilter myAttributesFilter;
    private TableRowSorter<AttributesTableModel> myAttributesSorter;
    private final SimpleModeFilter mySimpleModeFilter;
    private final AttributesPanel myPanel;
    private final ThemeEditorTable myAttributesTable;
    private final AttributeReferenceRendererEditor myStyleEditor;
    private final GoToListener myGoToListener;
    private ThemeEditorStyle mySelectedTheme;
    private MessageBusConnection myMessageBusConnection;
    private AttributesTableModel myModel;

    public ThemeEditorComponent(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/theme/ThemeEditorComponent", "<init>"));
        }
        this.myPanel = new AttributesPanel();
        this.myAttributesTable = this.myPanel.getAttributesTable();
        this.myProject = project;
        ImmutableList<ProjectThemeResolver.ThemeWithSource> editableProjectThemes = ProjectThemeResolver.getEditableProjectThemes(project);
        ProjectThemeResolver.ThemeWithSource firstTheme = (ProjectThemeResolver.ThemeWithSource)Iterables.getFirst(editableProjectThemes, null);
        assert (firstTheme != null) : "Trying to launch Theme Editor without any themes";
        Module module = firstTheme.getSourceModule();
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null) : String.format("Module %s is not Android module", module.getName());
        ConfigurationManager configurationManager = facet.getConfigurationManager();
        VirtualFile projectFile = project.getProjectFile();
        assert (projectFile != null);
        Configuration configuration = configurationManager.getConfiguration(projectFile);
        this.myThemeEditorContext = new ThemeEditorContext(configuration, module);
        this.myThemeEditorContext.addConfigurationListener(new ConfigurationListener(){

            @Override
            public boolean changed(int flags) {
                if ((flags & 2) != 0) {
                    ThemeEditorComponent.this.loadStyleAttributes();
                    ThemeEditorComponent.this.myThemeEditorContext.getConfiguration().save();
                }
                return true;
            }
        });
        this.myStyleResolver = new StyleResolver(configuration);
        this.myPreviewPanel = new AndroidThemePreviewPanel(this.myThemeEditorContext, (Color)PREVIEW_BACKGROUND);
        this.myPreviewPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        ActionManager actionManager = ActionManager.getInstance();
        ShowJavadocAction showJavadoc = new ShowJavadocAction((JTable)((Object)this.myAttributesTable), this.myThemeEditorContext);
        showJavadoc.registerCustomShortcutSet(actionManager.getAction("QuickJavaDoc").getShortcutSet(), (JComponent)((Object)this.myAttributesTable));
        ResourcesCompletionProvider completionProvider = new ResourcesCompletionProvider(this.myThemeEditorContext);
        this.myGoToListener = new GoToListener(){

            @Override
            public void goTo(@NotNull EditedStyleItem value) {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/theme/ThemeEditorComponent$2", "goTo"));
                }
                ResourceResolver resolver = ThemeEditorComponent.this.myThemeEditorContext.getResourceResolver();
                if (value.isAttr() && ThemeEditorComponent.this.getSelectedStyle() != null && resolver != null) {
                    ItemResourceValue resourceValue = (ItemResourceValue)resolver.findResValue(value.getValue(), false);
                    if (resourceValue == null) {
                        LOG.error("Unable to resolve " + value.getValue());
                        return;
                    }
                    EditedStyleItem editedStyleItem = new EditedStyleItem(resourceValue, ThemeEditorComponent.this.getSelectedStyle());
                    assert (editedStyleItem.getValue() != null);
                    ThemeEditorComponent.this.myCurrentSubStyle = ThemeEditorComponent.this.myStyleResolver.getStyle(editedStyleItem.getValue());
                } else {
                    if (value.getValue() == null) {
                        LOG.error("null value for " + value.getName());
                        return;
                    }
                    ThemeEditorComponent.this.myCurrentSubStyle = ThemeEditorComponent.this.myStyleResolver.getStyle(value.getValue());
                }
                ThemeEditorComponent.this.mySubStyleSourceAttribute = value;
                ThemeEditorComponent.this.loadStyleAttributes();
            }

            @Override
            public void goToParent() {
                ThemeEditorComponent.this.goToParent();
            }
        };
        this.myStyleEditor = new AttributeReferenceRendererEditor(project, completionProvider);
        JBScrollPane scroll = this.myPanel.getAttributesScrollPane();
        scroll.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.myAttributesTable.setBackground(null);
        scroll.setBackground(null);
        scroll.getViewport().setBackground(null);
        this.myAttributesTable.setDefaultRenderer(Color.class, new DelegatingCellRenderer(new ColorRenderer(this.myThemeEditorContext)));
        this.myAttributesTable.setDefaultRenderer(EditedStyleItem.class, new DelegatingCellRenderer(new AttributeReferenceRendererEditor(project, completionProvider)));
        this.myAttributesTable.setDefaultRenderer(ThemeEditorStyle.class, new DelegatingCellRenderer(new AttributeReferenceRendererEditor(project, completionProvider)));
        this.myAttributesTable.setDefaultRenderer(String.class, new DelegatingCellRenderer(this.myAttributesTable.getDefaultRenderer(String.class)));
        this.myAttributesTable.setDefaultRenderer(Integer.class, new DelegatingCellRenderer(new IntegerRenderer()));
        this.myAttributesTable.setDefaultRenderer(Boolean.class, new DelegatingCellRenderer(new BooleanRendererEditor(this.myThemeEditorContext)));
        this.myAttributesTable.setDefaultRenderer(Enum.class, new DelegatingCellRenderer(new EnumRendererEditor()));
        this.myAttributesTable.setDefaultRenderer(Flag.class, new DelegatingCellRenderer(new FlagRendererEditor()));
        this.myAttributesTable.setDefaultRenderer(AttributesTableModel.ParentAttribute.class, new DelegatingCellRenderer(new ParentRendererEditor(this.myThemeEditorContext)));
        this.myAttributesTable.setDefaultRenderer(DrawableDomElement.class, new DelegatingCellRenderer(new DrawableRenderer(this.myThemeEditorContext)));
        this.myAttributesTable.setDefaultRenderer(TableLabel.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setFont(ThemeEditorComponent.this.myHeaderFont);
                return this;
            }
        });
        this.myAttributesTable.setDefaultEditor(Color.class, new DelegatingCellEditor(false, (TableCellEditor)((Object)new ColorEditor(this.myThemeEditorContext, this.myPreviewPanel)), this.myThemeEditorContext));
        this.myAttributesTable.setDefaultEditor(EditedStyleItem.class, new DelegatingCellEditor(false, (TableCellEditor)((Object)new AttributeReferenceRendererEditor(project, completionProvider)), this.myThemeEditorContext));
        this.myAttributesTable.setDefaultEditor(String.class, new DelegatingCellEditor(false, this.myAttributesTable.getDefaultEditor(String.class), this.myThemeEditorContext));
        this.myAttributesTable.setDefaultEditor(Integer.class, new DelegatingCellEditor(this.myAttributesTable.getDefaultEditor(Integer.class), this.myThemeEditorContext));
        this.myAttributesTable.setDefaultEditor(Boolean.class, new DelegatingCellEditor(false, (TableCellEditor)((Object)new BooleanRendererEditor(this.myThemeEditorContext)), this.myThemeEditorContext));
        this.myAttributesTable.setDefaultEditor(Enum.class, new DelegatingCellEditor(false, (TableCellEditor)((Object)new EnumRendererEditor()), this.myThemeEditorContext));
        this.myAttributesTable.setDefaultEditor(Flag.class, new DelegatingCellEditor(false, (TableCellEditor)((Object)new FlagRendererEditor()), this.myThemeEditorContext));
        this.myAttributesTable.setDefaultEditor(AttributesTableModel.ParentAttribute.class, new DelegatingCellEditor(false, (TableCellEditor)((Object)new ParentRendererEditor(this.myThemeEditorContext)), this.myThemeEditorContext));
        this.myAttributesTable.setDefaultEditor(ThemeEditorStyle.class, new DelegatingCellEditor(false, (TableCellEditor)((Object)this.myStyleEditor), this.myThemeEditorContext));
        this.myAttributesTable.setDefaultEditor(DrawableDomElement.class, new DelegatingCellEditor(false, (TableCellEditor)((Object)new DrawableEditor(this.myThemeEditorContext)), this.myThemeEditorContext));
        this.updateUiParameters();
        this.myAttributesFilter = new StyleAttributesFilter();
        this.mySimpleModeFilter = new SimpleModeFilter();
        this.myPanel.getBackButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThemeEditorComponent.this.myCurrentSubStyle = null;
                ThemeEditorComponent.this.loadStyleAttributes();
            }
        });
        this.myPanel.getAdvancedFilterCheckBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ThemeEditorComponent.this.myAttributesTable.isEditing()) {
                    ThemeEditorComponent.this.myAttributesTable.getCellEditor().cancelCellEditing();
                }
                ThemeEditorComponent.this.myAttributesTable.clearSelection();
                ThemeEditorComponent.this.myPanel.getPalette().clearSelection();
                ThemeEditorComponent.this.configureFilter();
                ((TableRowSorter)ThemeEditorComponent.this.myAttributesTable.getRowSorter()).sort();
                ThemeEditorComponent.this.myAttributesTable.updateRowHeights();
            }
        });
        this.myPanel.getThemeCombo().setRenderer(new StyleListCellRenderer(this.myThemeEditorContext));
        this.myPanel.getThemeCombo().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ThemeEditorComponent.this.myPanel.isCreateNewThemeSelected()) {
                    if (!ThemeEditorComponent.this.createNewTheme()) {
                        ThemeEditorComponent.this.myPanel.setSelectedTheme(ThemeEditorComponent.this.mySelectedTheme);
                    }
                } else if (ThemeEditorComponent.this.myPanel.isShowAllThemesSelected()) {
                    if (!ThemeEditorComponent.this.selectNewTheme()) {
                        ThemeEditorComponent.this.myPanel.setSelectedTheme(ThemeEditorComponent.this.mySelectedTheme);
                    }
                } else if (ThemeEditorComponent.this.myPanel.isRenameSelected()) {
                    if (!ThemeEditorComponent.this.renameTheme()) {
                        ThemeEditorComponent.this.myPanel.setSelectedTheme(ThemeEditorComponent.this.mySelectedTheme);
                    }
                } else {
                    Object item = ThemeEditorComponent.this.myPanel.getThemeCombo().getSelectedItem();
                    ThemeEditorStyle theme = ThemesListModel.getStyle(item);
                    assert (theme != null);
                    ThemeEditorComponent.this.mySelectedTheme = theme;
                    ThemeEditorComponent.this.saveCurrentSelectedTheme();
                    ThemeEditorComponent.this.myCurrentSubStyle = null;
                    ThemeEditorComponent.this.mySubStyleSourceAttribute = null;
                    if (item instanceof ProjectThemeResolver.ThemeWithSource) {
                        ThemeEditorComponent.this.myThemeEditorContext.setCurrentThemeModule(((ProjectThemeResolver.ThemeWithSource)item).getSourceModule());
                    }
                    ThemeEditorComponent.this.loadStyleAttributes();
                }
            }
        });
        this.myPanel.getAttrGroupCombo().setModel(new DefaultComboBoxModel<AttributesGrouper.GroupBy>(AttributesGrouper.GroupBy.values()));
        this.myPanel.getAttrGroupCombo().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThemeEditorComponent.this.loadStyleAttributes();
            }
        });
        DefaultActionGroup group = new DefaultActionGroup();
        DeviceMenuAction deviceAction = new DeviceMenuAction(this.myPreviewPanel);
        group.add((AnAction)deviceAction);
        ActionToolbar actionToolbar = actionManager.createActionToolbar("ThemeToolbar", (ActionGroup)group, true);
        actionToolbar.setLayoutPolicy(1);
        JPanel myConfigToolbar = this.myPanel.getConfigToolbar();
        myConfigToolbar.add(actionToolbar.getComponent());
        this.setFirstComponent(this.myPreviewPanel);
        this.setSecondComponent(this.myPanel.getRightPanel());
        this.setShowDividerControls(false);
        this.myMessageBusConnection = project.getMessageBus().connect((Disposable)project);
        this.myMessageBusConnection.subscribe(PostProjectBuildTasksExecutor.GRADLE_BUILD_TOPIC, (Object)new GradleBuildListener(){

            @Override
            public void buildFinished(@NotNull Project project, @Nullable BuildMode mode) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/theme/ThemeEditorComponent$8", "buildFinished"));
                }
                if (project != ThemeEditorComponent.this.myThemeEditorContext.getProject()) {
                    return;
                }
                ThemeEditorComponent.this.myPreviewPanel.reloadComponents();
                ThemeEditorComponent.this.myPreviewPanel.revalidate();
                ThemeEditorComponent.this.myPreviewPanel.repaint();
            }
        });
        this.reload(null);
    }

    private void configureFilter() {
        if (this.myPanel.isAdvancedMode()) {
            this.myAttributesFilter.setFilterEnabled(false);
            this.myAttributesSorter.setRowFilter(this.myAttributesFilter);
        } else {
            this.mySimpleModeFilter.configure((Set<String>)this.myModel.getDefinedAttributes());
            this.myAttributesSorter.setRowFilter(this.mySimpleModeFilter);
        }
    }

    private boolean createNewTheme() {
        ThemeEditorStyle selectedTheme = this.getSelectedStyle();
        String selectedThemeName = selectedTheme == null ? null : selectedTheme.getName();
        String newThemeName = this.createNewStyle(selectedThemeName, null, null, null);
        if (newThemeName != null) {
            this.reload(newThemeName);
            return true;
        }
        return false;
    }

    private boolean selectNewTheme() {
        String newThemeName;
        ThemeSelectionDialog dialog = new ThemeSelectionDialog(this.myThemeEditorContext.getConfiguration());
        if (dialog.showAndGet() && (newThemeName = dialog.getTheme()) != null) {
            this.reload(newThemeName);
            return true;
        }
        return false;
    }

    private boolean renameTheme() {
        assert (this.mySelectedTheme.isProjectStyle());
        PsiElement namePsiElement = this.mySelectedTheme.getNamePsiElement();
        if (namePsiElement == null) {
            return false;
        }
        RenameDialog renameDialog = new RenameDialog(this.myThemeEditorContext.getProject(), namePsiElement, null, null);
        renameDialog.show();
        if (renameDialog.isOK()) {
            String newName = renameDialog.getNewName();
            String newQualifiedName = this.mySelectedTheme.getName().replace(this.mySelectedTheme.getSimpleName(), newName);
            AndroidFacet facet = AndroidFacet.getInstance(this.myThemeEditorContext.getCurrentThemeModule());
            if (facet != null) {
                facet.refreshResources();
            }
            this.reload(newQualifiedName);
            return true;
        }
        return false;
    }

    public void goToParent() {
        ThemeEditorStyle selectedStyle = this.getSelectedStyle();
        if (selectedStyle == null) {
            LOG.error("No style selected.");
            return;
        }
        ThemeEditorStyle parent = this.getSelectedStyle().getParent();
        assert (parent != null);
        if (this.isSubStyleSelected()) {
            this.myCurrentSubStyle = parent;
            this.loadStyleAttributes();
        } else {
            this.myPanel.setSelectedTheme(parent);
        }
    }

    @Nullable
    private String createNewStyle(@Nullable String defaultParentStyleName, @Nullable String message, final @Nullable String newAttributeName, final @Nullable String newAttributeValue) {
        AndroidFacet facet;
        final NewStyleDialog dialog = new NewStyleDialog(!this.isSubStyleSelected(), this.myThemeEditorContext, defaultParentStyleName, this.getSelectedTheme() != null ? this.getSelectedTheme().getSimpleName() : null, message);
        boolean createStyle = dialog.showAndGet();
        if (!createStyle) {
            return null;
        }
        String fileName = AndroidResourceUtil.getDefaultResourceFileName(ResourceType.STYLE);
        List<String> dirNames = Collections.singletonList(ResourceFolderType.VALUES.getName());
        if (fileName == null) {
            LOG.error("Couldn't find a default filename for ResourceType.STYLE");
            return null;
        }
        boolean isCreated = AndroidResourceUtil.createValueResource(this.myThemeEditorContext.getCurrentThemeModule(), dialog.getStyleName(), ResourceType.STYLE, fileName, dirNames, new Processor<ResourceElement>(){

            public boolean process(ResourceElement element) {
                assert (element instanceof Style);
                Style style = (Style)element;
                style.getParentStyle().setStringValue(dialog.getStyleParentName());
                if (!Strings.isNullOrEmpty((String)newAttributeName)) {
                    StyleItem newItem = style.addItem();
                    newItem.getName().setStringValue(newAttributeName);
                    if (!Strings.isNullOrEmpty((String)newAttributeValue)) {
                        newItem.setStringValue(newAttributeValue);
                    }
                }
                return true;
            }
        });
        if (isCreated && (facet = AndroidFacet.getInstance(this.myThemeEditorContext.getCurrentThemeModule())) != null) {
            facet.refreshResources();
        }
        return isCreated ? "@style/" + dialog.getStyleName() : null;
    }

    private void saveCurrentSelectedTheme() {
        ThemeEditorStyle selectedTheme = this.getSelectedStyle();
        this.myPreviousSelectedTheme = selectedTheme == null ? null : selectedTheme.getName();
    }

    @Nullable
    public String getPreviousSelectedTheme() {
        return this.myPreviousSelectedTheme;
    }

    @Nullable
    ThemeEditorStyle getSelectedTheme() {
        return this.mySelectedTheme;
    }

    @NotNull
    private AttributesGrouper.GroupBy getSelectedAttrGroup() {
        AttributesGrouper.GroupBy groupBy = (AttributesGrouper.GroupBy)((Object)this.myPanel.getAttrGroupCombo().getSelectedItem());
        if (groupBy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorComponent", "getSelectedAttrGroup"));
        }
        return groupBy;
    }

    @Nullable
    private ThemeEditorStyle getSelectedStyle() {
        if (this.myCurrentSubStyle != null) {
            return this.myCurrentSubStyle;
        }
        return this.getSelectedTheme();
    }

    @Nullable
    ThemeEditorStyle getCurrentSubStyle() {
        return this.myCurrentSubStyle;
    }

    private boolean isSubStyleSelected() {
        return this.myCurrentSubStyle != null;
    }

    private void createNewThemeWithAttributeValue(@NotNull EditedStyleItem rv, @NotNull String strValue) {
        String sourcePropertyName;
        if (rv == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rv", "com/android/tools/idea/editors/theme/ThemeEditorComponent", "createNewThemeWithAttributeValue"));
        }
        if (strValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strValue", "com/android/tools/idea/editors/theme/ThemeEditorComponent", "createNewThemeWithAttributeValue"));
        }
        if (strValue.equals(rv.getValue())) {
            return;
        }
        ThemeEditorStyle selectedStyle = this.getSelectedStyle();
        if (selectedStyle == null) {
            LOG.error("No style/theme selected.");
            return;
        }
        String newStyleName = this.createNewStyle(selectedStyle.getName(), String.format("<html>The %1$s '<code>%2$s</code>' is Read-Only.<br/>A new %1$s will be created to modify '<code>%3$s</code>'.<br/></html>", this.isSubStyleSelected() ? "style" : "theme", selectedStyle.getName(), rv.getName()), rv.getQualifiedName(), strValue);
        if (newStyleName == null) {
            return;
        }
        if (!this.isSubStyleSelected()) {
            this.reload(newStyleName);
            return;
        }
        ThemeEditorStyle selectedTheme = this.getSelectedTheme();
        if (selectedTheme == null) {
            LOG.error("No theme selected.");
            return;
        }
        String string = sourcePropertyName = this.mySubStyleSourceAttribute.isAttr() ? this.mySubStyleSourceAttribute.getAttrPropertyName() : this.mySubStyleSourceAttribute.getQualifiedName();
        if (selectedTheme.isReadOnly()) {
            String newThemeName = this.createNewStyle(selectedTheme.getName(), String.format("<html>The style '%1$s' which references to '%2$s' is also Read-Only.<br/>A new theme will be created to point to the modified style '%3$s'.<br/></html>", selectedTheme.getName(), rv.getName(), newStyleName), sourcePropertyName, newStyleName);
            if (newThemeName != null) {
                this.reload(newThemeName);
            }
        } else {
            selectedTheme.setValue(sourcePropertyName, newStyleName);
            this.reload(selectedTheme.getName());
        }
    }

    public void reload(@Nullable String defaultThemeName) {
        this.reload(defaultThemeName, null);
    }

    public void reload(@Nullable String defaultThemeName, @Nullable String defaultSubStyleName) {
        Configuration configuration = this.myThemeEditorContext.getConfiguration();
        configuration.setTheme(null);
        this.myStyleResolver = new StyleResolver(configuration);
        this.myCurrentSubStyle = defaultSubStyleName == null ? null : this.myStyleResolver.getStyle(defaultSubStyleName);
        this.mySubStyleSourceAttribute = null;
        ThemeResolver themeResolver = new ThemeResolver(configuration, this.myStyleResolver);
        this.myPanel.getThemeCombo().setModel(new ThemesListModel(this.myProject, themeResolver, defaultThemeName));
        this.loadStyleAttributes();
        this.mySelectedTheme = this.myPanel.getSelectedTheme();
        this.saveCurrentSelectedTheme();
    }

    private void loadStyleAttributes() {
        this.mySelectedTheme = this.myPanel.getSelectedTheme();
        ThemeEditorStyle selectedTheme = this.getSelectedTheme();
        ThemeEditorStyle selectedStyle = this.getSelectedStyle();
        if (selectedTheme == null || selectedStyle == null) {
            LOG.error("No style/theme selected");
            return;
        }
        this.myPanel.setSubstyleName(this.myCurrentSubStyle == null ? null : this.myCurrentSubStyle.getName());
        this.myPanel.getBackButton().setVisible(this.myCurrentSubStyle != null);
        Configuration configuration = this.myThemeEditorContext.getConfiguration();
        configuration.setTheme(selectedTheme.getName());
        assert (configuration.getResourceResolver() != null);
        this.myModel = new AttributesTableModel(selectedStyle, this.getSelectedAttrGroup(), configuration, this.myThemeEditorContext.getProject());
        this.myModel.setGoToDefinitionListener(this.myGoToListener);
        this.myModel.addThemePropertyChangedListener(new AttributesTableModel.ThemePropertyChangedListener(){

            @Override
            public void attributeChangedOnReadOnlyTheme(final EditedStyleItem attribute, final String newValue) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ThemeEditorComponent.this.createNewThemeWithAttributeValue(attribute, newValue);
                    }
                });
            }
        });
        this.myModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(final TableModelEvent e) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (e.getType() == 0) {
                            if (e.getLastRow() == -1) {
                                ThemeEditorComponent.this.myAttributesTable.updateRowHeights();
                            } else if (e.getLastRow() == 0) {
                                ThemeEditorComponent.this.reload(ThemeEditorComponent.this.myPreviousSelectedTheme);
                            }
                        }
                        ThemeEditorComponent.this.myPreviewPanel.invalidateGraphicsRenderer();
                        ThemeEditorComponent.this.myPreviewPanel.revalidate();
                        ThemeEditorComponent.this.myAttributesTable.repaint();
                    }
                });
            }
        });
        this.myAttributesTable.setRowSorter(null);
        this.myAttributesSorter = new TableRowSorter<AttributesTableModel>(this.myModel);
        this.configureFilter();
        this.myAttributesTable.setModel(this.myModel);
        this.myAttributesTable.setRowSorter(this.myAttributesSorter);
        this.myAttributesTable.updateRowHeights();
        this.myPanel.getPalette().setModel(new AttributesModelColorPaletteModel(configuration, this.myModel));
        this.myPanel.getPalette().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AttributesModelColorPaletteModel model = (AttributesModelColorPaletteModel)ThemeEditorComponent.this.myPanel.getPalette().getModel();
                    List<EditedStyleItem> references = model.getReferences((Color)e.getItem());
                    if (references.isEmpty()) {
                        return;
                    }
                    HashSet<String> attributeNames = new HashSet<String>(references.size());
                    for (EditedStyleItem item : references) {
                        attributeNames.add(item.getQualifiedName());
                    }
                    ThemeEditorComponent.this.myAttributesFilter.setAttributesFilter(attributeNames);
                    ThemeEditorComponent.this.myAttributesFilter.setFilterEnabled(true);
                } else {
                    ThemeEditorComponent.this.myAttributesFilter.setFilterEnabled(false);
                }
                if (ThemeEditorComponent.this.myAttributesTable.isEditing()) {
                    ThemeEditorComponent.this.myAttributesTable.getCellEditor().cancelCellEditing();
                }
                ((TableRowSorter)ThemeEditorComponent.this.myAttributesTable.getRowSorter()).sort();
                ThemeEditorComponent.this.myPanel.getAdvancedFilterCheckBox().getModel().setSelected(!((ThemeEditorComponent)ThemeEditorComponent.this).myAttributesFilter.myIsFilterEnabled);
            }
        });
        this.myModel.fireTableStructureChanged();
    }

    public void dispose() {
        this.myThemeEditorContext.dispose();
        this.myMessageBusConnection.disconnect();
        this.myMessageBusConnection = null;
        super.dispose();
    }

    public void setUI(PanelUI ui) {
        super.setUI(ui);
        this.updateUiParameters();
    }

    private void updateUiParameters() {
        Font regularFont = UIUtil.getLabelFont();
        int regularFontSize = this.getFontMetrics(regularFont).getHeight();
        this.myHeaderFont = regularFont.deriveFont((float)regularFontSize * 1.3f);
        if (this.myAttributesTable == null) {
            return;
        }
        int headerFontSize = this.getFontMetrics(this.myHeaderFont).getHeight();
        int bigCellSize = 2 * regularFontSize + 42;
        this.myAttributesTable.setClassHeights((Map<Class<?>, Integer>)ImmutableMap.of(Object.class, (Object)(regularFontSize + 4), Color.class, (Object)bigCellSize, DrawableDomElement.class, (Object)bigCellSize, TableLabel.class, (Object)(headerFontSize + 10)));
    }

    class StyleAttributesFilter
    extends AttributesFilter {
        public StyleAttributesFilter() {
            this.myIsFilterEnabled = true;
            this.filterAttributes = Collections.emptySet();
        }

        public void setFilterEnabled(boolean enabled) {
            this.myIsFilterEnabled = enabled;
        }

        public void setAttributesFilter(@NotNull Set<String> attributeNames) {
            if (attributeNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeNames", "com/android/tools/idea/editors/theme/ThemeEditorComponent$StyleAttributesFilter", "setAttributesFilter"));
            }
            this.filterAttributes = ImmutableSet.copyOf(attributeNames);
        }
    }

    abstract class AttributesFilter
    extends RowFilter<AttributesTableModel, Integer> {
        boolean myIsFilterEnabled;
        Set<String> filterAttributes;

        AttributesFilter() {
        }

        @Override
        public boolean include(RowFilter.Entry<? extends AttributesTableModel, ? extends Integer> entry) {
            if (!this.myIsFilterEnabled) {
                return true;
            }
            int row = entry.getIdentifier();
            if (entry.getModel().isThemeParentRow(row)) {
                return true;
            }
            Object value = entry.getModel().getValueAt(row, 1);
            if (value instanceof TableLabel) {
                return false;
            }
            String attributeName = value instanceof EditedStyleItem ? ((EditedStyleItem)value).getQualifiedName() : value.toString();
            ThemeEditorStyle selectedTheme = ThemeEditorComponent.this.getSelectedStyle();
            if (selectedTheme == null) {
                LOG.error("No theme selected.");
                return false;
            }
            return this.filterAttributes.contains(attributeName);
        }
    }

    class SimpleModeFilter
    extends AttributesFilter {
        public final Set<String> ATTRIBUTES_DEFAULT_FILTER = ImmutableSet.of((Object)"colorPrimary", (Object)"colorPrimaryDark", (Object)"colorAccent", (Object)"colorForeground", (Object)"textColorPrimary", (Object)"textColorSecondary", (Object[])new String[]{"textColorPrimaryInverse", "textColorSecondaryInverse", "colorBackground", "windowBackground", "navigationBarColor", "statusBarColor"});

        public SimpleModeFilter() {
            this.myIsFilterEnabled = true;
            this.filterAttributes = new HashSet();
        }

        public void configure(Set<String> availableAttributes) {
            this.filterAttributes.clear();
            for (String candidate : this.ATTRIBUTES_DEFAULT_FILTER) {
                if (availableAttributes.contains(candidate)) {
                    this.filterAttributes.add(candidate);
                    continue;
                }
                this.filterAttributes.add("android:" + candidate);
            }
        }
    }

    public static interface GoToListener {
        public void goTo(@NotNull EditedStyleItem var1);

        public void goToParent();
    }
}

