/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.intellij.ide.IdeView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public abstract class JavaSourceAction
extends AnAction {
    public JavaSourceAction(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    protected static boolean isAvailable(DataContext dataContext) {
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (module == null || view == null || view.getDirectories().length == 0 || AndroidFacet.getInstance(module) == null) {
            return false;
        }
        ProjectFileIndex projectIndex = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex();
        JavaDirectoryService dirService = JavaDirectoryService.getInstance();
        for (PsiDirectory dir : view.getDirectories()) {
            if (!projectIndex.isUnderSourceRootOfType(dir.getVirtualFile(), JavaModuleSourceRootTypes.SOURCES) || dirService.getPackage(dir) == null || dirService.getPackage(dir).getQualifiedName().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setVisible(JavaSourceAction.isAvailable(e.getDataContext()));
    }

    public abstract void actionPerformed(AnActionEvent var1);
}

