/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.mantis;

import com.intellij.tasks.mantis.MantisFilter;
import com.intellij.tasks.mantis.model.ProjectData;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class MantisProject {
    public static final int UNSPECIFIED_PROJECT_ID = 0;
    private List<MantisFilter> myFilters;
    private int myId;
    private String myName;

    public static MantisProject newUndefined() {
        return new MantisProject(0, "-- from all projects --");
    }

    public MantisProject() {
        this.myFilters = new ArrayList<MantisFilter>();
    }

    public MantisProject(int id, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/tasks/mantis/MantisProject", "<init>"));
        }
        this.myFilters = new ArrayList<MantisFilter>();
        this.myId = id;
        this.myName = name;
    }

    public MantisProject(@NotNull ProjectData data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/tasks/mantis/MantisProject", "<init>"));
        }
        this.myFilters = new ArrayList<MantisFilter>();
        this.myId = data.getId().intValue();
        this.myName = data.getName();
    }

    @Attribute(value="id")
    public int getId() {
        return this.myId;
    }

    public void setId(int id) {
        this.myId = id;
    }

    @Attribute(value="name")
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/mantis/MantisProject", "getName"));
        }
        return string;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/tasks/mantis/MantisProject", "setName"));
        }
        this.myName = name;
    }

    public final boolean isUnspecified() {
        return this.getId() == 0;
    }

    @Transient
    @NotNull
    public List<MantisFilter> getFilters() {
        List<Object> list = this.myFilters == null ? Collections.emptyList() : this.myFilters;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/mantis/MantisProject", "getFilters"));
        }
        return list;
    }

    public void setFilters(@NotNull List<MantisFilter> filters) {
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/tasks/mantis/MantisProject", "setFilters"));
        }
        this.myFilters = filters;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MantisProject project = (MantisProject)o;
        return this.myId == project.myId;
    }

    public final int hashCode() {
        return this.myId;
    }

    public String toString() {
        return this.getName();
    }
}

