/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.bugzilla;

import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.bugzilla.BugzillaRepository;
import icons.TasksIcons;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BugzillaTask
extends Task {
    private final Hashtable<String, Object> myResponse;
    private final BugzillaRepository myRepository;

    public BugzillaTask(@NotNull Hashtable<String, Object> xmlRpcResponse, @NotNull BugzillaRepository repository) {
        if (xmlRpcResponse == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlRpcResponse", "com/intellij/tasks/bugzilla/BugzillaTask", "<init>"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/tasks/bugzilla/BugzillaTask", "<init>"));
        }
        this.myResponse = xmlRpcResponse;
        this.myRepository = repository;
    }

    @NotNull
    public String getId() {
        String string = String.valueOf(this.myResponse.get("id"));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/bugzilla/BugzillaTask", "getId"));
        }
        return string;
    }

    @NotNull
    public String getSummary() {
        String string = (String)this.myResponse.get("summary");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/bugzilla/BugzillaTask", "getSummary"));
        }
        return string;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @NotNull
    public Comment[] getComments() {
        if (Comment.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/bugzilla/BugzillaTask", "getComments"));
        }
        return Comment.EMPTY_ARRAY;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = TasksIcons.Bugzilla;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/bugzilla/BugzillaTask", "getIcon"));
        }
        return icon;
    }

    @NotNull
    public TaskType getType() {
        String severity = (String)this.myResponse.get("severity");
        TaskType taskType = severity.equalsIgnoreCase("enhancement") ? TaskType.FEATURE : TaskType.BUG;
        if (taskType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/bugzilla/BugzillaTask", "getType"));
        }
        return taskType;
    }

    @Nullable
    public TaskState getState() {
        String status = (String)this.myResponse.get("status");
        if (status.equals("IN_PROGRESS")) {
            return TaskState.IN_PROGRESS;
        }
        if (status.equals("CONFIRMED")) {
            return TaskState.OPEN;
        }
        if (status.equals("UNCONFIRMED")) {
            return TaskState.SUBMITTED;
        }
        if (status.equals("RESOLVED")) {
            return TaskState.RESOLVED;
        }
        return TaskState.OTHER;
    }

    @Nullable
    public Date getUpdated() {
        return (Date)this.myResponse.get("last_change_time");
    }

    @Nullable
    public Date getCreated() {
        return (Date)this.myResponse.get("creation_time");
    }

    public boolean isClosed() {
        return (Boolean)this.myResponse.get("is_open") == false;
    }

    public boolean isIssue() {
        return true;
    }

    @Nullable
    public String getIssueUrl() {
        String repositoryUrl = this.myRepository.getUrl();
        if (repositoryUrl.endsWith("xmlrpc.cgi")) {
            repositoryUrl = repositoryUrl.substring(0, repositoryUrl.length() - "xmlrpc.cgi".length());
        }
        return repositoryUrl + "/show_bug.cgi?id=" + this.getId();
    }

    @Nullable
    public TaskRepository getRepository() {
        return this.myRepository;
    }
}

