/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.config;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.impl.storage.ClasspathStorageProvider;
import java.io.IOException;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.eclipse.config.CachedXmlDocumentSet;
import org.jetbrains.idea.eclipse.config.ClasspathSaveSession;
import org.jetbrains.idea.eclipse.config.EclipseClasspathStorageProvider;
import org.jetbrains.idea.eclipse.conversion.EclipseClasspathReader;
import org.jetbrains.idea.eclipse.conversion.IdeaSpecificSettings;

public final class EclipseClasspathConverter
implements ClasspathStorageProvider.ClasspathConverter {
    private final Module module;

    public EclipseClasspathConverter(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/idea/eclipse/config/EclipseClasspathConverter", "<init>"));
        }
        this.module = module;
    }

    @NotNull
    public List<String> getFilePaths() {
        List<String> list = this.getFileSet().getFilePaths();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/eclipse/config/EclipseClasspathConverter", "getFilePaths"));
        }
        return list;
    }

    @NotNull
    public ClasspathSaveSession startExternalization() {
        ClasspathSaveSession classpathSaveSession = new ClasspathSaveSession(this.module);
        if (classpathSaveSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/eclipse/config/EclipseClasspathConverter", "startExternalization"));
        }
        return classpathSaveSession;
    }

    @NotNull
    public CachedXmlDocumentSet getFileSet() {
        CachedXmlDocumentSet cachedXmlDocumentSet = EclipseClasspathStorageProvider.getFileCache(this.module);
        if (cachedXmlDocumentSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/eclipse/config/EclipseClasspathConverter", "getFileSet"));
        }
        return cachedXmlDocumentSet;
    }

    public void readClasspath(@NotNull ModifiableRootModel model) throws IOException {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/idea/eclipse/config/EclipseClasspathConverter", "readClasspath"));
        }
        try {
            CachedXmlDocumentSet fileSet = this.getFileSet();
            String path = fileSet.getParent(".project");
            Element classpath = null;
            if (!fileSet.exists(".project")) {
                classpath = fileSet.load(".classpath", false);
                if (classpath == null) {
                    return;
                }
                path = fileSet.getParent(".classpath");
            }
            EclipseClasspathReader classpathReader = new EclipseClasspathReader(path, this.module.getProject(), null);
            classpathReader.init(model);
            if (classpath == null) {
                classpath = fileSet.load(".classpath", false);
            }
            if (classpath == null) {
                EclipseClasspathReader.setOutputUrl(model, path + "/bin");
            } else {
                classpathReader.readClasspath(model, classpath);
            }
            Element eml = fileSet.load(model.getModule().getName() + ".eml", false);
            if (eml == null) {
                ((CompilerModuleExtension)model.getModuleExtension(CompilerModuleExtension.class)).setExcludeOutput(false);
            } else {
                new IdeaSpecificSettings().readIdeaSpecific(eml, model, null, null);
            }
        }
        catch (JDOMException e) {
            throw new IOException(e);
        }
    }
}

