/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.ast.KeywordModifier;

class KeywordModifierTemplate {
    private static final BiMap<String, Integer> REFLECT_MODIFIERS = ImmutableBiMap.builder().put((Object)"public", (Object)1).put((Object)"private", (Object)2).put((Object)"protected", (Object)4).put((Object)"static", (Object)8).put((Object)"final", (Object)16).put((Object)"synchronized", (Object)32).put((Object)"volatile", (Object)64).put((Object)"transient", (Object)128).put((Object)"native", (Object)256).put((Object)"abstract", (Object)1024).put((Object)"strictfp", (Object)2048).build();
    String name1;

    KeywordModifierTemplate() {
    }

    static String getDescription(KeywordModifier self) {
        return self.astName();
    }

    static int asReflectModifiers(KeywordModifier self) {
        Integer value = (Integer)REFLECT_MODIFIERS.get((Object)self.astName());
        return value == null ? 0 : value;
    }

    static KeywordModifier fromReflectModifier(int modifierFlag) {
        String keyword = (String)REFLECT_MODIFIERS.inverse().get((Object)modifierFlag);
        return keyword == null ? null : new KeywordModifier().astName(keyword);
    }

    static List<KeywordModifier> fromReflectModifiers(int modifierFlags) {
        ArrayList list = Lists.newArrayList();
        for (Map.Entry entry : REFLECT_MODIFIERS.inverse().entrySet()) {
            if ((modifierFlags & (Integer)entry.getKey()) == 0) continue;
            list.add(KeywordModifier.fromReflectModifier((Integer)entry.getKey()));
        }
        return list;
    }

    static KeywordModifier STATIC() {
        return new KeywordModifier().astName("static");
    }

    static KeywordModifier PUBLIC() {
        return new KeywordModifier().astName("public");
    }

    static KeywordModifier PROTECTED() {
        return new KeywordModifier().astName("protected");
    }

    static KeywordModifier PRIVATE() {
        return new KeywordModifier().astName("private");
    }

    static KeywordModifier FINAL() {
        return new KeywordModifier().astName("final");
    }
}

