/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Block;
import lombok.ast.Expression;
import lombok.ast.ForTemplate;
import lombok.ast.ListAccessor;
import lombok.ast.Node;
import lombok.ast.RawListAccessor;
import lombok.ast.Statement;
import lombok.ast.StrictListAccessor;
import lombok.ast.VariableDefinition;

public class For
extends AbstractNode
implements Statement {
    ListAccessor<Expression, For> expressionInits = ListAccessor.of(this, Expression.class, "For.expressionInits");
    private AbstractNode variableDeclaration = null;
    private AbstractNode condition = null;
    ListAccessor<Expression, For> updates = ListAccessor.of(this, Expression.class, "For.updates");
    private AbstractNode statement = null;

    @Override
    public Block upToBlock() {
        if (!(this.getParent() instanceof Block)) {
            return null;
        }
        Block out = (Block)this.getParent();
        if (!out.rawContents().contains(this)) {
            return null;
        }
        return out;
    }

    public RawListAccessor<Expression, For> rawExpressionInits() {
        return this.expressionInits.asRaw();
    }

    public StrictListAccessor<Expression, For> astExpressionInits() {
        return this.expressionInits.asStrict();
    }

    public VariableDefinition astVariableDeclaration() {
        if (!(this.variableDeclaration instanceof VariableDefinition)) {
            return null;
        }
        return (VariableDefinition)this.variableDeclaration;
    }

    public For astVariableDeclaration(VariableDefinition variableDeclaration) {
        return this.rawVariableDeclaration(variableDeclaration);
    }

    public Node rawVariableDeclaration() {
        return this.variableDeclaration;
    }

    public For rawVariableDeclaration(Node variableDeclaration) {
        if (variableDeclaration == this.variableDeclaration) {
            return this;
        }
        if (variableDeclaration != null) {
            this.adopt((AbstractNode)variableDeclaration);
        }
        if (this.variableDeclaration != null) {
            this.disown(this.variableDeclaration);
        }
        this.variableDeclaration = (AbstractNode)variableDeclaration;
        return this;
    }

    public Expression astCondition() {
        if (!(this.condition instanceof Expression)) {
            return null;
        }
        return (Expression)((Object)this.condition);
    }

    public For astCondition(Expression condition) {
        return this.rawCondition(condition);
    }

    public Node rawCondition() {
        return this.condition;
    }

    public For rawCondition(Node condition) {
        if (condition == this.condition) {
            return this;
        }
        if (condition != null) {
            this.adopt((AbstractNode)condition);
        }
        if (this.condition != null) {
            this.disown(this.condition);
        }
        this.condition = (AbstractNode)condition;
        return this;
    }

    public RawListAccessor<Expression, For> rawUpdates() {
        return this.updates.asRaw();
    }

    public StrictListAccessor<Expression, For> astUpdates() {
        return this.updates.asStrict();
    }

    public Statement astStatement() {
        if (!(this.statement instanceof Statement)) {
            return null;
        }
        return (Statement)((Object)this.statement);
    }

    public For astStatement(Statement statement) {
        if (statement == null) {
            throw new NullPointerException("statement is mandatory");
        }
        return this.rawStatement(statement);
    }

    public Node rawStatement() {
        return this.statement;
    }

    public For rawStatement(Node statement) {
        if (statement == this.statement) {
            return this;
        }
        if (statement != null) {
            this.adopt((AbstractNode)statement);
        }
        if (this.statement != null) {
            this.disown(this.statement);
        }
        this.statement = (AbstractNode)statement;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        result.addAll(this.expressionInits.backingList());
        if (this.variableDeclaration != null) {
            result.add(this.variableDeclaration);
        }
        if (this.condition != null) {
            result.add(this.condition);
        }
        result.addAll(this.updates.backingList());
        if (this.statement != null) {
            result.add(this.statement);
        }
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.rawExpressionInits().replace(original, replacement)) {
            return true;
        }
        if (this.variableDeclaration == original) {
            this.rawVariableDeclaration(replacement);
            return true;
        }
        if (this.condition == original) {
            this.rawCondition(replacement);
            return true;
        }
        if (this.rawUpdates().replace(original, replacement)) {
            return true;
        }
        if (this.statement == original) {
            this.rawStatement(replacement);
            return true;
        }
        return false;
    }

    @Override
    public boolean detach(Node child) {
        if (this.rawExpressionInits().remove(child)) {
            return true;
        }
        if (this.variableDeclaration == child) {
            this.disown((AbstractNode)child);
            this.variableDeclaration = null;
            return true;
        }
        if (this.condition == child) {
            this.disown((AbstractNode)child);
            this.condition = null;
            return true;
        }
        if (this.rawUpdates().remove(child)) {
            return true;
        }
        if (this.statement == child) {
            this.disown((AbstractNode)child);
            this.statement = null;
            return true;
        }
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitFor(this)) {
            return;
        }
        for (AbstractNode child : this.expressionInits.asIterable()) {
            child.accept(visitor);
        }
        if (this.variableDeclaration != null) {
            this.variableDeclaration.accept(visitor);
        }
        if (this.condition != null) {
            this.condition.accept(visitor);
        }
        for (AbstractNode child : this.updates.asIterable()) {
            child.accept(visitor);
        }
        if (this.statement != null) {
            this.statement.accept(visitor);
        }
        visitor.afterVisitFor(this);
        visitor.endVisit(this);
    }

    @Override
    public For copy() {
        For result = new For();
        for (AbstractNode n : this.expressionInits.backingList()) {
            result.rawExpressionInits().addToEnd(n == null ? null : n.copy());
        }
        if (this.variableDeclaration != null) {
            result.rawVariableDeclaration(this.variableDeclaration.copy());
        }
        if (this.condition != null) {
            result.rawCondition(this.condition.copy());
        }
        for (AbstractNode n : this.updates.backingList()) {
            result.rawUpdates().addToEnd(n == null ? null : n.copy());
        }
        if (this.statement != null) {
            result.rawStatement(this.statement.copy());
        }
        return result;
    }

    public boolean isVariableDeclarationBased() {
        return ForTemplate.isVariableDeclarationBased(this);
    }

    public boolean isStatementExpressionsBased() {
        return ForTemplate.isStatementExpressionsBased(this);
    }
}

