/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classloader;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import org.gradle.api.GradleException;
import org.gradle.internal.classloader.MutableURLClassLoader;
import org.gradle.internal.classpath.ClassPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransformingClassLoader
extends MutableURLClassLoader {
    public TransformingClassLoader(ClassLoader parent, ClassPath classPath) {
        super(parent, classPath);
    }

    public TransformingClassLoader(ClassLoader parent, Collection<URL> urls) {
        super(parent, urls);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] bytes;
        URL resource = this.findResource(name.replace(".", "/") + ".class");
        if (resource == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            bytes = this.loadBytecode(resource);
            bytes = this.transform(bytes);
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not load class '%s' from %s.", name, resource), e);
        }
        return this.defineClass(name, bytes, 0, bytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadBytecode(URL resource) throws IOException {
        InputStream inputStream = resource.openStream();
        try {
            byte[] byArray = ByteStreams.toByteArray((InputStream)inputStream);
            return byArray;
        }
        finally {
            inputStream.close();
        }
    }

    protected abstract byte[] transform(byte[] var1);
}

