/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame;

import com.android.ide.common.blame.SourceFile;
import com.google.common.base.Strings;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.IOException;

public class SourceFileJsonTypeAdapter
extends TypeAdapter<SourceFile> {
    private static final String PATH = "path";
    private static final String DESCRIPTION = "description";

    public void write(JsonWriter out, SourceFile src) throws IOException {
        File file = src.getSourceFile();
        String description = src.getDescription();
        if (description == null && file != null) {
            out.value(file.getAbsolutePath());
            return;
        }
        out.beginObject();
        if (description != null) {
            out.name(DESCRIPTION).value(description);
        }
        if (file != null) {
            out.name(PATH).value(file.getAbsolutePath());
        }
        out.endObject();
    }

    public SourceFile read(JsonReader in) throws IOException {
        switch (in.peek()) {
            case BEGIN_OBJECT: {
                in.beginObject();
                String filePath = null;
                String description = null;
                while (in.hasNext()) {
                    String name = in.nextName();
                    if (name.equals(PATH)) {
                        filePath = in.nextString();
                        continue;
                    }
                    if (DESCRIPTION.equals(name)) {
                        description = in.nextString();
                        continue;
                    }
                    in.skipValue();
                }
                in.endObject();
                if (!Strings.isNullOrEmpty(filePath)) {
                    File file = new File(filePath);
                    if (!Strings.isNullOrEmpty(description)) {
                        return new SourceFile(file, description);
                    }
                    return new SourceFile(file);
                }
                if (!Strings.isNullOrEmpty(description)) {
                    return new SourceFile(description);
                }
                return SourceFile.UNKNOWN;
            }
            case STRING: {
                String fileName = in.nextString();
                if (Strings.isNullOrEmpty((String)fileName)) {
                    return SourceFile.UNKNOWN;
                }
                return new SourceFile(new File(fileName));
            }
        }
        return SourceFile.UNKNOWN;
    }
}

