/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.util.SmartList;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.actions.CommitToIcsActionKt;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"/\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011C)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\"A\u0003\u0002\t\u0005)\u0011\u0001\u0003\t\u0006\u0001\u0015\t\u00012\u0002\u0003\u0002\u0019\u0001I\u0012\u0001'\u0001\"\u000e%\u0019\u0001\"A\u0007\u00021\u0007\t6!\u0001\u0005\u0003K\u001dAA!D\u0001\u0019\ne\u0019\u0001\"B\u0007\u00021\u000f)c\u0001c\u0003\u000e\t%\u0011\u0011\"\u0001M\u00041\u0019)3\u0001#\u0004\u000e\u0003a9\u0011f\u0002\u0003B\u0011!\tQ\"\u0001M\u0002#\u000e\tQ\u0001A\u0015\f\t\u0005c\u0002RA\u0007\u0006\u0013\tI\u0011\u0001g\u0002\r\u0002a\u0019\u0011kA\u0001\u0006\u0001\u0001"}, strings={"Lorg/jetbrains/settingsRepository/actions/ProjectChangeCollectConsumer;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "projectChanges", "", "Lcom/intellij/openapi/vcs/changes/Change;", "consume", "", "change", "getResult", "", "hasResult", ""}, moduleName="settings-repository")
public final class ProjectChangeCollectConsumer {
    private List<Change> projectChanges;
    private final Project project;

    public final void consume(@NotNull Change change) {
        Intrinsics.checkParameterIsNotNull((Object)change, (String)"change");
        if (CommitToIcsActionKt.access$isProjectConfigFile(change.getVirtualFile(), this.project)) {
            if (this.projectChanges == null) {
                this.projectChanges = (List)new SmartList();
            }
            List<Change> list = this.projectChanges;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            list.add(change);
        }
    }

    @NotNull
    public final List<Change> getResult() {
        List<Change> list;
        if (this.projectChanges == null) {
            list = CollectionsKt.listOf();
        } else {
            list = this.projectChanges;
            if (list == null) {
                Intrinsics.throwNpe();
            }
        }
        return list;
    }

    public final boolean hasResult() {
        return this.projectChanges != null;
    }

    public ProjectChangeCollectConsumer(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
    }
}

