/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository;

import com.intellij.openapi.options.ConfigurableUi;
import java.awt.Component;
import javax.swing.JPanel;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.IcsConfigurableForm;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.IcsSettings;
import org.jetbrains.settingsRepository.IcsSettingsKt;
import org.jetbrains.settingsRepository.ReadOnlySourcesEditorKt;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"/\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\t\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!-Q\u0001\u0001\u0007\u00013\u0011I!!C\u0001\u0019\u0003a\u0005\u0011UA)\u0004\u0003!\rQ\u0005\u0003\u0003\f\u0011\u000fi\u0011\u0001\u0007\u0003\u001a\u0007!%Q\"\u0001\r\u0002K!!1\u0002C\u0003\u000e\u000bA1QC\u0001G\u00011\u0017AZ!\n\u0005\u0005\u0017!5Q\"\u0001\r\b3\rAI!D\u0001\u0019\u0003\u0015BAa\u0003E\b\u001b\u0005AB!G\u0002\t\n5\t\u0001$A\u0015\b\t\u0005C\u0001BA\u0007\u00021\u000b\t6!A\u0003\u0001S)!\u0011\t\u0003\u0005\u0004\u001b\u0011I!!C\u0001\u0019\u0003a\u0005\u0011kA\u0001\u0006\u0001\u0001"}, strings={"Lorg/jetbrains/settingsRepository/IcsConfigurableUi;", "Lcom/intellij/openapi/options/ConfigurableUi;", "Lorg/jetbrains/settingsRepository/IcsSettings;", "()V", "panel", "Lorg/jetbrains/settingsRepository/IcsConfigurableForm;", "readOnlyEditor", "apply", "", "settings", "getComponent", "Ljavax/swing/JPanel;", "kotlin.jvm.PlatformType", "isModified", "", "reset"}, moduleName="settings-repository")
public final class IcsConfigurableUi
implements ConfigurableUi<IcsSettings> {
    private final IcsConfigurableForm panel = new IcsConfigurableForm();
    private final ConfigurableUi<IcsSettings> readOnlyEditor = ReadOnlySourcesEditorKt.createReadOnlySourcesEditor();

    public void reset(@NotNull IcsSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        this.panel.autoSyncCheckBox.setSelected(settings.getAutoSync());
        this.readOnlyEditor.reset((Object)settings);
    }

    public boolean isModified(@NotNull IcsSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        return this.panel.autoSyncCheckBox.isSelected() != settings.getAutoSync() || this.readOnlyEditor.isModified((Object)settings);
    }

    public void apply(@NotNull IcsSettings settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        settings.setAutoSync(this.panel.autoSyncCheckBox.isSelected());
        this.readOnlyEditor.apply((Object)settings);
        IcsSettingsKt.saveSettings(settings, IcsManagerKt.getIcsManager().getSettingsFile());
    }

    public JPanel getComponent() {
        return this.panel.rootPanel;
    }

    public IcsConfigurableUi() {
        this.panel.readOnlySourcesPanel.add((Component)this.readOnlyEditor.getComponent(), "Center");
    }
}

