/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.navigation;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SortedList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.inspections.DescriptionCheckerUtil;
import org.jetbrains.idea.devkit.inspections.DescriptionType;
import org.jetbrains.idea.devkit.inspections.InspectionDescriptionInfo;
import org.jetbrains.idea.devkit.navigation.DevkitRelatedLineMarkerProviderBase;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class DescriptionTypeRelatedItemLineMarkerProvider
extends DevkitRelatedLineMarkerProviderBase {
    private static final NotNullFunction<PsiFile, Collection<? extends PsiElement>> CONVERTER = new NotNullFunction<PsiFile, Collection<? extends PsiElement>>(){

        @NotNull
        public Collection<? extends PsiElement> fun(PsiFile psiFile) {
            List list = ContainerUtil.createMaybeSingletonList((Object)psiFile);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/navigation/DescriptionTypeRelatedItemLineMarkerProvider$1", "fun"));
            }
            return list;
        }
    };
    private static final NotNullFunction<PsiFile, Collection<? extends GotoRelatedItem>> RELATED_ITEM_PROVIDER = new NotNullFunction<PsiFile, Collection<? extends GotoRelatedItem>>(){

        @NotNull
        public Collection<? extends GotoRelatedItem> fun(PsiFile psiFile) {
            List list = GotoRelatedItem.createItems(Collections.singleton(psiFile), (String)"DevKit");
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/navigation/DescriptionTypeRelatedItemLineMarkerProvider$2", "fun"));
            }
            return list;
        }
    };

    protected void collectNavigationMarkers(@NotNull PsiElement element, Collection<? super RelatedItemLineMarkerInfo> result) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/devkit/navigation/DescriptionTypeRelatedItemLineMarkerProvider", "collectNavigationMarkers"));
        }
        if (element instanceof PsiClass) {
            DescriptionTypeRelatedItemLineMarkerProvider.process((PsiClass)element, result);
        }
    }

    private static void process(PsiClass psiClass, Collection<? super RelatedItemLineMarkerInfo> result) {
        if (!PsiUtil.isInstantiable(psiClass)) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module == null) {
            return;
        }
        PsiIdentifier highlightingElement = psiClass.getNameIdentifier();
        if (highlightingElement == null) {
            return;
        }
        for (DescriptionType type : DescriptionType.values()) {
            if (!InheritanceUtil.isInheritor((PsiClass)psiClass, (String)type.getClassName())) continue;
            String descriptionDirName = DescriptionCheckerUtil.getDescriptionDirName(psiClass);
            if (StringUtil.isEmptyOrSpaces((String)descriptionDirName)) {
                return;
            }
            if (type == DescriptionType.INSPECTION) {
                InspectionDescriptionInfo info = InspectionDescriptionInfo.create(module, psiClass);
                if (info.hasDescriptionFile()) {
                    DescriptionTypeRelatedItemLineMarkerProvider.addDescriptionFileGutterIcon((PsiElement)highlightingElement, info.getDescriptionFile(), result);
                }
                return;
            }
            for (PsiDirectory descriptionDir : DescriptionCheckerUtil.getDescriptionsDirs(module, type)) {
                PsiFile descriptionFile;
                PsiDirectory dir = descriptionDir.findSubdirectory(descriptionDirName);
                if (dir == null || (descriptionFile = dir.findFile("description.html")) == null) continue;
                DescriptionTypeRelatedItemLineMarkerProvider.addDescriptionFileGutterIcon((PsiElement)highlightingElement, descriptionFile, result);
                DescriptionTypeRelatedItemLineMarkerProvider.addBeforeAfterTemplateFilesGutterIcon((PsiElement)highlightingElement, dir, result);
                return;
            }
            return;
        }
    }

    private static void addDescriptionFileGutterIcon(PsiElement highlightingElement, PsiFile descriptionFile, Collection<? super RelatedItemLineMarkerInfo> result) {
        RelatedItemLineMarkerInfo info = NavigationGutterIconBuilder.create((Icon)AllIcons.FileTypes.Html, CONVERTER, RELATED_ITEM_PROVIDER).setTarget((Object)descriptionFile).setTooltipText("Description").setAlignment(GutterIconRenderer.Alignment.RIGHT).createLineMarkerInfo(highlightingElement);
        result.add((RelatedItemLineMarkerInfo)info);
    }

    private static void addBeforeAfterTemplateFilesGutterIcon(PsiElement highlightingElement, PsiDirectory descriptionDirectory, Collection<? super RelatedItemLineMarkerInfo> result) {
        SortedList templateFiles = new SortedList((Comparator)new Comparator<PsiFile>(){

            @Override
            public int compare(PsiFile o1, PsiFile o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (PsiFile file : descriptionDirectory.getFiles()) {
            String fileName = file.getName();
            if (!fileName.endsWith(".template") || !fileName.startsWith("after.") && !fileName.startsWith("before.")) continue;
            templateFiles.add(file);
        }
        if (templateFiles.isEmpty()) {
            return;
        }
        RelatedItemLineMarkerInfo info = NavigationGutterIconBuilder.create((Icon)AllIcons.Actions.Diff, CONVERTER, RELATED_ITEM_PROVIDER).setTargets((Collection)templateFiles).setPopupTitle("Select Template").setTooltipText("Before/After Templates").setAlignment(GutterIconRenderer.Alignment.RIGHT).createLineMarkerInfo(highlightingElement);
        result.add((RelatedItemLineMarkerInfo)info);
    }
}

